/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.migrator;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.migrator.ConnectorMigrationUi;
import org.eclipse.mylyn.internal.tasks.ui.migrator.JobListener;
import org.eclipse.mylyn.internal.tasks.ui.migrator.Messages;
import org.eclipse.mylyn.internal.tasks.ui.migrator.TaskPredicates;
import org.eclipse.mylyn.internal.tasks.ui.migrator.TasksState;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.sync.SynchronizationJob;
import org.eclipse.osgi.util.NLS;

public class ConnectorMigrator {
    private static final ImmutableSet<String> EXCLUDED_REPOSITORY_PROPERTIES = ImmutableSet.of((Object)"kind", (Object)"lastsynctimestamp", (Object)"url");
    private final Map<String, String> connectorKinds;
    private final String explanatoryText;
    private final TasksState tasksState;
    private List<String> connectorsToMigrate = ImmutableList.of();
    private final ConnectorMigrationUi migrationUi;
    private final Map<TaskRepository, TaskRepository> repositories = new HashMap<TaskRepository, TaskRepository>();
    private final Table<TaskRepository, String, OldTaskState> oldTasksStates = HashBasedTable.create();
    private Map<ITask, AbstractTaskCategory> categories;
    private final JobListener syncTaskJobListener = new JobListener(new Runnable(){

        @Override
        public void run() {
            ConnectorMigrator.this.completeMigration();
        }
    });
    private boolean anyQueriesMigrated;
    private boolean allQueriesMigrated = true;

    public ConnectorMigrator(Map<String, String> connectorKinds, String explanatoryText, TasksState tasksState, ConnectorMigrationUi migrationUi) {
        Preconditions.checkArgument((!connectorKinds.isEmpty() ? 1 : 0) != 0);
        this.connectorKinds = connectorKinds;
        this.explanatoryText = explanatoryText;
        this.migrationUi = migrationUi;
        this.tasksState = tasksState;
    }

    public Map<String, String> getConnectorKinds() {
        return ImmutableMap.copyOf(this.connectorKinds);
    }

    public String getExplanatoryText() {
        return this.explanatoryText;
    }

    public boolean needsMigration() {
        for (Map.Entry<String, String> entry : this.connectorKinds.entrySet()) {
            String oldKind = entry.getKey();
            String newKind = entry.getValue();
            if (this.getRepositoryManager().getRepositoryConnector(oldKind) == null || this.getRepositoryManager().getRepositoryConnector(newKind) == null || this.getRepositoryManager().getRepositories(oldKind).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void setConnectorsToMigrate(List<String> connectors) {
        Preconditions.checkArgument((boolean)this.connectorKinds.keySet().containsAll(connectors));
        this.connectorsToMigrate = ImmutableList.copyOf(connectors);
    }

    protected void migrateConnectors(IProgressMonitor monitor) throws IOException {
        ArrayList<TaskRepository> failedValidation = new ArrayList<TaskRepository>();
        List<TaskRepository> oldRepositories = this.gatherRepositoriesToMigrate(this.connectorsToMigrate);
        monitor.beginTask(Messages.ConnectorMigrator_Migrating_repositories, oldRepositories.size() + 1);
        this.getMigrationUi().backupTaskList(monitor);
        for (TaskRepository repository : oldRepositories) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.subTask(NLS.bind((String)Messages.ConnectorMigrator_Migrating_X, (Object)repository.getRepositoryLabel()));
            String kind = repository.getConnectorKind();
            String newKind = this.getConnectorKinds().get(kind);
            TaskRepository newRepository = this.getMigratedRepository(newKind, repository);
            this.getRepositoryManager().addRepository(newRepository);
            this.repositories.put(repository, newRepository);
            Set tasksToMigrate = Sets.filter((Set)this.getTaskList().getTasks(repository.getRepositoryUrl()), TaskPredicates.isTaskForConnector(repository.getConnectorKind()));
            for (ITask task : tasksToMigrate) {
                this.oldTasksStates.put((Object)newRepository, (Object)task.getTaskKey(), (Object)new OldTaskState(task));
            }
            this.migrateQueries(repository, newRepository, monitor);
            this.disconnect(repository);
            monitor.worked(1);
        }
        ImmutableSet newRepositories = ImmutableSet.copyOf(this.repositories.values());
        monitor.beginTask(Messages.ConnectorMigrator_Validating_repository_connections, newRepositories.size());
        for (TaskRepository newRepository : newRepositories) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.subTask(NLS.bind((String)Messages.ConnectorMigrator_Validating_connection_to_X, (Object)newRepository.getRepositoryLabel()));
            AbstractRepositoryConnector newConnector = this.getRepositoryManager().getRepositoryConnector(newRepository.getConnectorKind());
            try {
                newConnector.validateRepository(newRepository, monitor);
            }
            catch (UnsupportedOperationException | CoreException e) {
                failedValidation.add(newRepository);
            }
            monitor.worked(1);
        }
        monitor.done();
        if (!failedValidation.isEmpty()) {
            this.getMigrationUi().warnOfValidationFailure(failedValidation);
        }
    }

    protected void migrateQueries(TaskRepository repository, TaskRepository newRepository, IProgressMonitor monitor) {
        Set queriesForUrl = this.getTaskList().getRepositoryQueries(repository.getRepositoryUrl());
        Set queries = Sets.filter((Set)queriesForUrl, TaskPredicates.isQueryForConnector(repository.getConnectorKind()));
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ConnectorMigrator_Migrating_Queries, (int)queries.size());
        for (RepositoryQuery query : queries) {
            RepositoryQuery migratedQuery = this.migrateQuery(query, repository, newRepository, (IProgressMonitor)subMonitor);
            if (migratedQuery != null) {
                this.getTaskList().addQuery(migratedQuery);
                this.anyQueriesMigrated = true;
            } else {
                this.allQueriesMigrated = false;
            }
            subMonitor.worked(1);
        }
    }

    protected RepositoryQuery migrateQuery(RepositoryQuery query, TaskRepository repository, TaskRepository newRepository, IProgressMonitor monitor) {
        return null;
    }

    protected boolean anyQueriesMigrated() {
        return this.anyQueriesMigrated;
    }

    protected boolean allQueriesMigrated() {
        return this.allQueriesMigrated;
    }

    protected void disconnect(TaskRepository repository) {
        repository.setOffline(true);
        repository.setRepositoryLabel(NLS.bind((String)Messages.ConnectorMigrator_X_Unsupported_do_not_delete, (Object)repository.getRepositoryLabel()));
        Set queriesForUrl = this.getTaskList().getRepositoryQueries(repository.getRepositoryUrl());
        for (RepositoryQuery query : Sets.filter((Set)queriesForUrl, TaskPredicates.isQueryForConnector(repository.getConnectorKind()))) {
            query.setAutoUpdate(false);
        }
    }

    protected List<TaskRepository> gatherRepositoriesToMigrate(List<String> connectors) {
        ArrayList<TaskRepository> oldRepositories = new ArrayList<TaskRepository>();
        for (String kind : connectors) {
            oldRepositories.addAll(this.getRepositoryManager().getRepositories(kind));
        }
        return oldRepositories;
    }

    protected TaskRepository getMigratedRepository(String newKind, TaskRepository oldRepository) {
        String migratedRepositoryUrl = this.getMigratedRepositoryUrl(oldRepository);
        TaskRepository newRepository = this.getRepositoryManager().getRepository(newKind, migratedRepositoryUrl);
        if (newRepository == null) {
            newRepository = this.migrateRepository(newKind, migratedRepositoryUrl, oldRepository);
        }
        return newRepository;
    }

    protected String getMigratedRepositoryUrl(TaskRepository oldRepository) {
        return oldRepository.getRepositoryUrl();
    }

    protected TaskRepository migrateRepository(String newKind, String migratedRepositoryUrl, TaskRepository oldRepository) {
        TaskRepository newRepository = new TaskRepository(newKind, migratedRepositoryUrl);
        for (Map.Entry entry : oldRepository.getProperties().entrySet()) {
            if (EXCLUDED_REPOSITORY_PROPERTIES.contains(entry.getKey())) continue;
            newRepository.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        AuthenticationType[] authenticationTypeArray = AuthenticationType.values();
        int n = authenticationTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AuthenticationType type = authenticationTypeArray[n2];
            AuthenticationCredentials credentials = oldRepository.getCredentials(type);
            newRepository.setCredentials(type, credentials, oldRepository.getSavePassword(type));
            ++n2;
        }
        return newRepository;
    }

    protected void migrateTasks(IProgressMonitor monitor) {
        this.tasksState.getTaskActivityManager().deactivateActiveTask();
        for (Map.Entry<TaskRepository, TaskRepository> entry : this.repositories.entrySet()) {
            TaskRepository oldRepository = entry.getKey();
            TaskRepository newRepository = entry.getValue();
            monitor.subTask(NLS.bind((String)Messages.ConnectorMigrator_Migrating_tasks_for_X, (Object)newRepository));
            AbstractRepositoryConnector newConnector = this.getRepositoryManager().getRepositoryConnector(newRepository.getConnectorKind());
            Set tasksToMigrate = Sets.filter((Set)this.getTaskList().getTasks(oldRepository.getRepositoryUrl()), TaskPredicates.isTaskForConnector(oldRepository.getConnectorKind()));
            this.migrateTasks(tasksToMigrate, oldRepository, newRepository, newConnector, monitor);
        }
        monitor.subTask(Messages.ConnectorMigrator_Waiting_for_tasks_to_synchronize);
        this.getSyncTaskJobListener().start();
        while (!this.getSyncTaskJobListener().isComplete()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", e.getMessage(), (Throwable)e));
            }
        }
    }

    protected void migrateTasks(Set<ITask> tasksToMigrate, TaskRepository oldRepository, final TaskRepository newRepository, final AbstractRepositoryConnector newConnector, IProgressMonitor monitor) {
        ImmutableMap tasksByKey = FluentIterable.from((Iterable)this.getTaskList().getTasks(newRepository.getRepositoryUrl())).filter(TaskPredicates.isTaskForConnector(newConnector.getConnectorKind())).uniqueIndex((Function)new Function<ITask, String>(){

            public String apply(ITask task) {
                return task.getTaskKey();
            }
        });
        final HashMap<AbstractTask, OldTaskState> migratedTasks = new HashMap<AbstractTask, OldTaskState>();
        HashSet<ITask> tasksToSynchronize = new HashSet<ITask>();
        for (ITask oldTask : tasksToMigrate) {
            TaskData taskData;
            String taskKey = oldTask.getTaskKey();
            ITask newTask = (ITask)tasksByKey.get((Object)taskKey);
            if (newTask == null && (taskData = this.getTaskData(taskKey, newConnector, newRepository, monitor)) != null) {
                newTask = this.createTask(taskData, newRepository);
                tasksToSynchronize.add(newTask);
            }
            if (newTask instanceof AbstractTask) {
                OldTaskState oldTaskState = (OldTaskState)this.oldTasksStates.get((Object)newRepository, (Object)oldTask.getTaskKey());
                if (oldTaskState == null) {
                    oldTaskState = new OldTaskState(oldTask);
                }
                migratedTasks.put((AbstractTask)newTask, oldTaskState);
            }
            if (!(newTask instanceof AbstractTask) || !(oldTask instanceof AbstractTask)) continue;
            this.migratePrivateData((AbstractTask)oldTask, (AbstractTask)newTask, monitor);
        }
        this.oldTasksStates.row((Object)newRepository).clear();
        this.migrateTaskContext(migratedTasks);
        this.getMigrationUi().delete(tasksToMigrate, oldRepository, newRepository, monitor);
        for (ITask task : tasksToSynchronize) {
            this.getTaskList().addTask(task);
        }
        SynchronizationJob job = this.tasksState.getTaskJobFactory().createSynchronizeTasksJob(newConnector, newRepository, tasksToSynchronize);
        this.getSyncTaskJobListener().add((Job)job, new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                while (Iterables.any(migratedTasks.keySet(), TaskPredicates.isTaskSynchronizing()) && System.currentTimeMillis() - start < TimeUnit.MILLISECONDS.convert(4L, TimeUnit.HOURS)) {
                    try {
                        Thread.sleep(TimeUnit.MILLISECONDS.convert(3L, TimeUnit.SECONDS));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                for (Map.Entry entry : migratedTasks.entrySet()) {
                    AbstractTask newTask = (AbstractTask)entry.getKey();
                    OldTaskState oldTask = (OldTaskState)entry.getValue();
                    newTask.setSynchronizationState(oldTask.getSyncState());
                }
                Set queries = ConnectorMigrator.this.getTaskList().getRepositoryQueries(newRepository.getRepositoryUrl());
                if (!queries.isEmpty()) {
                    SynchronizationJob synchronizeQueriesJob = ConnectorMigrator.this.tasksState.getTaskJobFactory().createSynchronizeQueriesJob(newConnector, newRepository, queries);
                    synchronizeQueriesJob.schedule();
                }
            }
        });
        job.schedule();
    }

    private void migrateTaskContext(Map<AbstractTask, OldTaskState> taskStates) {
        Map<ITask, ITask> tasks = taskStates.entrySet().stream().collect(Collectors.toMap(e -> ((OldTaskState)e.getValue()).getOldTask(), e -> (ITask)e.getKey()));
        TasksUiPlugin.getContextStore().moveContext(tasks);
    }

    protected void completeMigration() {
        this.categories = null;
        this.getMigrationUi().notifyMigrationComplete();
    }

    protected void migratePrivateData(AbstractTask oldTask, AbstractTask newTask, IProgressMonitor monitor) {
        AbstractTaskCategory category = this.getCategories().get(oldTask);
        if (category != null) {
            this.getTaskList().addTask((ITask)newTask, (AbstractTaskContainer)category);
        }
        newTask.setNotes(oldTask.getNotes());
        this.tasksState.getTaskActivityManager().setScheduledFor(newTask, oldTask.getScheduledForDate());
        this.tasksState.getTaskActivityManager().setDueDate((ITask)newTask, oldTask.getDueDate());
        newTask.setEstimatedTimeHours(oldTask.getEstimatedTimeHours());
    }

    protected ITask createTask(TaskData taskData, TaskRepository repository) {
        return new TaskTask(repository.getConnectorKind(), repository.getRepositoryUrl(), taskData.getTaskId());
    }

    protected TaskData getTaskData(String taskKey, AbstractRepositoryConnector newConnector, TaskRepository newRepository, IProgressMonitor monitor) {
        try {
            if (newConnector.supportsSearchByTaskKey(newRepository)) {
                return newConnector.searchByTaskKey(newRepository, taskKey, monitor);
            }
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to migrate task " + taskKey + " for repository " + newRepository.getRepositoryLabel(), (Throwable)e));
        }
        return null;
    }

    public Map<String, String> getSelectedConnectors() {
        return Maps.filterKeys(this.getConnectorKinds(), (Predicate)Predicates.in(this.connectorsToMigrate));
    }

    protected TaskList getTaskList() {
        return this.tasksState.getTaskList();
    }

    protected IRepositoryManager getRepositoryManager() {
        return this.tasksState.getRepositoryManager();
    }

    protected Map<ITask, AbstractTaskCategory> getCategories() {
        if (this.categories == null) {
            this.categories = new HashMap<ITask, AbstractTaskCategory>();
            for (AbstractTaskCategory category : this.getTaskList().getCategories()) {
                for (ITask task : category.getChildren()) {
                    this.categories.put(task, category);
                }
            }
        }
        return this.categories;
    }

    public ConnectorMigrationUi getMigrationUi() {
        return this.migrationUi;
    }

    protected JobListener getSyncTaskJobListener() {
        return this.syncTaskJobListener;
    }

    protected static class OldTaskState {
        private final ITask.SynchronizationState syncState;
        private final ITask oldTask;

        public OldTaskState(ITask oldTask) {
            this.oldTask = oldTask;
            this.syncState = oldTask.getSynchronizationState();
        }

        public ITask getOldTask() {
            return this.oldTask;
        }

        public ITask.SynchronizationState getSyncState() {
            return this.syncState;
        }
    }
}

