/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.efacet.ui.internal.widget;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.modisco.facet.efacet.core.internal.exported.IResolverManager;
import org.eclipse.modisco.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.modisco.facet.efacet.ui.internal.Messages;
import org.eclipse.modisco.facet.efacet.ui.internal.dialogs.FacetSetTreeContentProvider;
import org.eclipse.modisco.facet.efacet.ui.internal.exported.widget.IFacetSetSelectionWidget;
import org.eclipse.modisco.facet.util.emf.ui.internal.utils.ImageUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetSetSelectionControl
implements IFacetSetSelectionWidget {
    protected static final IStatus OK_STATUS = new Status(0, "org.eclipse.modisco.facet.efacet.ui", "");
    protected static final String INVALID_ELEMENTS = Messages.FacetSetSelectionControl_selectionContainsInvalidElements;
    protected static final String ONLY_FACET_SETS = Messages.FacetSetSelectionControl_onlyFacetSetsAllowedInSelection;
    private final Composite cParent;
    private CheckboxTreeViewer treeViewer;
    private Collection<? extends FacetSet> available;
    private final int selectionMaxSize;
    private final boolean allowEmpty;
    private IStatus validationStatus;
    private final Runnable onChange;
    private final Set<FacetSet> selected = new HashSet<FacetSet>();

    public FacetSetSelectionControl(Composite parentComposite, int selectionMaxSize, boolean allowEmpty, Runnable onChange) {
        this.cParent = parentComposite;
        this.selectionMaxSize = selectionMaxSize;
        this.allowEmpty = allowEmpty;
        this.onChange = onChange;
    }

    public void createContents() {
        Composite composite = new Composite(this.cParent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createCheckboxTreeViewer(composite);
        this.updateValidationStatus();
    }

    protected void notifyChanged() {
        if (this.onChange != null) {
            this.onChange.run();
        }
    }

    @Override
    public void setAvailableFacetSets(Collection<? extends FacetSet> newAvailable) {
        this.available = newAvailable;
        this.treeViewer.setInput((Object)newAvailable.toArray());
        this.updateValidationStatus();
        this.notifyChanged();
    }

    public Collection<? extends FacetSet> getAvailableFacetSets() {
        return Collections.unmodifiableCollection(this.available);
    }

    @Override
    public List<FacetSet> getSelectedFacetSets() {
        return Collections.unmodifiableList(new ArrayList<FacetSet>(this.selected));
    }

    @Override
    public void setSelectedFacetSets(Collection<? extends FacetSet> facetSetsToSelect) {
        if (facetSetsToSelect == null) {
            throw new IllegalArgumentException();
        }
        this.selected.clear();
        this.selected.addAll(facetSetsToSelect);
        this.updateValidationStatus();
        this.notifyChanged();
        this.treeViewer.refresh();
    }

    public final void addCheckStateListener(ICheckStateListener listener) {
        this.treeViewer.addCheckStateListener(listener);
    }

    protected void createCheckboxTreeViewer(Composite parentComposite) {
        this.treeViewer = new CheckboxTreeViewer(parentComposite, 2048);
        this.treeViewer.setContentProvider(this.createContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        this.treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.getTreeViewer().setCheckStateProvider(this.createCheckStateProvider());
        this.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                FacetSetSelectionControl.this.checkStateChanged(event);
            }
        });
        this.getTreeViewer().refresh();
    }

    protected void checkStateChanged(CheckStateChangedEvent event) {
        this.handleCheckStateChange(event);
        this.getTreeViewer().refresh();
        this.updateValidationStatus();
        this.notifyChanged();
    }

    protected void handleCheckStateChange(CheckStateChangedEvent event) {
        Object element = event.getElement();
        if (event.getElement() instanceof FacetSet) {
            FacetSet facetSet = (FacetSet)event.getElement();
            FacetSet propagation = (FacetSet)IResolverManager.DEFAULT.selectionRoot(element, FacetSet.class);
            if (propagation == null) {
                propagation = facetSet;
            }
            if (event.getChecked()) {
                this.selected.add(propagation);
            } else {
                this.selected.remove(propagation);
            }
        }
        this.treeViewer.refresh();
    }

    protected boolean isUnderCheckedSuperPackage(Object element) {
        boolean result = false;
        if (element instanceof FacetSet) {
            FacetSet facetSet = (FacetSet)element;
            EObject eSuperPackage = facetSet.eContainer();
            while (eSuperPackage != null) {
                if (this.selected.contains(eSuperPackage)) {
                    result = true;
                    break;
                }
                eSuperPackage = eSuperPackage.eContainer();
            }
        }
        return result;
    }

    protected ICheckStateProvider createCheckStateProvider() {
        return new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return FacetSetSelectionControl.this.isGrayed(element);
            }

            public boolean isChecked(Object element) {
                return FacetSetSelectionControl.this.isChecked(element);
            }
        };
    }

    protected boolean isGrayed(Object element) {
        List propagation = IResolverManager.DEFAULT.selectionPropagation(element, FacetSet.class);
        boolean contains = false;
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            contains = this.containsSelectedElement(eObject);
        }
        return (contains || this.isUnderCheckedSuperPackage(element) || propagation.contains(element)) && !this.selected.contains(element);
    }

    protected boolean containsSelectedElement(EObject eObject) {
        boolean contains = false;
        TreeIterator iterator = eObject.eAllContents();
        while (iterator.hasNext()) {
            EObject subObject = (EObject)iterator.next();
            contains = this.selected.contains(subObject);
            if (contains) break;
        }
        return contains;
    }

    protected boolean isChecked(Object element) {
        return this.selected.contains(element) || this.isGrayed(element);
    }

    protected void updateValidationStatus() {
        if (this.treeViewer == null) {
            return;
        }
        Object[] checkedElements = this.treeViewer.getCheckedElements();
        IStatus newStatus = OK_STATUS;
        if (!this.allowEmpty && checkedElements.length == 0) {
            newStatus = new Status(4, "org.eclipse.modisco.facet.efacet.ui", NLS.bind((String)Messages.FacetSetSelectionControl_mustSelectAtLeastOneElement, (Object)this.selectionMaxSize));
        } else if (checkedElements.length > this.selectionMaxSize) {
            newStatus = new Status(4, "org.eclipse.modisco.facet.efacet.ui", NLS.bind((String)Messages.FacetSetSelectionControl_mustSelectAtMostNElements, (Object)this.selectionMaxSize));
        } else {
            Object[] objectArray = checkedElements;
            int n = checkedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object checkedElement = objectArray[n2];
                IStatus elementStatus = FacetSetSelectionControl.validateElement(checkedElement);
                if (elementStatus.getSeverity() >= 4) {
                    newStatus = elementStatus;
                    break;
                }
                ++n2;
            }
        }
        this.setValidationStatus(newStatus);
    }

    protected static IStatus validateElement(Object checkedElement) {
        IStatus status = OK_STATUS;
        if (!(checkedElement instanceof FacetSet)) {
            status = new Status(4, "org.eclipse.modisco.facet.efacet.ui", ONLY_FACET_SETS);
        }
        return status;
    }

    protected boolean isAvailable(FacetSet facetSet) {
        boolean bAvailable = false;
        if (this.available.contains(facetSet)) {
            bAvailable = true;
        } else {
            EPackage parent = facetSet.getESuperPackage();
            while (parent != null) {
                if (this.available.contains(parent)) {
                    bAvailable = true;
                    break;
                }
                parent = parent.getESuperPackage();
            }
        }
        return bAvailable;
    }

    protected void setValidationStatus(IStatus status) {
        this.validationStatus = status;
    }

    @Override
    public IStatus getValidationStatus() {
        return this.validationStatus;
    }

    public boolean isErrorStatus() {
        return this.validationStatus == null || this.validationStatus.getSeverity() >= 4;
    }

    protected ILabelProvider createLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                String text;
                if (element instanceof ENamedElement) {
                    ENamedElement namedElement = (ENamedElement)element;
                    text = namedElement.getName();
                } else {
                    text = super.getText(element);
                }
                return text;
            }

            public Image getImage(Object element) {
                return ImageUtils.getImage((Object)element);
            }
        };
    }

    protected IContentProvider createContentProvider() {
        return new FacetSetTreeContentProvider(false, true, true);
    }

    public CheckboxTreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public boolean isDisposed() {
        return this.treeViewer.getTree().isDisposed();
    }

    public void selectAll() {
        this.selected.clear();
        this.selected.addAll(this.available);
        this.treeViewer.refresh();
    }

    public void deselectAll() {
        this.selected.clear();
        this.treeViewer.refresh();
    }

    @Override
    public Control getControl() {
        Tree control = null;
        if (this.treeViewer != null) {
            control = this.treeViewer.getTree();
        }
        return control;
    }
}

