/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof.acquire;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.hprof.acquire.JmapVmInfo;
import org.eclipse.mat.hprof.acquire.LocalJavaProcessesUtils;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.snapshot.acquire.IHeapDumpProvider;
import org.eclipse.mat.snapshot.acquire.VmInfo;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.osgi.service.prefs.BackingStoreException;

@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/acquiringheapdump.html#task_acquiringheapdump__1")
public class JMapHeapDumpProvider
implements IHeapDumpProvider {
    private static final String PLUGIN_ID = "org.eclipse.mat.hprof";
    private static final String LAST_JDK_DIRECTORY_KEY = String.valueOf(JMapHeapDumpProvider.class.getName()) + ".lastJDKDir";
    private static final String LAST_JMAP_JDK_DIRECTORY_KEY = String.valueOf(JMapHeapDumpProvider.class.getName()) + ".lastJmapJDKDir";
    static final String FILE_PATTERN = "java_pid{1,number,0}.{2,number,0000}.hprof";
    static final String FILE_GZ_PATTERN = "java_pid{1,number,0}.{2,number,0000}.hprof.gz";
    @Argument(isMandatory=false, advice=Argument.Advice.DIRECTORY)
    public File jdkHome = this.readSavedLocation(LAST_JDK_DIRECTORY_KEY);
    @Argument(isMandatory=false)
    public boolean defaultCompress;

    public JMapHeapDumpProvider() {
        if (this.jdkHome == null) {
            this.jdkHome = this.guessJDK();
        }
    }

    public File acquireDump(VmInfo info, File preferredLocation, IProgressListener listener) throws SnapshotException {
        JmapVmInfo jmapProcessInfo = (JmapVmInfo)info;
        listener.beginTask(Messages.JMapHeapDumpProvider_WaitForHeapDump, -1);
        String jmap = "jmap";
        if (jmapProcessInfo.jdkHome != null && jmapProcessInfo.jdkHome.exists()) {
            jmap = String.valueOf(jmapProcessInfo.jdkHome.getAbsolutePath()) + File.separator + "bin" + File.separator + "jmap";
            this.persistJDKLocation(LAST_JMAP_JDK_DIRECTORY_KEY, jmapProcessInfo.jdkHome.getAbsolutePath());
        }
        String[] execLine = new String[]{jmap, "-dump:format=b,file=" + preferredLocation.getAbsolutePath(), String.valueOf(info.getPid())};
        StringBuilder logMessage = new StringBuilder();
        logMessage.append("Executing { ");
        int i = 0;
        while (i < execLine.length) {
            logMessage.append("\"").append(execLine[i]).append("\"");
            if (i < execLine.length - 1) {
                logMessage.append(", ");
            }
            ++i;
        }
        logMessage.append(" }");
        Logger.getLogger(this.getClass().getName()).info(logMessage.toString());
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(execLine);
            LocalJavaProcessesUtils.StreamCollector error = new LocalJavaProcessesUtils.StreamCollector(p.getErrorStream());
            error.start();
            LocalJavaProcessesUtils.StreamCollector output = new LocalJavaProcessesUtils.StreamCollector(p.getInputStream());
            output.start();
            if (listener.isCanceled()) {
                return null;
            }
            try {
                int exitCode = p.waitFor();
                if (exitCode != 0) {
                    throw new SnapshotException(MessageUtil.format((String)Messages.JMapHeapDumpProvider_ErrorCreatingDump, (Object[])new Object[]{exitCode, error.buf.toString()}));
                }
                if (!preferredLocation.exists()) {
                    throw new SnapshotException(MessageUtil.format((String)Messages.JMapHeapDumpProvider_HeapDumpNotCreated, (Object[])new Object[]{exitCode, output.buf.toString(), error.buf.toString()}));
                }
            }
            catch (IOException ioe) {
                throw new SnapshotException(Messages.JMapHeapDumpProvider_ErrorCreatingDump, (Throwable)ioe);
            }
            catch (InterruptedException ie) {
                throw new SnapshotException(Messages.JMapHeapDumpProvider_ErrorCreatingDump, (Throwable)ie);
            }
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
        if (jmapProcessInfo.compress) {
            try {
                preferredLocation = this.compressFile(preferredLocation, listener);
            }
            catch (IOException e) {
                throw new SnapshotException(Messages.JMapHeapDumpProvider_ErrorCreatingDump, (Throwable)e);
            }
        }
        listener.done();
        return preferredLocation;
    }

    /*
     * Exception decompiling
     */
    File compressFile(File dump, IProgressListener listener) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<JmapVmInfo> getAvailableVMs(IProgressListener listener) throws SnapshotException {
        listener.beginTask(Messages.JMapHeapDumpProvider_ListProcesses, -1);
        if (this.jdkHome != null && this.jdkHome.exists()) {
            this.persistJDKLocation(LAST_JDK_DIRECTORY_KEY, this.jdkHome.getAbsolutePath());
        }
        ArrayList<JmapVmInfo> result = new ArrayList<JmapVmInfo>();
        List<JmapVmInfo> jvms = LocalJavaProcessesUtils.getLocalVMsUsingJPS(this.jdkHome);
        if (jvms != null) {
            File jmapJdkHome = this.readSavedLocation(LAST_JMAP_JDK_DIRECTORY_KEY);
            if (jmapJdkHome == null) {
                jmapJdkHome = this.jdkHome;
            }
            for (JmapVmInfo vmInfo : jvms) {
                vmInfo.setHeapDumpProvider(this);
                vmInfo.jdkHome = jmapJdkHome;
                vmInfo.compress = this.defaultCompress;
                result.add(vmInfo);
            }
        }
        listener.done();
        return result;
    }

    private void persistJDKLocation(String key, String value) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        prefs.put(key, value);
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    private File readSavedLocation(String key) {
        String lastDir = Platform.getPreferencesService().getString(PLUGIN_ID, key, "", null);
        if (lastDir != null && !lastDir.trim().equals("")) {
            return new File(lastDir);
        }
        return null;
    }

    private File guessJDK() {
        String javaHomeProperty = System.getProperty("java.home");
        File parentFolder = new File(javaHomeProperty).getParentFile();
        File binDir = new File(parentFolder + File.separator + "bin");
        if (binDir.exists()) {
            return parentFolder;
        }
        return null;
    }
}

