/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.vagrant.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.Platform;
import org.eclipse.linuxtools.internal.vagrant.core.VagrantConnection;
import org.eclipse.linuxtools.vagrant.core.IVagrantBox;
import org.eclipse.linuxtools.vagrant.core.IVagrantBoxListener;
import org.eclipse.linuxtools.vagrant.core.IVagrantConnection;

public class VagrantBoxRefreshManager
implements IVagrantBoxListener {
    private static VagrantBoxRefreshManager instance;
    private final long DEFAULT_REFRESH_TIME = 15L;
    private Map<IVagrantConnection, ContainerRefreshThread> refreshThreadMap = new HashMap<IVagrantConnection, ContainerRefreshThread>();

    private VagrantBoxRefreshManager() {
    }

    public static VagrantBoxRefreshManager getInstance() {
        if (instance == null) {
            instance = new VagrantBoxRefreshManager();
        }
        return instance;
    }

    @Override
    public synchronized void listChanged(IVagrantConnection connection, List<IVagrantBox> dclist) {
        ContainerRefreshThread rt = this.refreshThreadMap.get(connection);
        if (rt == null) {
            long refreshRateInSeconds = Platform.getPreferencesService().getLong("org.eclipse.linuxtools.vagrant.ui", "containerRefreshTime", 15L, null);
            rt = new ContainerRefreshThread(connection, TimeUnit.SECONDS.toMillis(refreshRateInSeconds));
            rt.start();
            this.refreshThreadMap.put(connection, rt);
        }
    }

    public void setRefreshTime(long seconds) {
        if (seconds >= 5L) {
            long refreshRate = TimeUnit.SECONDS.toMillis(seconds);
            for (ContainerRefreshThread t : this.refreshThreadMap.values()) {
                t.setSleepTime(refreshRate);
            }
        }
    }

    public void killAllThreads() {
        for (ContainerRefreshThread rt : this.refreshThreadMap.values()) {
            rt.kill();
            this.refreshThreadMap.remove(rt.getConnection());
        }
    }

    static /* synthetic */ VagrantBoxRefreshManager access$0() {
        return instance;
    }

    private class ContainerRefreshThread
    extends Thread {
        private IVagrantConnection connection;
        private long sleepTime;
        private boolean kill;

        public ContainerRefreshThread(IVagrantConnection connection, long sleepTime) {
            this.connection = connection;
            this.sleepTime = sleepTime;
        }

        public IVagrantConnection getConnection() {
            return this.connection;
        }

        public synchronized long getSleepTime() {
            return this.sleepTime;
        }

        public synchronized void setSleepTime(long newTime) {
            this.sleepTime = newTime;
            this.interrupt();
        }

        public void kill() {
            this.kill = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) lbl-1000:
                    // 2 sources

                    {
                        Thread.sleep(this.getSleepTime());
                        var1_1 = VagrantBoxRefreshManager.access$0();
                        synchronized (var1_1) {
                            this.connection.removeBoxListener(VagrantBoxRefreshManager.access$0());
                            ((VagrantConnection)this.connection).getBoxes(true);
                            this.connection.addBoxListener(VagrantBoxRefreshManager.access$0());
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    if (!this.kill) continue;
                    return;
                }
                {
                    ** while (true)
                }
                break;
            }
        }
    }
}

