/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.graphing.ui.wizards.filter;

import org.eclipse.linuxtools.internal.systemtap.graphing.ui.Localization;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.wizards.filter.FilterWizardPage;
import org.eclipse.linuxtools.systemtap.graphing.core.filters.SortFilter;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.ColumnLayout;

public class SortFilterWizardPage
extends FilterWizardPage {
    private Combo cboColumn;
    private Button radAscending;
    private Button radDescending;

    public SortFilterWizardPage() {
        super("selectFilterOptions");
        this.setTitle(Localization.getString("SortFilterWizardPage.CreateSortFilter"));
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new FormLayout());
        FormData data1 = new FormData();
        data1.left = new FormAttachment(0, 0);
        data1.top = new FormAttachment(0, 0);
        data1.right = new FormAttachment(40, 0);
        data1.bottom = new FormAttachment(100, 0);
        Composite cmpFilterOpts = new Composite(comp, 0);
        cmpFilterOpts.setLayoutData((Object)data1);
        ColumnLayout colLayout = new ColumnLayout();
        colLayout.maxNumColumns = 1;
        cmpFilterOpts.setLayout((Layout)colLayout);
        Label lblColumn = new Label(cmpFilterOpts, 0);
        lblColumn.setText(Localization.getString("SortFilterWizardPage.Column"));
        this.cboColumn = new Combo(cmpFilterOpts, 12);
        this.cboColumn.addSelectionListener(this.selectionListener);
        int i = 0;
        while (i < this.wizard.series.length) {
            this.cboColumn.add(this.wizard.series[i]);
            ++i;
        }
        new Label(cmpFilterOpts, 0);
        this.radAscending = new Button(cmpFilterOpts, 16);
        this.radAscending.setText(Localization.getString("SortFilterWizardPage.Ascending"));
        this.radAscending.addSelectionListener(this.selectionListener);
        this.radAscending.setSelection(true);
        this.radDescending = new Button(cmpFilterOpts, 16);
        this.radDescending.setText(Localization.getString("SortFilterWizardPage.Descending"));
        this.radDescending.addSelectionListener(this.selectionListener);
        this.cboColumn.select(0);
        this.createFilter();
        this.setControl((Control)comp);
    }

    @Override
    public boolean canFlipToNextPage() {
        return false;
    }

    @Override
    protected void createFilter() {
        int selected = this.cboColumn.getSelectionIndex();
        int style = this.radAscending.getSelection() ? 0 : 1;
        this.filter = new SortFilter(selected, style);
    }

    @Override
    public void dispose() {
        if (this.cboColumn != null) {
            this.cboColumn.removeSelectionListener(this.selectionListener);
            this.cboColumn.dispose();
            this.cboColumn = null;
        }
        if (this.radAscending != null) {
            this.radAscending.removeSelectionListener(this.selectionListener);
            this.radAscending.dispose();
            this.radAscending = null;
        }
        if (this.radDescending != null) {
            this.radDescending.removeSelectionListener(this.selectionListener);
            this.radDescending.dispose();
            this.radDescending = null;
        }
        super.dispose();
    }
}

