/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.editor.ui.internal.dependencies;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.libra.framework.editor.core.model.IBundle;
import org.eclipse.libra.framework.editor.ui.internal.dependencies.BundleDependencyContentProvider;
import org.eclipse.libra.framework.editor.ui.internal.dependencies.BundleDependencyContentResult;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.layouts.LayoutEntity;
import org.eclipse.zest.layouts.algorithms.AbstractLayoutAlgorithm;
import org.eclipse.zest.layouts.dataStructures.InternalNode;
import org.eclipse.zest.layouts.dataStructures.InternalRelationship;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleDependencyLayoutAlgorithm
extends AbstractLayoutAlgorithm {
    private final BundleDependencyContentProvider contentProvider;

    public BundleDependencyLayoutAlgorithm(BundleDependencyContentProvider contentProvider) {
        super(16);
        this.contentProvider = contentProvider;
    }

    protected void applyLayoutInternal(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider, double boundsX, double boundsY, double boundsWidth, double boundsHeight) {
        BundleDependencyContentResult contentResult = this.contentProvider.getContentResult();
        Set<IBundle> rootBundles = contentResult.getBundles();
        HashSet<IBundle> bundlesProcessed = new HashSet<IBundle>();
        if (contentResult != null) {
            int n;
            HashSet<Object> columnNodes = new HashSet<Object>();
            double columnWith = 0.0;
            double currentX = boundsX + 0.0;
            double currentY = boundsY + 10.0;
            double maxY = boundsHeight;
            int columns = 0;
            int degree = contentResult.getIncomingDegree();
            while (degree > 0) {
                HashSet<InternalNode> degreeNodes = new HashSet<InternalNode>();
                Set<IBundle> deps = contentResult.getIncomingDependencies().get(degree);
                block1: for (IBundle bundle : deps) {
                    if (bundlesProcessed.contains(bundle) || rootBundles.contains(bundle) || this.lowestRanking(bundle, contentResult.getIncomingDegree(), contentResult.getIncomingDependencies()) != degree) continue;
                    InternalNode[] internalNodeArray = entitiesToLayout;
                    int n2 = entitiesToLayout.length;
                    n = 0;
                    while (n < n2) {
                        InternalNode node = internalNodeArray[n];
                        LayoutEntity obj = node.getLayoutEntity();
                        IBundle graphBundle = (IBundle)((GraphNode)obj.getGraphData()).getData();
                        if (graphBundle.equals(bundle)) {
                            columnWith = Math.max(columnWith, node.getWidthInLayout());
                            node.setLocation(currentX, currentY);
                            bundlesProcessed.add(bundle);
                            currentY = currentY + node.getHeightInLayout() + 15.0;
                            degreeNodes.add(node);
                            maxY = Math.max(currentY, maxY);
                            continue block1;
                        }
                        ++n;
                    }
                }
                for (InternalNode node : degreeNodes) {
                    if (!(node.getWidthInLayout() < columnWith)) continue;
                    double x = (columnWith - node.getWidthInLayout()) / 2.0;
                    node.setLocation(node.getLayoutEntity().getXInLayout() + x, node.getLayoutEntity().getYInLayout());
                }
                ColumnHolder holder = new ColumnHolder();
                holder.index = columns++;
                holder.y = currentY;
                holder.nodes = degreeNodes;
                columnNodes.add(holder);
                currentY = boundsY + 10.0;
                if (degreeNodes.size() > 0) {
                    currentX = currentX + columnWith + 30.0;
                }
                --degree;
                columnWith = 0.0;
            }
            HashSet<InternalNode> rootNodes = new HashSet<InternalNode>();
            block4: for (IBundle bundle : rootBundles) {
                InternalNode[] internalNodeArray = entitiesToLayout;
                n = entitiesToLayout.length;
                int x = 0;
                while (x < n) {
                    InternalNode internalNode = internalNodeArray[x];
                    LayoutEntity obj = internalNode.getLayoutEntity();
                    IBundle graphBundle = (IBundle)((GraphNode)obj.getGraphData()).getData();
                    if (graphBundle.equals(bundle)) {
                        columnWith = Math.max(columnWith, internalNode.getWidthInLayout());
                        internalNode.setLocation(currentX, currentY);
                        bundlesProcessed.add(bundle);
                        currentY = currentY + internalNode.getHeightInLayout() + 15.0;
                        maxY = Math.max(currentY, maxY);
                        rootNodes.add(internalNode);
                        continue block4;
                    }
                    ++x;
                }
            }
            for (InternalNode node : rootNodes) {
                if (!(node.getWidthInLayout() < columnWith)) continue;
                double d = (columnWith - node.getWidthInLayout()) / 2.0;
                node.setLocation(node.getLayoutEntity().getXInLayout() + d, node.getLayoutEntity().getYInLayout());
            }
            ColumnHolder holder = new ColumnHolder();
            holder.index = columns;
            holder.y = currentY;
            holder.nodes = rootNodes;
            columnNodes.add(holder);
            currentY = boundsY + 10.0;
            currentX = currentX + columnWith + 30.0;
            int maxDegree = contentResult.getOutgoingDegree();
            degree = 1;
            while (degree <= maxDegree) {
                HashSet<InternalNode> hashSet = new HashSet<InternalNode>();
                Set<IBundle> deps = contentResult.getOutgoingDependencies().get(degree);
                block8: for (IBundle bundle : deps) {
                    if (bundlesProcessed.contains(bundle) || rootBundles.contains(bundle) || this.lowestRanking(bundle, contentResult.getOutgoingDegree(), contentResult.getOutgoingDependencies()) != degree) continue;
                    InternalNode[] internalNodeArray = entitiesToLayout;
                    int n3 = entitiesToLayout.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        InternalNode node = internalNodeArray[n4];
                        LayoutEntity obj = node.getLayoutEntity();
                        IBundle graphBundle = (IBundle)((GraphNode)obj.getGraphData()).getData();
                        if (graphBundle.equals(bundle)) {
                            columnWith = Math.max(columnWith, node.getWidthInLayout());
                            node.setLocation(currentX, currentY);
                            bundlesProcessed.add(bundle);
                            currentY = currentY + node.getHeightInLayout() + 15.0;
                            maxY = Math.max(currentY, maxY);
                            hashSet.add(node);
                            continue block8;
                        }
                        ++n4;
                    }
                }
                for (InternalNode node : hashSet) {
                    if (!(node.getWidthInLayout() < columnWith)) continue;
                    double x = (columnWith - node.getWidthInLayout()) / 2.0;
                    node.setLocation(node.getLayoutEntity().getXInLayout() + x, node.getLayoutEntity().getYInLayout());
                }
                holder = new ColumnHolder();
                holder.index = columns;
                holder.y = currentY;
                holder.nodes = hashSet;
                columnNodes.add(holder);
                currentY = boundsY + 10.0;
                currentX = currentX + columnWith + 30.0;
                ++degree;
                columnWith = 0.0;
            }
            for (ColumnHolder columnHolder : columnNodes) {
                if (!(columnHolder.y <= maxY)) continue;
                double y = (maxY - columnHolder.y) / 2.0;
                for (InternalNode node : columnHolder.nodes) {
                    node.setLocation(node.getLayoutEntity().getXInLayout(), node.getLayoutEntity().getYInLayout() + y);
                }
            }
        }
    }

    private int lowestRanking(IBundle bundle, int maxDegree, Map<Integer, Set<IBundle>> bundles) {
        int ranking = 1;
        while (ranking <= maxDegree) {
            for (IBundle b : bundles.get(ranking)) {
                if (!b.equals(bundle)) continue;
                return ranking;
            }
            ++ranking;
        }
        return ranking;
    }

    protected int getCurrentLayoutStep() {
        return 1;
    }

    protected int getTotalNumberOfLayoutSteps() {
        return 1;
    }

    protected boolean isValidConfiguration(boolean asynchronous, boolean continuous) {
        return true;
    }

    protected void postLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider) {
    }

    protected void preLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider, double x, double y, double width, double height) {
    }

    public void setLayoutArea(double x, double y, double width, double height) {
    }

    class ColumnHolder {
        protected double y;
        protected int index;
        protected Set<InternalNode> nodes;

        ColumnHolder() {
        }
    }
}

