/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.tester.adapter;

import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ITabbedComponent;
import org.eclipse.jubula.rc.swt.tester.adapter.ControlAdapter;
import org.eclipse.jubula.rc.swt.tester.util.CAPUtil;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;

public class TabFolderAdapter
extends ControlAdapter
implements ITabbedComponent {
    private TabFolder m_tabFolder;

    public TabFolderAdapter(Object objectToAdapt) {
        super(objectToAdapt);
        this.m_tabFolder = (TabFolder)objectToAdapt;
    }

    public int getTabCount() {
        return (Integer)this.getEventThreadQueuer().invokeAndWait("getTabCount", (IRunnable)new IRunnable<Integer>(){

            public Integer run() throws StepExecutionException {
                return TabFolderAdapter.this.m_tabFolder.getItemCount();
            }
        });
    }

    public String getTitleofTab(final int index) {
        return (String)this.getEventThreadQueuer().invokeAndWait("getTitleofTab", (IRunnable)new IRunnable<String>(){

            public String run() throws StepExecutionException {
                TabItem item = TabFolderAdapter.this.m_tabFolder.getItem(index);
                return CAPUtil.getWidgetText((Widget)item, SwtUtils.removeMnemonics(item.getText()));
            }
        });
    }

    public Object getBoundsAt(final int index) {
        return this.getEventThreadQueuer().invokeAndWait("getBoundsAt", (IRunnable)new IRunnable<Rectangle>(){

            public Rectangle run() throws StepExecutionException {
                return SwtUtils.getRelativeWidgetBounds((Widget)TabFolderAdapter.this.m_tabFolder.getItem(index), (Control)TabFolderAdapter.this.m_tabFolder);
            }
        });
    }

    public boolean isEnabledAt(final int index) {
        return (Boolean)this.getEventThreadQueuer().invokeAndWait("isEnabledAt", (IRunnable)new IRunnable<Boolean>(){

            public Boolean run() throws StepExecutionException {
                return TabFolderAdapter.this.m_tabFolder.getItem(index).getControl().isEnabled();
            }
        });
    }

    public int getSelectedIndex() {
        return (Integer)this.getEventThreadQueuer().invokeAndWait("getSelectedIndex", (IRunnable)new IRunnable<Integer>(){

            public Integer run() throws StepExecutionException {
                return TabFolderAdapter.this.m_tabFolder.getSelectionIndex();
            }
        });
    }
}

