/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.driver;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.List;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.swing.driver.DefaultAwtEventMatcher;
import org.eclipse.jubula.rc.swing.listener.ComponentHandler;

public class ClickAwtEventMatcher
extends DefaultAwtEventMatcher {
    private ClickOptions m_clickOptions;

    public ClickAwtEventMatcher(ClickOptions clickOptions) {
        super(ClickAwtEventMatcher.getMouseEventId(clickOptions));
        this.m_clickOptions = clickOptions;
    }

    private static int getMouseEventId(ClickOptions clickOptions) {
        return clickOptions.getClickType() == ClickOptions.ClickType.CLICKED ? 500 : 502;
    }

    private int getClickCount(Object eventObject) {
        int count = -1;
        if (eventObject instanceof MouseEvent) {
            MouseEvent e = (MouseEvent)eventObject;
            count = e.getClickCount();
        }
        return count;
    }

    private boolean isClickCountMatching(Object eventObject) {
        return this.getClickCount(eventObject) == this.m_clickOptions.getClickCount();
    }

    public boolean isMatching(Object eventObject) {
        return super.isMatching(eventObject) ? this.isClickCountMatching(eventObject) : false;
    }

    public boolean isFallBackEventMatching(List eventObjects, Object graphicsComponent) {
        block4: {
            try {
                if (ComponentHandler.getAutHierarchy().getHierarchyContainer((Component)graphicsComponent) == null && (this.m_clickOptions.getClickType() == ClickOptions.ClickType.RELEASED || this.m_clickOptions.getClickCount() == 0)) {
                    return true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (this.m_clickOptions.getClickType() != ClickOptions.ClickType.RELEASED && this.m_clickOptions.getClickCount() != 0) break block4;
                return true;
            }
        }
        for (AWTEvent event : eventObjects) {
            if (!this.isClickCountMatching(event)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        String str = String.valueOf(this.getClass().getName()) + " ClickOptions: " + this.m_clickOptions.toString();
        return str;
    }
}

