/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.AUTServerConfiguration;
import org.eclipse.jubula.rc.common.components.AUTHierarchy;
import org.eclipse.jubula.rc.common.components.HierarchyContainer;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FindComponentBP {
    private static final AutServerLogger LOG = new AutServerLogger(FindComponentBP.class);
    private double m_pathFactor = 0.3;
    private double m_contextFactor = 0.1;
    private double m_thresholdValue = 0.85;
    private double m_nameFactor = 0.6;
    private AUTHierarchy m_hierarchy;

    public Object findComponent(IComponentIdentifier componentIdentifier, AUTHierarchy hierarchy) throws IllegalArgumentException {
        this.m_hierarchy = hierarchy;
        AUTServerConfiguration serverConfig = AUTServerConfiguration.getInstance();
        org.eclipse.jubula.tools.Profile p = componentIdentifier.getProfile();
        if (p != null && p instanceof Profile) {
            this.setProfile((Profile)p);
        } else {
            this.setProfile(serverConfig.getProfile());
        }
        List hierarchyNames = null;
        Validate.notNull((Object)componentIdentifier, (String)"The component identifier must not be null.");
        hierarchyNames = componentIdentifier.getHierarchyNames();
        Validate.noNullElements((Collection)hierarchyNames, (String)"The component identifier contains  no hierarchy information.");
        Iterator allComponents = new ArrayList(this.m_hierarchy.getHierarchyMap().values()).iterator();
        HierarchyContainer bestMatch = null;
        double bestMatchPercentage = 0.0;
        double equivalence = 0.0;
        String suppClassName = componentIdentifier.getSupportedClassName();
        AUTServerConfiguration autServerConf = AUTServerConfiguration.getInstance();
        int numberOfOtherMatchingComponents = 0;
        while (allComponents.hasNext()) {
            HierarchyContainer current = allComponents.next();
            Object currComp = current.getCompID().getComponent();
            if (!this.isAvailable(currComp) || !this.isSupportedComponent(currComp) || (suppClassName == null || !this.checkTestableClass(autServerConf, suppClassName, currComp)) && !componentIdentifier.getComponentName().equals(this.getCompName(currComp))) continue;
            equivalence = this.computeEquivalence(componentIdentifier, current);
            if (this.meetsThreshold(equivalence)) {
                ++numberOfOtherMatchingComponents;
            }
            if (equivalence > bestMatchPercentage) {
                bestMatch = current;
                bestMatchPercentage = equivalence;
                continue;
            }
            if (equivalence != bestMatchPercentage || !hierarchy.isInActiveWindow(currComp)) continue;
            bestMatch = current;
        }
        Object technicalComponent = null;
        if (bestMatch != null && this.meetsThreshold(bestMatchPercentage)) {
            technicalComponent = bestMatch.getCompID().getComponent();
        }
        componentIdentifier.setMatchPercentage(bestMatchPercentage);
        componentIdentifier.setNumberOfOtherMatchingComponents(numberOfOtherMatchingComponents);
        return technicalComponent;
    }

    protected abstract boolean isAvailable(Object var1);

    protected boolean checkTestableClass(AUTServerConfiguration autServerConf, String suppClassName, Object currComp) {
        boolean isTestable = false;
        try {
            isTestable = suppClassName.equals(autServerConf.getTestableClass(currComp.getClass()).getName());
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Class<?> superClass = currComp.getClass();
        while (!isTestable && superClass != null) {
            superClass = superClass.getSuperclass();
            try {
                isTestable = suppClassName.equals(autServerConf.getTestableClass(superClass).getName());
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return isTestable;
    }

    protected boolean isSupportedComponent(Object component) {
        try {
            AUTServerConfiguration.getInstance().getTestableClass(component.getClass());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    private void setProfile(Profile profile) {
        if (profile != null) {
            this.m_nameFactor = profile.getNameFactor();
            this.m_pathFactor = profile.getPathFactor();
            this.m_contextFactor = profile.getContextFactor();
            this.m_thresholdValue = profile.getThreshold();
        }
    }

    private double computeEquivalence(IComponentIdentifier compIdent, HierarchyContainer current) {
        double equivalence = 0.0;
        String name1 = compIdent.getComponentName();
        String name2 = current.getName();
        double nameEquivalence = 0.0;
        nameEquivalence = this.isGeneratedName(compIdent.getComponentClassName(), compIdent.getComponentName()) ? this.getNameEquivalence(name1, name2) : (double)(name1.equals(name2) ? 1 : 0);
        equivalence = this.equivalence(nameEquivalence, 1.0, 1.0);
        if (!this.meetsThreshold(equivalence)) {
            return equivalence;
        }
        double pathEquivalence = this.getPathEquivalence(compIdent, current);
        equivalence = this.equivalence(nameEquivalence, pathEquivalence, 1.0);
        if (!this.meetsThreshold(equivalence)) {
            return equivalence;
        }
        double contextEquivalence = this.getContextEquivalence(compIdent, current);
        equivalence = this.equivalence(nameEquivalence, pathEquivalence, contextEquivalence);
        this.logEquivalence(compIdent, current, equivalence, nameEquivalence, pathEquivalence, contextEquivalence);
        return equivalence;
    }

    private boolean meetsThreshold(double equivalence) {
        return equivalence - this.m_thresholdValue + 0.01 > 0.0;
    }

    private double equivalence(double nameE, double pathE, double contE) {
        return this.m_nameFactor * nameE + this.m_pathFactor * pathE + this.m_contextFactor * contE;
    }

    private void logEquivalence(IComponentIdentifier componentIdentifier, HierarchyContainer current, double equivalence, double nameEquivalence, double pathEquivalence, double contextEquivalence) {
        if (LOG.isInfoEnabled()) {
            StringBuffer txt = new StringBuffer(500);
            txt.append("Equivalence values for Identifier ");
            txt.append(componentIdentifier.getComponentNameToDisplay());
            txt.append(" , matched against ");
            txt.append(current.getName());
            txt.append(" , threshold value: ");
            txt.append(this.m_thresholdValue);
            txt.append("\n");
            txt.append("Equivalence total: ");
            txt.append(equivalence);
            txt.append(" name: ");
            txt.append(nameEquivalence * this.m_nameFactor);
            txt.append(" path: ");
            txt.append(pathEquivalence * this.m_pathFactor);
            txt.append(" context: ");
            txt.append(contextEquivalence * this.m_contextFactor);
            String txtString = txt.toString();
            LOG.info(txtString);
        }
    }

    private double getNameEquivalence(String name1, String name2) {
        int diff = StringUtils.getLevenshteinDistance((String)name1, (String)name2);
        double nameEquivalence = 1.0 / (double)Math.max(name1.length(), name2.length()) * (double)(Math.max(name1.length(), name2.length()) - diff);
        return nameEquivalence;
    }

    private double getPathEquivalence(IComponentIdentifier comp, HierarchyContainer hierarchyContainer) {
        if (comp.getHierarchyNames() == null || comp.getHierarchyNames().size() == 0) {
            return 0.0;
        }
        List<String> l1 = comp.getHierarchyNames().subList(0, comp.getHierarchyNames().size() - 1);
        ArrayList<String> l2 = new ArrayList<String>();
        HierarchyContainer iter = hierarchyContainer.getPrnt();
        while (iter != null) {
            l2.add(0, iter.getName());
            iter = iter.getPrnt();
        }
        double pathEquivalence = 0.0;
        if (l1.size() == 0 && l2.size() == 0) {
            pathEquivalence = 1.0;
        } else {
            int diff = this.getLevenshteinListDistanceImp(l1, l2);
            pathEquivalence = 1.0 / (double)Math.max(l1.size(), l2.size()) * (double)(Math.max(l1.size(), l2.size()) - diff);
        }
        return pathEquivalence;
    }

    private double getContextEquivalence(IComponentIdentifier comp, HierarchyContainer hierarchyContainer) {
        List compNeighbours = comp.getNeighbours();
        List<String> compContext = this.m_hierarchy.getComponentContext(hierarchyContainer.getCompID().getComponent());
        Collections.sort(compNeighbours);
        Collections.sort(compContext);
        double contextEquivalence = 0.0;
        int compNeighboursSize = compNeighbours.size();
        int compContextSize = compContext.size();
        if (compNeighboursSize == 0 && compContextSize == 0) {
            contextEquivalence = 1.0;
        } else {
            int diff = this.getLevenshteinListDistanceImp(compNeighbours, compContext);
            contextEquivalence = 1.0 / (double)Math.max(compNeighboursSize, compContextSize) * (double)(Math.max(compNeighboursSize, compContextSize) - diff);
        }
        return contextEquivalence;
    }

    private int getLevenshteinListDistanceImp(List<String> s, List<String> t) {
        if (s == null || t == null) {
            throw new IllegalArgumentException("Lists must not be null");
        }
        int sSize = s.size();
        int tSize = t.size();
        if (sSize == 0) {
            return tSize;
        }
        if (tSize == 0) {
            return sSize;
        }
        int[] p = new int[sSize + 1];
        int[] d = new int[sSize + 1];
        int sIdx = 0;
        while (sIdx <= sSize) {
            p[sIdx] = sIdx;
            ++sIdx;
        }
        int tIdx = 1;
        while (tIdx <= tSize) {
            String currCharOfT = t.get(tIdx - 1);
            d[0] = tIdx;
            sIdx = 1;
            while (sIdx <= sSize) {
                int cost = s.get(sIdx - 1).equals(currCharOfT) ? 0 : 1;
                d[sIdx] = Math.min(Math.min(d[sIdx - 1] + 1, p[sIdx] + 1), p[sIdx - 1] + cost);
                ++sIdx;
            }
            int[] swapPAndD = p;
            p = d;
            d = swapPAndD;
            ++tIdx;
        }
        return p[sSize];
    }

    private boolean isGeneratedName(String className, String name) {
        return name.indexOf(className) != -1;
    }

    protected abstract String getCompName(Object var1);
}

