/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.HashSet;
import java.util.Map;
import org.eclipse.jubula.client.core.businessprocess.BasicCompNameCache;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.utils.AbstractNonPostOperatingTreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.TreeTraverser;

public class ProjectCompNameCache
extends BasicCompNameCache {
    public ProjectCompNameCache(IPersistentObject context) {
        super(context);
    }

    @Override
    public void handleExistingNames(Map<String, String> guidToCompNameMap) {
        ExistingCompTypeHandler operation = new ExistingCompTypeHandler(guidToCompNameMap);
        new TreeTraverser((IProjectPO)this.getContext(), operation, true).traverse(true);
        for (IAUTMainPO aut : ((IProjectPO)this.getContext()).getAutMainList()) {
            for (IObjectMappingAssoziationPO assoc : aut.getObjMap().getMappings()) {
                HashSet guidIntersection = new HashSet();
                guidIntersection.retainAll(assoc.getLogicalNames());
                for (String guid : guidIntersection) {
                    assoc.removeLogicalName(guid);
                    assoc.addLogicalName(guidToCompNameMap.get(guid));
                }
            }
        }
    }

    private class ExistingCompTypeHandler
    extends AbstractNonPostOperatingTreeNodeOperation<INodePO> {
        private Map<String, String> m_guidToCompNameMap;

        public ExistingCompTypeHandler(Map<String, String> guidToCompNameMap) {
            this.m_guidToCompNameMap = guidToCompNameMap;
        }

        @Override
        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            ICapPO capPo;
            if (node instanceof IExecTestCasePO) {
                IExecTestCasePO execTc = (IExecTestCasePO)node;
                for (ICompNamesPairPO pair : execTc.getCompNamesPairs()) {
                    if (this.m_guidToCompNameMap.containsKey(pair.getFirstName())) {
                        pair.setFirstName(this.m_guidToCompNameMap.get(pair.getFirstName()));
                    }
                    if (!this.m_guidToCompNameMap.containsKey(pair.getSecondName())) continue;
                    pair.setSecondName(this.m_guidToCompNameMap.get(pair.getSecondName()));
                }
            } else if (node instanceof ICapPO && this.m_guidToCompNameMap.containsKey((capPo = (ICapPO)node).getComponentName())) {
                capPo.setComponentName(this.m_guidToCompNameMap.get(capPo.getComponentName()));
            }
            return true;
        }
    }
}

