/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.eclipse.jubula.client.core.businessprocess.CalcTypes;
import org.eclipse.jubula.client.core.businessprocess.CompNameTypeManager;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.MapCounter;
import org.eclipse.jubula.client.core.businessprocess.db.TestSuiteBP;
import org.eclipse.jubula.client.core.businessprocess.problems.ProblemType;
import org.eclipse.jubula.client.core.businessprocess.treeoperations.CountCompNameUsage;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.CompNamePM;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PersistenceUtil;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.TreeTraverser;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;

public class CompNameManager
implements IComponentNameCache {
    public static final String UNKNOWN_COMPONENT_TYPE = "guidancer.abstract.Unknown";
    private static final Integer IN_REUSED = -2;
    private static final Integer IN_CURRENT = -1;
    private static CompNameManager instance = null;
    private IProjectPO m_project;
    private HashMap<String, IComponentNamePO> m_compNames;
    private MapCounter m_usage;
    private HashMap<String, Integer> m_logicalNames;
    private Map<String, ProblemType> m_allTypeProblems;

    private CompNameManager() {
        this.clear();
    }

    public static final CompNameManager getInstance() {
        if (instance == null) {
            instance = new CompNameManager();
        }
        return instance;
    }

    @Override
    public void clear() {
        this.m_compNames = new HashMap(20);
        this.m_usage = new MapCounter();
        this.m_logicalNames = new HashMap(20);
        this.m_project = GeneralStorage.getInstance().getProject();
    }

    public final void init() throws PMException {
        this.clear();
        this.initCompNamesTransitive(this.m_project.getId(), new HashSet<Long>(5));
        this.countUsage();
        this.recalculateTypes();
    }

    private void initCompNamesTransitive(Long projectID, Set<Long> loadedProjectIds) throws PMException {
        if (projectID == null) {
            return;
        }
        this.readCompNamesForProjectID(projectID);
        for (IReusedProjectPO usedProj : ProjectPM.getReusedProjectsForProject(projectID)) {
            String reusedGuid = usedProj.getProjectGuid();
            Integer reuseMajVers = usedProj.getMajorNumber();
            Integer reuseMinVers = usedProj.getMinorNumber();
            Integer reuseMicVers = usedProj.getMicroNumber();
            String reuseQualVers = usedProj.getVersionQualifier();
            try {
                Long usedProjId = ProjectPM.findProjectIDByGuidAndVersion(reusedGuid, reuseMajVers, reuseMinVers, reuseMicVers, reuseQualVers);
                if (usedProjId == null || !loadedProjectIds.add(usedProjId)) continue;
                this.initCompNamesTransitive(usedProjId, loadedProjectIds);
            }
            catch (JBException jBException) {}
        }
    }

    public void refreshNames(Long projectId) throws PMException {
        this.readCompNamesForProjectID(projectId);
    }

    private void readCompNamesForProjectID(Long projId) throws PMException {
        List<IComponentNamePO> names = CompNamePM.readAllCompNamesRO(projId);
        boolean currProj = false;
        if (this.m_project != null) {
            currProj = projId.equals(this.m_project.getId());
        }
        Integer pos = currProj ? IN_CURRENT : IN_REUSED;
        for (IComponentNamePO compNamePO : names) {
            String name = compNamePO.getName();
            this.m_compNames.put(compNamePO.getGuid(), compNamePO);
            if (this.m_logicalNames.containsKey(name) && !this.m_logicalNames.get(name).equals(IN_CURRENT)) continue;
            this.m_logicalNames.put(name, pos);
        }
    }

    public void countUsage() {
        this.m_usage.clear();
        CountCompNameUsage op = new CountCompNameUsage(this.m_usage);
        TreeTraverser traverser = new TreeTraverser((INodePO)this.m_project, (ITreeNodeOperation<INodePO>)op, true, false);
        traverser.setTraverseReused(false);
        traverser.traverse(true);
        for (ITestSuitePO ts : TestSuiteBP.getListOfTestSuites(this.m_project)) {
            traverser = new TreeTraverser(ts, op);
            traverser.traverse(true);
        }
        this.countCompNamesUsedInAssocs();
    }

    public Object[] getUsedCompNames(Long projId) {
        ArrayList<IComponentNamePO> res = new ArrayList<IComponentNamePO>(this.m_compNames.size());
        for (IComponentNamePO cN : this.m_compNames.values()) {
            if (!cN.getParentProjectId().equals(projId) || cN.getReferencedGuid() != null || this.m_usage.get(cN.getGuid()) == null || this.m_usage.get(cN.getGuid()) <= 0) continue;
            res.add(cN);
        }
        return res.toArray();
    }

    private void countCompNamesUsedInAssocs() {
        Set<IAUTMainPO> auts = this.m_project.getAutMainList();
        for (IAUTMainPO aut : auts) {
            for (IObjectMappingAssoziationPO assoc : aut.getObjMap().getMappings()) {
                if (assoc.getTechnicalName() == null) continue;
                for (String guid : assoc.getLogicalNames()) {
                    String resGuid = this.resolveGuid(guid);
                    Integer count = this.m_usage.get(resGuid);
                    if (count == null) {
                        count = 0;
                    }
                    this.m_usage.put(resGuid, count + 1);
                }
            }
        }
    }

    public Object[] getUnusedCompNames(Long projId) {
        ArrayList<IComponentNamePO> res = new ArrayList<IComponentNamePO>(this.m_compNames.size());
        for (IComponentNamePO cN : this.m_compNames.values()) {
            if (cN.getReferencedGuid() != null || !cN.getParentProjectId().equals(projId) || this.m_usage.get(cN.getGuid()) != null && !this.m_usage.get(cN.getGuid()).equals(0)) continue;
            res.add(cN);
        }
        return res.toArray();
    }

    @Override
    public String getNameByGuid(String guid) {
        IComponentNamePO compNamePo = this.getResCompNamePOByGuid(guid);
        if (compNamePo != null) {
            return compNamePo.getName();
        }
        return guid;
    }

    @Override
    public String getGuidForName(String name) {
        for (IComponentNamePO cN : this.m_compNames.values()) {
            if (!cN.getName().equals(name)) continue;
            return this.resolveGuid(cN.getGuid());
        }
        return null;
    }

    @Override
    public String getGuidForName(String name, Long parentProjectId) {
        for (IComponentNamePO cN : this.m_compNames.values()) {
            if (!cN.getName().equals(name) || !cN.getParentProjectId().equals(parentProjectId)) continue;
            return cN.getGuid();
        }
        return null;
    }

    @Override
    public IComponentNamePO getResCompNamePOByGuid(String guid) {
        return this.m_compNames.get(this.resolveGuid(guid));
    }

    public boolean isLogNameUsed(String name) {
        return this.m_logicalNames.containsKey(name);
    }

    public IComponentNamePO createCompNamePO(String guid, String name, String type, ComponentNamesBP.CompNameCreationContext ctx) {
        IComponentNamePO cN = PoMaker.createComponentNamePO(guid, name, type, ctx, this.m_project.getId());
        return cN;
    }

    public IComponentNamePO createAndPersistCompNamePO(String name, String type, ComponentNamesBP.CompNameCreationContext ctx) throws PMException, ProjectDeletedException {
        IComponentNamePO cN = null;
        EntityManager sess = null;
        String guid = PersistenceUtil.generateUUID();
        try {
            cN = PoMaker.createComponentNamePO(guid, name, type, ctx, this.m_project.getId());
            sess = Persistor.instance().openSession();
            EntityTransaction tx = Persistor.instance().getTransaction(sess);
            sess.persist((Object)cN);
            Persistor.instance().commitTransaction(sess, tx);
        }
        catch (Throwable throwable) {
            Persistor.instance().dropSession(sess);
            throw throwable;
        }
        Persistor.instance().dropSession(sess);
        cN = (IComponentNamePO)GeneralStorage.getInstance().getMasterSession().merge((Object)cN);
        cN.setComponentType(type);
        this.m_compNames.put(guid, cN);
        this.m_logicalNames.put(name, IN_CURRENT);
        return cN;
    }

    public void renameCompName(IComponentNamePO toRename, String newName) throws PMException, ProjectDeletedException {
        Integer pos;
        String guid = toRename.getGuid();
        String oldName = toRename.getName();
        IComponentNamePO cN = this.getResCompNamePOByGuid(guid);
        if (cN != null) {
            cN = PoMaker.cloneCompName(cN);
            EntityManager sess = null;
            try {
                sess = Persistor.instance().openSession();
                EntityTransaction tx = Persistor.instance().getTransaction(sess);
                cN.setName(newName);
                sess.merge((Object)cN);
                Persistor.instance().commitTransaction(sess, tx);
            }
            finally {
                Persistor.instance().dropSession(sess);
            }
            GeneralStorage.getInstance().getMasterSession().refresh((Object)this.getResCompNamePOByGuid(guid));
        }
        if (!(pos = this.m_logicalNames.get(oldName)).equals(IN_REUSED)) {
            this.m_logicalNames.remove(oldName);
            this.m_logicalNames.put(newName, pos);
        } else {
            this.m_logicalNames.put(newName, IN_CURRENT);
        }
        DataEventDispatcher.getInstance().fireDataChangedListener(toRename, DataEventDispatcher.DataState.Renamed, DataEventDispatcher.UpdateState.all);
    }

    public void deleteCompNames(Set<IComponentNamePO> toDel) throws PMException, ProjectDeletedException {
        EntityManager s = null;
        ArrayList<IComponentNamePO> deleted = new ArrayList<IComponentNamePO>(toDel.size());
        try {
            s = Persistor.instance().openSession();
            EntityTransaction tx = Persistor.instance().getTransaction(s);
            Persistor.instance().lockPOSet(s, toDel);
            for (IComponentNamePO compName : toDel) {
                if (CompNamePM.getNumberOfUsages(s, this.m_project.getId(), compName.getGuid()) != 0L) continue;
                deleted.add(compName);
                s.remove(s.merge((Object)compName));
            }
            Persistor.instance().commitTransaction(s, tx);
        }
        finally {
            Persistor.instance().dropSession(s);
        }
        EntityManager main = GeneralStorage.getInstance().getMasterSession();
        ArrayList<DataChangedEvent> events = new ArrayList<DataChangedEvent>(deleted.size());
        for (IComponentNamePO compName : deleted) {
            this.m_compNames.remove(compName.getGuid());
            this.m_usage.getCounter().remove(compName.getGuid());
            Integer num = this.m_logicalNames.get(compName.getName());
            if (num != null && !num.equals(IN_REUSED)) {
                this.m_logicalNames.remove(compName.getName());
            }
            main.detach((Object)compName);
            events.add(new DataChangedEvent(compName, DataEventDispatcher.DataState.Deleted, DataEventDispatcher.UpdateState.all));
        }
        DataEventDispatcher.getInstance().fireDataChangedListener(events.toArray(new DataChangedEvent[0]));
    }

    public void compNamesChanged(CompNamePM.SaveCompNamesData saveData) {
        List<IComponentNamePO> changes = saveData.getDBVersions();
        EntityManager sess = GeneralStorage.getInstance().getMasterSession();
        for (IComponentNamePO changed : changes) {
            String guid = changed.getGuid();
            IComponentNamePO cN = this.m_compNames.get(guid);
            if (cN == null) {
                cN = (IComponentNamePO)sess.find(changed.getClass(), (Object)changed.getId());
                this.m_compNames.put(guid, cN);
                if (this.m_logicalNames.get(cN.getName()) != null) continue;
                this.m_logicalNames.put(cN.getName(), IN_CURRENT);
                continue;
            }
            String name = cN.getName();
            sess.refresh((Object)cN);
            if (name.equals(cN.getName())) continue;
            Integer pos = this.m_logicalNames.get(name);
            if (pos != null && pos.equals(IN_CURRENT)) {
                this.m_logicalNames.remove(name);
            }
            if ((pos = this.m_logicalNames.get(cN.getName())) == null) {
                this.m_logicalNames.put(cN.getName(), IN_CURRENT);
            }
            DataEventDispatcher.getInstance().fireDataChangedListener(cN, DataEventDispatcher.DataState.Renamed, DataEventDispatcher.UpdateState.all);
        }
        this.countUsage();
        this.recalculateTypes();
    }

    public String resolveGuid(String guid) {
        if (guid == null) {
            return guid;
        }
        String curr = guid;
        IComponentNamePO currPO = this.m_compNames.get(guid);
        int num = 0;
        while (currPO != null && currPO.getReferencedGuid() != null && num < 1000) {
            curr = currPO.getReferencedGuid();
            currPO = this.m_compNames.get(guid);
            ++num;
        }
        return curr;
    }

    public String getResLogNameByGuid(String guid) {
        IComponentNamePO cN = this.getResCompNamePOByGuid(guid);
        if (cN == null) {
            return guid;
        }
        return cN.getName();
    }

    @Override
    public void updateStandardMapperAndCleanup(Long projectId) {
    }

    public int getUsageByGuid(String guid) {
        Integer res = this.m_usage.get(guid);
        if (res == null) {
            res = 0;
        }
        return res;
    }

    @Override
    public Collection<IComponentNamePO> getAllCompNamePOs() {
        return this.m_compNames.values();
    }

    public Map<String, ProblemType> getTypeProblems() {
        return this.m_allTypeProblems;
    }

    public void recalculateTypes() {
        String mostAbstract = CompNameTypeManager.getMostAbstractType();
        for (IComponentNamePO cN : CompNameManager.getInstance().getAllCompNamePOs()) {
            if (!GeneralStorage.getInstance().getProject().getId().equals(cN.getParentProjectId())) continue;
            cN.setComponentType(mostAbstract);
            cN.setTypeProblem(null);
        }
        CalcTypes calc = new CalcTypes(CompNameManager.getInstance(), null);
        calc.setWriteTypes(true);
        calc.calculateTypes();
        CompNameManager.getInstance().setTypeProblems(calc);
    }

    public void setTypeProblems(CalcTypes calc) {
        this.m_allTypeProblems = calc.getAllProblems();
    }

    @Override
    public Map<String, IComponentNamePO> getLocalChanges() {
        return new HashMap<String, IComponentNamePO>();
    }
}

