/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.exporter.junit;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.core.exporter.i18n.Messages;
import org.eclipse.jubula.client.core.exporter.junitmodel.Error;
import org.eclipse.jubula.client.core.exporter.junitmodel.Failure;
import org.eclipse.jubula.client.core.exporter.junitmodel.ObjectFactory;
import org.eclipse.jubula.client.core.exporter.junitmodel.Testcase;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.core.model.TestResultParameter;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.tools.internal.i18n.I18n;
import org.eclipse.jubula.tools.internal.objects.event.TestErrorEvent;

public class JUnitXMLGeneratorOperations
implements ITreeNodeOperation<TestResultNode> {
    private TestResultNode m_rootNode;
    private Testcase m_testCase;

    public JUnitXMLGeneratorOperations(TestResultNode node, Testcase tCase) {
        this.setRootNode(node);
        this.setTestCase(tCase);
    }

    public boolean operate(ITreeTraverserContext<TestResultNode> ctx, TestResultNode parent, TestResultNode node, boolean alreadyVisited) {
        if (alreadyVisited) {
            return false;
        }
        if (!alreadyVisited) {
            switch (node.getStatus()) {
                case 21: {
                    return false;
                }
                case 2: {
                    ObjectFactory obF = new ObjectFactory();
                    StringBuilder sb = new StringBuilder();
                    sb.append("\nPath: " + this.getTreePathString(ctx) + "\n");
                    if ("TestErrorEvent.VerifyFailed".equals(node.getEvent().getId())) {
                        Error err = obF.createError();
                        sb.append(this.collectInformationForMessage(node, true));
                        err.setContent(sb.toString());
                        this.m_testCase.getSkippedOrErrorOrFailure().add(err);
                    } else {
                        Failure fail = obF.createFailure();
                        sb.append(this.collectInformationForMessage(node, false));
                        fail.setContent(sb.toString());
                        this.m_testCase.getSkippedOrErrorOrFailure().add(fail);
                    }
                    return false;
                }
                case 5: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private String collectInformationForMessage(TestResultNode node, Boolean errorOrFailure) {
        TestErrorEvent errorEvent;
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(Messages.stepName) + " " + node.getName() + "\n");
        sb.append(String.valueOf(Messages.stepStatus) + " " + node.getStatusString() + "\n");
        sb.append(String.valueOf(Messages.timestamp) + " " + node.getTimeStamp() + "\n");
        if (node.getComponentName() != null && !"".equals(node.getComponentName())) {
            sb.append(String.valueOf(Messages.componentName) + " " + node.getComponentName() + "\n");
        }
        if (StringUtils.isNotBlank((String)node.getComponentType())) {
            sb.append(String.valueOf(Messages.componentType) + " " + node.getComponentType() + "\n");
        }
        sb.append("_______________\n");
        if (errorOrFailure.booleanValue()) {
            errorEvent = node.getEvent();
            sb.append(String.valueOf(Messages.errorType) + " " + I18n.getString((String)errorEvent.getId()) + "\n");
            sb.append(this.collectPropertyInformation(errorEvent));
        }
        if (!errorOrFailure.booleanValue()) {
            errorEvent = node.getEvent();
            sb.append(String.valueOf(Messages.failureType) + " " + I18n.getString((String)errorEvent.getId()) + "\n");
            sb.append(this.collectPropertyInformation(errorEvent));
        }
        sb.append("________________\n");
        List paraList = node.getParameters();
        for (TestResultParameter testResultParameter : paraList) {
            sb.append(String.valueOf(Messages.parameterName) + " " + testResultParameter.getName() + "\n");
            sb.append(String.valueOf(Messages.parameterType) + " " + testResultParameter.getType() + "\n");
            sb.append(String.valueOf(Messages.parameterValue) + " " + testResultParameter.getValue() + "\n");
            sb.append("______\n");
        }
        sb.append("=================\n");
        String failureTraceMessage = sb.toString();
        return failureTraceMessage;
    }

    private String collectPropertyInformation(TestErrorEvent errorEvent) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(Messages.expectedValue) + " " + errorEvent.getProps().get(Messages.guidancerExpectedValue) + "\n");
        sb.append(String.valueOf(Messages.actualValue) + " " + errorEvent.getProps().get(Messages.guidancerActualValue) + "\n");
        return sb.toString();
    }

    private String getTreePathString(ITreeTraverserContext<TestResultNode> ctx) {
        List resNodes = ctx.getCurrentTreePath();
        StringBuilder stringBuilder = new StringBuilder();
        for (TestResultNode testResultNode : resNodes) {
            stringBuilder.append("/" + testResultNode.getName());
        }
        return stringBuilder.toString();
    }

    public void postOperate(ITreeTraverserContext<TestResultNode> ctx, TestResultNode parent, TestResultNode node, boolean alreadyVisited) {
    }

    public TestResultNode getRootNode() {
        return this.m_rootNode;
    }

    public void setRootNode(TestResultNode rootNode) {
        this.m_rootNode = rootNode;
    }

    public Testcase getTestCase() {
        return this.m_testCase;
    }

    public void setTestCase(Testcase testC) {
        this.m_testCase = testC;
    }
}

