/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.javaee.ejb;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TransactionAttributeType implements Enumerator
{
    NOT_SUPPORTED_LITERAL(0, "NotSupported", "NotSupported"),
    SUPPORTS_LITERAL(1, "Supports", "Supports"),
    REQUIRED_LITERAL(2, "Required", "Required"),
    REQUIRES_NEW_LITERAL(3, "RequiresNew", "RequiresNew"),
    MANDATORY_LITERAL(4, "Mandatory", "Mandatory"),
    NEVER_LITERAL(5, "Never", "Never");

    public static final int NOT_SUPPORTED = 0;
    public static final int SUPPORTS = 1;
    public static final int REQUIRED = 2;
    public static final int REQUIRES_NEW = 3;
    public static final int MANDATORY = 4;
    public static final int NEVER = 5;
    private static final TransactionAttributeType[] VALUES_ARRAY;
    public static final List<TransactionAttributeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TransactionAttributeType[]{NOT_SUPPORTED_LITERAL, SUPPORTS_LITERAL, REQUIRED_LITERAL, REQUIRES_NEW_LITERAL, MANDATORY_LITERAL, NEVER_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TransactionAttributeType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TransactionAttributeType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TransactionAttributeType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TransactionAttributeType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TransactionAttributeType get(int value) {
        switch (value) {
            case 0: {
                return NOT_SUPPORTED_LITERAL;
            }
            case 1: {
                return SUPPORTS_LITERAL;
            }
            case 2: {
                return REQUIRED_LITERAL;
            }
            case 3: {
                return REQUIRES_NEW_LITERAL;
            }
            case 4: {
                return MANDATORY_LITERAL;
            }
            case 5: {
                return NEVER_LITERAL;
            }
        }
        return null;
    }

    private TransactionAttributeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

