/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.internal.plugin.JptCommonCorePlugin;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.predicate.Predicate;

public final class PackageFragmentRootTools {
    public static final Predicate<IPackageFragmentRoot> IS_SOURCE_FOLDER = new IsSourceFolder();
    public static final Predicate<IPackageFragmentRoot> IS_FOLDER = new IsFolder();

    public static boolean isSourceFolder(IPackageFragmentRoot pfr) {
        try {
            return PackageFragmentRootTools.isSourceFolder_(pfr);
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return false;
        }
    }

    private static boolean isSourceFolder_(IPackageFragmentRoot pfr) throws JavaModelException {
        return pfr.exists() && pfr.getKind() == 1;
    }

    public static boolean isFolder(IPackageFragmentRoot pfr) {
        try {
            return PackageFragmentRootTools.isFolder_(pfr);
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return false;
        }
    }

    private static boolean isFolder_(IPackageFragmentRoot pfr) throws JavaModelException {
        IResource resource = pfr.getUnderlyingResource();
        return resource != null && resource.getType() == 2;
    }

    private PackageFragmentRootTools() {
        throw new UnsupportedOperationException();
    }

    public static class IsFolder
    extends PredicateAdapter<IPackageFragmentRoot> {
        public boolean evaluate(IPackageFragmentRoot pfr) {
            return PackageFragmentRootTools.isFolder(pfr);
        }
    }

    public static class IsSourceFolder
    extends PredicateAdapter<IPackageFragmentRoot> {
        public boolean evaluate(IPackageFragmentRoot pfr) {
            return PackageFragmentRootTools.isSourceFolder(pfr);
        }
    }

    public static class PackageFragmentTransformer
    extends TransformerAdapter<IPackageFragmentRoot, IPackageFragment> {
        private final String packageName;

        public PackageFragmentTransformer(String packageName) {
            this.packageName = packageName;
        }

        public IPackageFragment transform(IPackageFragmentRoot pfr) {
            return pfr.getPackageFragment(this.packageName);
        }
    }
}

