/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.notifications;

import static org.eclipse.epp.internal.logging.aeri.ide.IDEWorkflow.TOPIC_USER_REQUESTS_DISABLE_NEW_SERVERS;
import static org.eclipse.epp.internal.logging.aeri.ide.utils.IDEConstants.NOTIFY_CONFIGURATION;

import java.text.ChoiceFormat;
import java.util.List;

import javax.inject.Inject;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor;
import org.eclipse.epp.internal.logging.aeri.ide.handlers.OpenServersSetupWizardHandler;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.Messages;
import org.eclipse.epp.internal.logging.aeri.ide.utils.Formats;
import org.eclipse.epp.logging.aeri.core.SystemControl;

import com.google.common.collect.Lists;

public class SetupNewServersNotification extends Notification {

    private List<IServerDescriptor> servers;
    private IEclipseContext context;
    private OpenServersSetupWizardHandler handler;

    @Inject
    public SetupNewServersNotification(IEventBroker broker, IEclipseContext context) {
        super(NOTIFY_CONFIGURATION, broker);
        this.context = context;
        this.handler = handler;
    }

    @Override
    public List<NotificationAction> getActions() {
        NotificationAction a1 = new NotificationAction(Messages.NOTIFICATION_ACTION_ENABLE) {

            @Override
            public void execute() {
                closeWithEvent(null, null);
                SystemControl.executeHandler(OpenServersSetupWizardHandler.class);
            }

        };
        NotificationAction a2 = new NotificationAction(Messages.NOTIFICATION_ACTION_DISABLE) {

            @Override
            public void execute() {
                closeWithEvent(TOPIC_USER_REQUESTS_DISABLE_NEW_SERVERS, null);
            }

        };
        return Lists.newArrayList(a1, a2);
    }

    @Override
    public String getTitle() {
        return title0();
    }

    @Override
    public String getLabel() {
        return Messages.NOTIFICATION_LABEL_SETUP_NEW_SERVERS;
    }

    private String title0() {
        String name = servers.get(0).getName();
        double[] limits = new double[] { 1, 2, 3, 4 };
        // @formatter:off
        String[] formats = new String[] {
                "", //$NON-NLS-1$
                Messages.NOTIFICATION_TITLE_SETUP_NEW_SERVERS_1_ADDITIONAL_SERVER,
                Messages.NOTIFICATION_TITLE_SETUP_NEW_SERVERS_2_ADDITIONAL_SERVERS,
                Formats.format(Messages.NOTIFICATION_TITLE_SETUP_NEW_SERVERS_X_ADDITIONAL_SERVERS, servers.size() - 1)
                };
        // @formatter:on
        String start = new ChoiceFormat(limits, formats).format(servers.size());
        return Formats.format(Messages.NOTIFICATION_TITLE_SETUP_NEW_SERVERS, name, start);
    }

    @Override
    public String getDescription() {
        return Formats.format(Messages.NOTIFICATION_DESCRIPTION_SETUP_NEW_SERVERS, servers.size());
    }

    public void setServers(List<IServerDescriptor> servers) {
        this.servers = servers;
    }

}
