/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide;

import static org.eclipse.epp.internal.logging.aeri.ide.utils.IDEConstants.BUNDLE_ID;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.epp.logging.aeri.core.IModelPackage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class PreferenceInitializer extends AbstractPreferenceInitializer implements IModelPackage.Literals {

    @Override
    public void initializeDefaultPreferences() {
        IEclipsePreferences instanceScope = DefaultScope.INSTANCE.getNode(BUNDLE_ID);
        ScopedPreferenceStore configurationScope = new ScopedPreferenceStore(ConfigurationScope.INSTANCE, BUNDLE_ID);

        String key = USER_SETTINGS__REPORTER_NAME.getName();
        if (configurationScope.contains(key)) {
            instanceScope.put(key, configurationScope.getString(key));
        }
        key = USER_SETTINGS__REPORTER_EMAIL.getName();
        if (configurationScope.contains(key)) {
            instanceScope.put(key, configurationScope.getString(key));
        }

        key = USER_SETTINGS__ANONYMIZE_STACK_TRACES.getName();
        if (configurationScope.contains(key)) {
            instanceScope.putBoolean(key, configurationScope.getBoolean(key));
        }
        key = USER_SETTINGS__ANONYMIZE_MESSAGES.getName();
        if (configurationScope.contains(key)) {
            instanceScope.putBoolean(key, configurationScope.getBoolean(key));
        }
    }
}
