/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.cdo.CDOElement;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckoutManager;
import org.eclipse.emf.cdo.explorer.repositories.CDORepositoryManager;
import org.eclipse.emf.cdo.internal.explorer.bundle.OM;
import org.eclipse.emf.cdo.internal.explorer.checkouts.CDOCheckoutImpl;
import org.eclipse.emf.cdo.internal.explorer.checkouts.CDOCheckoutViewProvider;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.net4j.util.AdapterUtil;

public final class CDOExplorerUtil {
    public static CDORepositoryManager getRepositoryManager() {
        return OM.getRepositoryManager();
    }

    public static CDOCheckoutManager getCheckoutManager() {
        return OM.getCheckoutManager();
    }

    public static CDOCheckout getCheckout(Object object) {
        Notifier notifier;
        CDOView view;
        if (object instanceof CDOView) {
            CDOView view2 = (CDOView)object;
            if (view2.isClosed()) {
                return null;
            }
            return (CDOCheckout)view2.properties().get((Object)CDOCheckoutImpl.CHECKOUT_KEY);
        }
        if (object instanceof URI) {
            URI uri = (URI)object;
            return CDOCheckoutViewProvider.getCheckout(uri);
        }
        if (object instanceof String) {
            String id = (String)object;
            return CDOExplorerUtil.getCheckoutManager().getCheckout(id);
        }
        CDOCheckout checkout = CDOExplorerUtil.walkUp(object, null);
        if (checkout != null) {
            return checkout;
        }
        if (object instanceof Notifier && (view = CDOUtil.getView((Notifier)(notifier = (Notifier)object))) != null) {
            return CDOExplorerUtil.getCheckout(view);
        }
        return null;
    }

    public static Object getParent(Object object) {
        CDOElement cdoElement = (CDOElement)AdapterUtil.adapt((Object)object, CDOElement.class);
        if (cdoElement != null) {
            return cdoElement.getParent();
        }
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            CDOElement element = (CDOElement)EcoreUtil.getExistingAdapter((Notifier)eObject, CDOElement.class);
            if (element != null) {
                return element;
            }
            return CDOElement.getParentOf((EObject)eObject);
        }
        return null;
    }

    public static String getName(Object object) {
        if (object instanceof CDOCheckout) {
            CDOCheckout checkout = (CDOCheckout)object;
            return checkout.getLabel();
        }
        if (object instanceof CDOResourceNode) {
            CDOResourceNode resourceNode = (CDOResourceNode)object;
            return resourceNode.getName();
        }
        return null;
    }

    public static LinkedList<Object> getPath(Object object) {
        LinkedList<Object> path = new LinkedList<Object>();
        if (CDOExplorerUtil.walkUp(object, path) != null) {
            return path;
        }
        return null;
    }

    public static CDOCheckout walkUp(Object object, LinkedList<Object> path) {
        while (object != null) {
            EObject eObject;
            Adapter adapter;
            if (path != null) {
                path.addFirst(object);
            }
            if (object instanceof CDOCheckout) {
                return (CDOCheckout)object;
            }
            if (object instanceof EObject && (adapter = EcoreUtil.getAdapter((List)(eObject = (EObject)object).eAdapters(), CDOCheckout.class)) != null) {
                return (CDOCheckout)adapter;
            }
            object = CDOExplorerUtil.getParent(object);
        }
        return null;
    }
}

