/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.util;

public class StringCompare {
    public static boolean compare(String pattern, String compareStr, boolean noCase) {
        if (pattern == null || compareStr == null) {
            return false;
        }
        if (noCase) {
            pattern = pattern.toUpperCase();
            compareStr = compareStr.toUpperCase();
        }
        int iText = 0;
        int iPattern = 0;
        int lastStar = 0;
        int len = compareStr.length();
        int patternLen = pattern.length();
        while (iPattern < patternLen) {
            char t;
            char p;
            if ((p = pattern.charAt(iPattern++)) == '*') {
                if (iPattern >= patternLen) {
                    while (iText < len) {
                        ++iText;
                    }
                    return true;
                }
                lastStar = iPattern;
                continue;
            }
            if (iText >= len) {
                return false;
            }
            if (p == (t = compareStr.charAt(iText++))) {
                if (lastStar <= 0 || iPattern < patternLen || iText >= len) {
                    continue;
                }
            } else if (lastStar == 0) {
                return false;
            }
            int matched = iPattern - lastStar - 1;
            iPattern = lastStar;
            iText -= matched;
        }
        return iText >= len;
    }
}

