/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.debugger.core;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.ConnectEvent;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.IResourceDisposeListener;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.ServerIdentifier;
import org.eclipse.datatools.sqltools.core.profile.ConnectProfile;
import org.eclipse.datatools.sqltools.core.profile.ISQLToolsProfileListener;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.core.profile.SQLToolsProfileListenersManager;
import org.eclipse.datatools.sqltools.debugger.core.ClientConInfo;
import org.eclipse.datatools.sqltools.debugger.core.IDebugHandler;
import org.eclipse.datatools.sqltools.debugger.core.IDebugHandlerManager;
import org.eclipse.datatools.sqltools.debugger.core.Messages;
import org.eclipse.datatools.sqltools.debugger.core.SQLDebuggerConfiguration;
import org.eclipse.datatools.sqltools.debugger.core.internal.DebuggerCorePlugin;
import org.eclipse.datatools.sqltools.debugger.core.ui.DebuggerCoreUIPlugin;
import org.eclipse.datatools.sqltools.debugger.model.SPDebugModelUtil;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLToolsConnectListener;
import org.eclipse.datatools.sqltools.editor.core.connection.SQLToolsConnectListenersManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class DebugHandlerManager
implements IDebugHandlerManager,
ISQLToolsProfileListener,
ISQLToolsConnectListener {
    Map _debugHandlers = new Hashtable();

    public DebugHandlerManager() {
        SQLToolsProfileListenersManager pManager = SQLToolsProfileListenersManager.getInstance();
        pManager.addProfileListener((ISQLToolsProfileListener)this);
        SQLToolsConnectListenersManager cManager = SQLToolsConnectListenersManager.getInstance();
        cManager.addConnectListener((ISQLToolsConnectListener)this);
    }

    public synchronized IDebugHandler getOrCreateDebugHandler(String profileName) {
        SQLDevToolsConfiguration conf;
        IDebugHandler debugHandler = (IDebugHandler)this._debugHandlers.get(profileName);
        if (debugHandler == null && (conf = SQLToolsFacade.getConfigurationByProfileName((String)profileName)) != null && conf instanceof SQLDebuggerConfiguration) {
            SQLDebuggerConfiguration factory = (SQLDebuggerConfiguration)conf;
            debugHandler = factory.createDebugHandler(profileName);
            this._debugHandlers.put(profileName, debugHandler);
            EditorCorePlugin.getControlConnectionManager().addResourceDisposeListener(profileName, (IResourceDisposeListener)new DebugHandlerDisposeListener(debugHandler));
            debugHandler.init();
        }
        return debugHandler;
    }

    public synchronized void dispose() {
        SQLToolsProfileListenersManager pManager = SQLToolsProfileListenersManager.getInstance();
        pManager.removeProfileListener((ISQLToolsProfileListener)this);
        SQLToolsConnectListenersManager cManager = SQLToolsConnectListenersManager.getInstance();
        cManager.removeConnectListener((ISQLToolsConnectListener)this);
        for (IDebugHandler handler : this._debugHandlers.values()) {
            handler.dispose();
        }
        this._debugHandlers.clear();
    }

    public boolean okToClose(ConnectEvent event) {
        IConnectionProfile connectionProfile = event.getConnectionProfile();
        return !this.hasDebuggingProcObjects(connectionProfile.getName());
    }

    public void aboutToClose(ConnectEvent event) {
    }

    public void profileConnected(ConnectEvent event) {
        IConnectionProfile p = event.getConnectionProfile();
        if (p != null) {
            this.getOrCreateDebugHandler(p.getName());
        }
    }

    public void closeConnection(ConnectEvent event) {
        IDebugHandler handler = (IDebugHandler)this._debugHandlers.get(event.getConnectionProfile().getName());
        if (handler != null) {
            handler.dispose();
            this._debugHandlers.remove(event.getConnectionProfile().getName());
        }
    }

    public void profileChanged(IConnectionProfile profile, String oldName, String oldDesc, Boolean oldAutoConnect, boolean onlyNameChanged, ConnectProfile oldProfile) {
        IDebugHandler handler = (IDebugHandler)this._debugHandlers.get(oldName);
        if (handler != null) {
            ClientConInfo[] clientCons;
            this._debugHandlers.remove(oldName);
            handler.setProfileName(profile.getName());
            this._debugHandlers.put(profile.getName(), handler);
            EditorCorePlugin.getControlConnectionManager().removeResourceDisposeListener(oldName);
            EditorCorePlugin.getControlConnectionManager().addResourceDisposeListener(profile.getName(), (IResourceDisposeListener)new DebugHandlerDisposeListener(handler));
            if (!oldName.equals(profile.getName()) && (clientCons = handler.getClientConInfos()) != null && clientCons.length > 0) {
                int i = 0;
                while (i < clientCons.length) {
                    DatabaseIdentifier di = clientCons[i].getDatabaseIdentifier();
                    if (di.getProfileName().equals(oldName)) {
                        di.setProfileName(profile.getName());
                    }
                    ++i;
                }
            }
        }
        if (!oldName.equals(profile.getName())) {
            SPDebugModelUtil.changeProfileName((String)oldName, (String)profile.getName());
        }
    }

    public void profileAdded(IConnectionProfile profile) {
        if (!ProfileUtil.isSupportedProfile((IConnectionProfile)profile)) {
            return;
        }
    }

    public void profileDeleted(IConnectionProfile profile) {
        IDebugHandler handler = (IDebugHandler)this._debugHandlers.get(profile.getName());
        if (handler != null) {
            handler.dispose();
            this._debugHandlers.remove(profile.getName());
            EditorCorePlugin.getControlConnectionManager().removeResourceDisposeListener(profile.getName());
        }
    }

    public void profileChanged(IConnectionProfile profile) {
    }

    public IDebugHandler[] getDebugHandler(ServerIdentifier serverIdentifier) {
        ArrayList handlers = new ArrayList();
        for (String profile : this._debugHandlers.keySet()) {
            ServerIdentifier serverId = ProfileUtil.getServerIdentifier((DatabaseIdentifier)new DatabaseIdentifier(profile));
            if (!serverId.equals((Object)serverIdentifier)) continue;
            handlers.add(this._debugHandlers.get(profile));
        }
        return handlers.toArray(new IDebugHandler[handlers.size()]);
    }

    public IDebugHandler[] getDebugHandlers() {
        return this._debugHandlers.values().toArray(new IDebugHandler[this._debugHandlers.values().size()]);
    }

    public IDebugHandler getDebugHandler(String profileName) {
        return (IDebugHandler)this._debugHandlers.get(profileName);
    }

    public ServerIdentifier[] getServerIdentifiers() {
        ArrayList<ServerIdentifier> servers = new ArrayList<ServerIdentifier>();
        Iterator iter = this._debugHandlers.keySet().iterator();
        while (iter.hasNext()) {
            ServerIdentifier serverIdentifier = ProfileUtil.getServerIdentifier((DatabaseIdentifier)new DatabaseIdentifier((String)iter.next()));
            if (serverIdentifier == null || servers.contains(serverIdentifier)) continue;
            servers.add(serverIdentifier);
        }
        return servers.toArray(new ServerIdentifier[servers.size()]);
    }

    private boolean hasDebuggingProcObjects(String connectionProfileName) {
        final String tempName = connectionProfileName;
        String[] procNames = SPDebugModelUtil.hasProcInDebugging((String)connectionProfileName);
        if (procNames != null && procNames.length > 0) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < procNames.length) {
                sb.append("\"").append(procNames[i]).append("\"");
                if (i != procNames.length - 1) {
                    sb.append(",");
                }
                ++i;
            }
            final String tempProcNames = sb.toString();
            DebuggerCoreUIPlugin.getActiveWorkbenchShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    Status status = new Status(2, DebuggerCorePlugin.PLUGIN_ID, 0, NLS.bind((String)Messages.SQLToolsConnectListener_close_error, (Object)tempProcNames), null);
                    ErrorDialog.openError((Shell)DebuggerCoreUIPlugin.getActiveWorkbenchWindow().getShell(), (String)Messages.SQLToolsConnectListener_close_error_title, (String)NLS.bind((String)Messages.SQLToolsConnectListener_close_error_message, (Object)tempName), (IStatus)status);
                }
            });
            return true;
        }
        return false;
    }

    class DebugHandlerDisposeListener
    implements IResourceDisposeListener {
        IDebugHandler _debugHandler;

        public DebugHandlerDisposeListener(IDebugHandler debugHandler) {
            this._debugHandler = debugHandler;
        }

        public void dispose() {
            this._debugHandler.dispose();
            Iterator iter = DebugHandlerManager.this._debugHandlers.keySet().iterator();
            String shouldRemoveProfile = null;
            while (iter.hasNext()) {
                String profile = (String)iter.next();
                if (DebugHandlerManager.this._debugHandlers.get(profile) != this._debugHandler) continue;
                shouldRemoveProfile = profile;
                break;
            }
            if (shouldRemoveProfile != null) {
                DebugHandlerManager.this._debugHandlers.remove(shouldRemoveProfile);
            }
        }
    }
}

