/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.ibm.catalog.ICatalogAuthorizationIdentifier;
import org.eclipse.datatools.enablement.ibm.catalog.IDatabaseObject;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogUser;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWOverwriteStatus;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.LUWUtil;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Role;
import org.eclipse.datatools.modelbase.sql.accesscontrol.RoleAuthorization;
import org.eclipse.datatools.modelbase.sql.accesscontrol.SQLAccessControlPackage;
import org.eclipse.datatools.modelbase.sql.accesscontrol.impl.RoleImpl;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LUWCatalogRole
extends RoleImpl
implements ICatalogObject,
ICatalogAuthorizationIdentifier,
IDatabaseObject {
    private boolean receivedPrivilegesLoaded = false;
    private boolean roleAuthorizationLoaded = false;
    private boolean receivedRoleAuthorizationLoaded = false;
    private boolean impactsLoaded = false;
    private Collection impacts = new ArrayList();

    public void refresh() {
        if (this.roleAuthorizationLoaded) {
            this.roleAuthorization.clear();
            this.roleAuthorizationLoaded = false;
        }
        if (this.receivedPrivilegesLoaded) {
            this.receivedPrivilege.clear();
            this.receivedPrivilegesLoaded = false;
        }
        if (this.receivedRoleAuthorizationLoaded) {
            this.receivedRoleAuthorization.clear();
            this.receivedRoleAuthorizationLoaded = false;
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getDatabase();
        return ((LUWCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getDatabase();
    }

    public void refresh(int refreshType) {
        if (!false) {
            this.impacts.clear();
            this.impactsLoaded = false;
        }
    }

    public ICatalogObject[] getImpacted() {
        if (!this.impactsLoaded) {
            this.impacts = this.getImpactedObjects();
            this.impactsLoaded = true;
        }
        ICatalogObject[] objs = new ICatalogObject[this.impacts.size()];
        this.impacts.toArray(objs);
        return objs;
    }

    public Collection getStatistics() {
        return new ArrayList();
    }

    public EList getRoleAuthorization() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getRoleAuthorization();
        }
        if (!this.roleAuthorizationLoaded) {
            this.loadRoleAuthorization();
        }
        return this.roleAuthorization;
    }

    public EList getReceivedRoleAuthorization() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getReceivedRoleAuthorization();
        }
        if (!this.receivedRoleAuthorizationLoaded) {
            this.loadReceivedRoleAuthorization();
        }
        return this.receivedRoleAuthorization;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 14) {
            this.getRoleAuthorization();
        } else if (id == 13) {
            this.getReceivedPrivilege();
        } else if (id == 10) {
            this.getReceivedRoleAuthorization();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadRoleAuthorization() {
        if (this.roleAuthorizationLoaded) {
            return;
        }
        this.roleAuthorizationLoaded = true;
        EList roleAuths = super.getRoleAuthorization();
        Database database = this.getDatabase();
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
        DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            String query = "SELECT GRANTOR,GRANTORTYPE,GRANTEE,GRANTEETYPE,ADMIN FROM SYSCAT.ROLEAUTH WHERE ROLENAME ='" + LUWUtil.getIdentifier(this.getName()) + "'";
            Statement s = this.getConnection().createStatement();
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                RoleAuthorization roleAuth = (RoleAuthorization)factory.create(SQLAccessControlPackage.eINSTANCE.getRoleAuthorization());
                String granteeId = r.getString("GRANTEE").trim();
                AuthorizationIdentifier grantee = null;
                String granteeType = r.getString("GRANTEETYPE");
                grantee = "G".equals(granteeType) ? LUWCatalogDatabase.getAuthorizationId(database, granteeId, "G") : ("R".equals(granteeType) ? LUWCatalogDatabase.getAuthorizationId(database, granteeId, "R") : LUWCatalogDatabase.getAuthorizationId(database, granteeId, "U"));
                String grantorId = r.getString("GRANTOR").trim();
                AuthorizationIdentifier grantor = null;
                String grantorType = r.getString("GRANTORTYPE");
                grantor = "G".equals(grantorType) ? LUWCatalogDatabase.getAuthorizationId(database, grantorId, "G") : ("R".equals(grantorType) ? LUWCatalogDatabase.getAuthorizationId(database, grantorId, "R") : LUWCatalogDatabase.getAuthorizationId(database, grantorId, "U"));
                String admin = r.getString("ADMIN");
                if ("Y".equals(admin)) {
                    roleAuth.setGrantable(true);
                } else {
                    roleAuth.setGrantable(false);
                }
                roleAuth.setGrantee(grantee);
                roleAuth.setGrantor(grantor);
                roleAuths.add((Object)roleAuth);
            }
            r.close();
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadReceivedRoleAuthorization() {
        if (this.receivedRoleAuthorizationLoaded) {
            return;
        }
        this.receivedRoleAuthorizationLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        LUWCatalogUser.loadReceivedRoleAuthorization(this.getConnection(), super.getReceivedRoleAuthorization(), (AuthorizationIdentifier)this);
        this.eSetDeliver(deliver);
    }

    private synchronized void loadReceivedPrivilege() {
        if (this.receivedPrivilegesLoaded) {
            return;
        }
        this.receivedPrivilegesLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogUser.loadReceivedPrivilege(this.getConnection(), super.getReceivedPrivilege(), (AuthorizationIdentifier)this, "R");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private Collection getImpactedObjects() {
        ArrayList impacts = new ArrayList();
        Connection connection = this.getConnection();
        impacts.addAll(LUWCatalogRole.getImpactedAuthorizationIdentifier(connection, (Role)this));
        return impacts;
    }

    protected static Collection getImpactedAuthorizationIdentifier(Connection connection, Role role) {
        ArrayList<AuthorizationIdentifier> impacts = new ArrayList<AuthorizationIdentifier>();
        Iterator iter = role.getRoleAuthorization().iterator();
        while (iter.hasNext()) {
            impacts.add(((RoleAuthorization)iter.next()).getGrantee());
        }
        return impacts;
    }

    public EList getCatalogReceivedPrivileges() {
        this.loadReceivedPrivilege();
        return this.receivedPrivilege;
    }
}

