/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.sorted.mutable;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.sorted.MutableSortedMap;
import org.eclipse.collections.api.partition.list.PartitionMutableList;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.block.factory.Functions;
import org.eclipse.collections.impl.block.procedure.MapCollectProcedure;
import org.eclipse.collections.impl.collection.mutable.CollectionAdapter;
import org.eclipse.collections.impl.factory.SortedMaps;
import org.eclipse.collections.impl.map.sorted.mutable.AbstractMutableSortedMap;
import org.eclipse.collections.impl.map.sorted.mutable.TreeSortedMap;
import org.eclipse.collections.impl.set.mutable.SetAdapter;
import org.eclipse.collections.impl.utility.ArrayIterate;
import org.eclipse.collections.impl.utility.MapIterate;

public class SortedMapAdapter<K, V>
extends AbstractMutableSortedMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final SortedMap<K, V> delegate;

    protected SortedMapAdapter(SortedMap<K, V> newDelegate) {
        if (newDelegate == null) {
            throw new NullPointerException("SortedMapAdapter may not wrap null");
        }
        this.delegate = newDelegate;
    }

    public static <K, V> MutableSortedMap<K, V> adapt(SortedMap<K, V> map) {
        return map instanceof MutableSortedMap ? (MutableSortedMap)map : new SortedMapAdapter<K, V>(map);
    }

    @Override
    public void forEachKeyValue(Procedure2<? super K, ? super V> procedure) {
        MapIterate.forEachKeyValue(this.delegate, procedure);
    }

    @Override
    @Deprecated
    public MutableSortedMap<K, V> newEmpty() {
        return TreeSortedMap.newMap(this.delegate.comparator());
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.delegate.comparator();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Iterator<V> iterator() {
        return this.delegate.values().iterator();
    }

    @Override
    public V remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.delegate.putAll(map);
    }

    @Override
    public MutableCollection<V> values() {
        return CollectionAdapter.adapt(this.delegate.values());
    }

    @Override
    public MutableSet<Map.Entry<K, V>> entrySet() {
        return SetAdapter.adapt(this.delegate.entrySet());
    }

    @Override
    public MutableSet<K> keySet() {
        return SetAdapter.adapt(this.delegate.keySet());
    }

    @Override
    public K firstKey() {
        return this.delegate.firstKey();
    }

    @Override
    public K lastKey() {
        return this.delegate.lastKey();
    }

    @Override
    public MutableSortedMap<K, V> headMap(K toKey) {
        return SortedMapAdapter.adapt(this.delegate.headMap(toKey));
    }

    @Override
    public MutableSortedMap<K, V> tailMap(K fromKey) {
        return SortedMapAdapter.adapt(this.delegate.tailMap(fromKey));
    }

    @Override
    public MutableSortedMap<K, V> subMap(K fromKey, K toKey) {
        return SortedMapAdapter.adapt(this.delegate.subMap(fromKey, toKey));
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.delegate.put(key, value);
    }

    @Override
    public V removeKey(K key) {
        return this.delegate.remove(key);
    }

    @Override
    public boolean removeIf(Predicate2<? super K, ? super V> predicate) {
        int previousSize = this.size();
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (!predicate.accept(entry.getKey(), entry.getValue())) continue;
            iterator.remove();
        }
        return previousSize > this.size();
    }

    @Override
    public MutableSortedMap<K, V> with(Pair<K, V> ... pairs) {
        ArrayIterate.forEach(pairs, new MapCollectProcedure(this, Functions.firstOfPair(), Functions.secondOfPair()));
        return this;
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public MutableSortedMap<K, V> clone() {
        return TreeSortedMap.newMap(this.delegate);
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public MutableSortedMap<K, V> toReversed() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".toReversed() not implemented yet");
    }

    @Override
    public MutableSortedMap<K, V> take(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count);
        }
        MutableSortedMap<K, V> output = SortedMaps.mutable.of(this.comparator());
        Iterator<Map.Entry<K, V>> iterator = this.delegate.entrySet().iterator();
        int countCopy = count;
        while (iterator.hasNext() && countCopy-- > 0) {
            Map.Entry<K, V> next = iterator.next();
            output.put(next.getKey(), next.getValue());
        }
        return output;
    }

    @Override
    public MutableSortedMap<K, V> takeWhile(Predicate<? super V> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".takeWhile() not implemented yet");
    }

    @Override
    public MutableSortedMap<K, V> drop(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count);
        }
        MutableSortedMap<K, V> output = SortedMaps.mutable.of(this.comparator());
        Iterator<Map.Entry<K, V>> iterator = this.delegate.entrySet().iterator();
        int start = Math.min(count, this.size());
        if (start == this.size()) {
            return output;
        }
        int i = 0;
        while (iterator.hasNext()) {
            if (i >= start) {
                Map.Entry<K, V> next = iterator.next();
                output.put(next.getKey(), next.getValue());
            } else {
                iterator.next();
            }
            ++i;
        }
        return output;
    }

    @Override
    public MutableSortedMap<K, V> dropWhile(Predicate<? super V> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".dropWhile() not implemented yet");
    }

    @Override
    public PartitionMutableList<V> partitionWhile(Predicate<? super V> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".partitionWhile() not implemented yet");
    }

    @Override
    public MutableList<V> distinct() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".distinct() not implemented yet");
    }
}

