/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.includebrowser;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.includebrowser.IBNode;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.editors.text.ILocationProvider;

public class IBConversions {
    public static IBNode selectionToNode(ISelection sel) {
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)sel;
            for (Object o : ssel) {
                if (!(o instanceof IBNode)) continue;
                IBNode node = (IBNode)o;
                return node;
            }
        }
        return null;
    }

    public static ITranslationUnit selectionToTU(ISelection sel) {
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)sel;
            Iterator iter = ssel.iterator();
            while (iter.hasNext()) {
                ITranslationUnit tu = IBConversions.objectToTU(iter.next());
                if (tu == null) continue;
                return tu;
            }
        }
        return null;
    }

    public static ISelection nodeSelectionToRepresentedTUSelection(ISelection sel) {
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)sel;
            ArrayList<ITranslationUnit> tus = new ArrayList<ITranslationUnit>();
            for (Object obj : ssel) {
                ITranslationUnit tu;
                if (!(obj instanceof IBNode) || (tu = ((IBNode)obj).getRepresentedTranslationUnit()) == null) continue;
                tus.add(tu);
            }
            return new StructuredSelection(tus);
        }
        return StructuredSelection.EMPTY;
    }

    public static ITranslationUnit objectToTU(Object object) {
        if (object instanceof ITranslationUnit) {
            return (ITranslationUnit)object;
        }
        if (object instanceof IFile) {
            return CoreModelUtil.findTranslationUnit((IFile)((IFile)object));
        }
        if (object instanceof IAdaptable) {
            IPath path;
            IAdaptable adaptable = (IAdaptable)object;
            ITranslationUnit result = (ITranslationUnit)adaptable.getAdapter(ITranslationUnit.class);
            if (result != null) {
                return result;
            }
            IFile file = (IFile)adaptable.getAdapter(IFile.class);
            if (file != null) {
                return CoreModelUtil.findTranslationUnit((IFile)file);
            }
            ILocationProvider locProvider = (ILocationProvider)adaptable.getAdapter(ILocationProvider.class);
            if (locProvider != null && (path = locProvider.getPath((Object)locProvider)) != null) {
                try {
                    return CoreModelUtil.findTranslationUnitForLocation((IPath)path, null);
                }
                catch (CModelException e) {
                    CUIPlugin.log(e);
                }
            }
        }
        return null;
    }
}

