/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.buildmodel;

import java.io.PrintStream;
import java.util.HashSet;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildIOType;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildResource;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildStep;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildStep;

public class DbgUtil {
    public static boolean DEBUG = false;
    private static PrintStream out = System.out;
    private static final String TRACE_PREFIX = "BuildModel[ ";
    private static final String TRACE_SUFIX = " ]";

    public static void trace(String str) {
        out.println(DbgUtil.formatMsg(str));
    }

    public static String formatMsg(String msg) {
        return TRACE_PREFIX + msg + TRACE_SUFIX;
    }

    public static String stepName(IBuildStep action) {
        ITool tool;
        ITool iTool = tool = action instanceof BuildStep ? ((BuildStep)action).getTool() : null;
        if (tool != null) {
            return tool.getName();
        }
        if (action.getBuildDescription().getInputStep() == action) {
            return "input step";
        }
        if (action.getBuildDescription().getOutputStep() == action) {
            return "output step";
        }
        return "<undefined name>";
    }

    public static String resourceName(IBuildResource rc) {
        if (rc.getFullPath() != null) {
            return rc.getFullPath().toString();
        }
        return rc.getLocation().toString();
    }

    public static String dumpType(IBuildIOType type) {
        StringBuilder buf = new StringBuilder();
        buf.append("dumping type: ");
        buf.append(type.isInput() ? "INPUT" : "OUTPUT");
        buf.append(DbgUtil.ioTypeResources(type));
        buf.append("end dumping type");
        return buf.toString();
    }

    public static String ioTypeResources(IBuildIOType type) {
        StringBuilder buf = new StringBuilder();
        IBuildResource[] rcs = type.getResources();
        buf.append("\n");
        int i = 0;
        while (i < rcs.length) {
            buf.append(DbgUtil.resourceName(rcs[i]));
            buf.append("\n");
            ++i;
        }
        return buf.toString();
    }

    public static String dumpStep(IBuildStep step, boolean inputs) {
        StringBuilder buf = new StringBuilder();
        buf.append("dumping step ").append(DbgUtil.stepName(step)).append(inputs ? " inputs" : " outputs");
        IBuildIOType[] types = inputs ? step.getInputIOTypes() : step.getOutputIOTypes();
        buf.append('\n');
        int i = 0;
        while (i < types.length) {
            buf.append("ioType ").append(i).append(':');
            buf.append(DbgUtil.ioTypeResources(types[i]));
            ++i;
        }
        buf.append("end dump step\n");
        return buf.toString();
    }

    public static String dumpStep(IBuildStep step) {
        return String.valueOf(DbgUtil.dumpStep(step, true)) + DbgUtil.dumpStep(step, false);
    }

    public static String dumpResource(IBuildResource rc) {
        return String.valueOf(DbgUtil.dumpResource(rc, true)) + DbgUtil.dumpResource(rc, false);
    }

    public static String dumpResource(IBuildResource rc, boolean producer) {
        StringBuilder buf = new StringBuilder();
        buf.append("dumping resource ").append(DbgUtil.resourceName(rc)).append(producer ? " producer:" : " deps:");
        if (producer) {
            if (rc.getProducerIOType() != null) {
                buf.append(DbgUtil.dumpStep(rc.getProducerIOType().getStep()));
            } else {
                buf.append("\nresourse has no producer\n");
            }
        } else {
            IBuildIOType[] types = rc.getDependentIOTypes();
            if (types.length > 0) {
                HashSet<IBuildStep> set = new HashSet<IBuildStep>();
                int i = 0;
                while (i < types.length) {
                    if (set.add(types[i].getStep())) {
                        buf.append(DbgUtil.dumpStep(types[i].getStep()));
                    }
                    ++i;
                }
            } else {
                buf.append("\n resource has no deps\n");
            }
        }
        buf.append("end dump resource\n");
        return buf.toString();
    }

    public static void flush() {
        out.flush();
    }
}

