/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.bpel.common.ui.details.viewers.ComboViewer;
import org.eclipse.bpel.common.wsdl.helpers.UriAndUrlHelper;
import org.eclipse.bpel.common.wsdl.parsers.WsdlParser;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.PortType;

public class NewBpelFilePortTypePage
extends WizardPage {
    public static final String PAGE_NAME = "port-type-page";
    private String wsdlUrl;
    private PortType portType;
    private boolean importWsdl = true;
    private final Image workspaceImg;
    private final Image fileSystemImg;
    private final Image parseImg;

    public NewBpelFilePortTypePage() {
        super(PAGE_NAME);
        this.setTitle("Service Contract");
        this.setDescription("Select the service contract the BPEL process must implement.");
        this.setImageDescriptor(BPELUIPlugin.INSTANCE.getImageDescriptor("wizban/new_bpel.gif"));
        this.workspaceImg = BPELUIPlugin.createImage("icons/obj16/workspace.gif");
        this.fileSystemImg = BPELUIPlugin.createImage("icons/obj16/file_system.gif");
        this.parseImg = BPELUIPlugin.createImage("icons/obj16/parse.gif");
    }

    public void dispose() {
        if (this.fileSystemImg != null && !this.fileSystemImg.isDisposed()) {
            this.fileSystemImg.dispose();
        }
        if (this.workspaceImg != null && !this.workspaceImg.isDisposed()) {
            this.workspaceImg.dispose();
        }
        if (this.parseImg != null && !this.parseImg.isDisposed()) {
            this.parseImg.dispose();
        }
        super.dispose();
    }

    public IWizardPage getNextPage() {
        IWizardPage nextPage = this.getWizard().getPage("location-page");
        nextPage.setPreviousPage((IWizardPage)this);
        return nextPage;
    }

    public String getWsdlUrl() {
        return this.wsdlUrl;
    }

    public boolean isImportWsdl() {
        return this.importWsdl;
    }

    public PortType getPortType() {
        return this.portType;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setFont(parent.getFont());
        this.initializeDialogUnits((Control)parent);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)container);
        Label l = new Label(container, 0);
        l.setText("WSDL URL:");
        l.setToolTipText("The URL of the service description (WSDL)");
        l.setLayoutData((Object)new GridData(128, -1, false, false));
        final Text wsdlUrlText = new Text(container, 2052);
        wsdlUrlText.setLayoutData((Object)new GridData(768));
        wsdlUrlText.setToolTipText("Press the 'Tab' key to parse this WSDL");
        if (this.wsdlUrl != null) {
            wsdlUrlText.setText(this.wsdlUrl);
        }
        wsdlUrlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewBpelFilePortTypePage.this.wsdlUrl = ((Text)e.widget).getText();
                NewBpelFilePortTypePage.this.updateStatus();
            }
        });
        final ControlDecoration wsdlTextDecoration = new ControlDecoration((Control)wsdlUrlText, 17408);
        wsdlTextDecoration.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK"));
        wsdlTextDecoration.setDescriptionText(wsdlUrlText.getToolTipText());
        wsdlTextDecoration.hide();
        new Label(container, 0);
        Composite subContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginBottom = 13;
        subContainer.setLayout((Layout)layout);
        subContainer.setLayoutData((Object)new GridData(768));
        new Label(subContainer, 0).setImage(this.fileSystemImg);
        Link browseFileSystemLink = new Link(subContainer, 0);
        browseFileSystemLink.setText("<A>Browse the file system...</A>");
        new Label(subContainer, 0).setImage(this.workspaceImg);
        Link browseWorkspaceLink = new Link(subContainer, 0);
        browseWorkspaceLink.setText("<A>Browse the workspace...</A>");
        new Label(subContainer, 0).setImage(this.parseImg);
        Link parseWsdlLink = new Link(subContainer, 0);
        parseWsdlLink.setText("<A>Parse the given WSDL</A>");
        l = new Label(container, 0);
        l.setText("Service Contract:");
        l.setToolTipText("The port type (service contract) to implement with BPEL");
        final ComboViewer portTypeCombo = new ComboViewer(container, 2060);
        portTypeCombo.getCombo().setLayoutData((Object)new GridData(768));
        portTypeCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        portTypeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                QName name = ((PortType)element).getQName();
                return String.valueOf(name.getLocalPart()) + " - " + name.getNamespaceURI();
            }
        });
        new Label(container, 0);
        Button importButton = new Button(container, 32);
        importButton.setText("Import the WSDL file with its dependencies");
        importButton.setSelection(this.importWsdl);
        importButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                NewBpelFilePortTypePage.this.importWsdl = ((Button)e.widget).getSelection();
            }
        });
        subContainer = new Composite(container, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginTop = 11;
        subContainer.setLayout((Layout)layout);
        GridData layoutData = new GridData(1808);
        layoutData.horizontalSpan = 2;
        subContainer.setLayoutData((Object)layoutData);
        l = new Label(subContainer, 0);
        l.setText("Select a service contract (port type) and see its operations below.");
        final TreeViewer operationsViewer = new TreeViewer(subContainer, 2048);
        operationsViewer.getTree().setLayoutData((Object)new GridData(1808));
        operationsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                Image result = null;
                if (element instanceof Operation) {
                    result = BPELUIPlugin.INSTANCE.getImage("obj16/operation.gif");
                } else if (element instanceof Input) {
                    result = BPELUIPlugin.INSTANCE.getImage("obj16/input.gif");
                } else if (element instanceof Output) {
                    result = BPELUIPlugin.INSTANCE.getImage("obj16/output.gif");
                } else if (element instanceof Fault) {
                    result = BPELUIPlugin.INSTANCE.getImage("obj16/fault.gif");
                }
                return result;
            }

            public String getText(Object element) {
                String result = "";
                if (element instanceof Operation) {
                    result = ((Operation)element).getName();
                    result = result == null || result.trim().length() == 0 ? "?" : result;
                } else if (element instanceof Input) {
                    result = ((Input)element).getName();
                    result = result == null || result.trim().length() == 0 ? "Input" : result;
                } else if (element instanceof Output) {
                    result = ((Output)element).getName();
                    result = result == null || result.trim().length() == 0 ? "Output" : result;
                } else if (element instanceof Fault) {
                    result = ((Fault)element).getName();
                    result = result == null || result.trim().length() == 0 ? "Fault" : result;
                }
                return result;
            }
        });
        operationsViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return ((PortType)inputElement).getOperations().toArray();
            }

            public Object[] getChildren(Object pa) {
                ArrayList<Object> result = new ArrayList<Object>();
                if (pa instanceof Operation) {
                    Operation op = (Operation)pa;
                    if (op.getInput() != null) {
                        result.add(op.getInput());
                    }
                    if (op.getOutput() != null) {
                        result.add(op.getOutput());
                    }
                    if (op.getFaults() != null) {
                        result.addAll(op.getFaults().values());
                    }
                }
                return result.toArray();
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return element instanceof Operation;
            }
        });
        portTypeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewBpelFilePortTypePage.this.portType = (PortType)((IStructuredSelection)portTypeCombo.getSelection()).getFirstElement();
                operationsViewer.setInput((Object)NewBpelFilePortTypePage.this.portType);
                operationsViewer.refresh();
                if (NewBpelFilePortTypePage.this.portType != null) {
                    if (NewBpelFilePortTypePage.this.portType.getOperations().size() < 4) {
                        operationsViewer.expandAll();
                    } else {
                        operationsViewer.expandToLevel(2);
                    }
                }
                NewBpelFilePortTypePage.this.updateStatus();
            }
        });
        final ArrayList portTypes = new ArrayList();
        final IRunnableWithProgress wsdlParsingOperation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("Parsing the WSDL...", 5);
                try {
                    portTypes.clear();
                    monitor.worked(1);
                    URI emfUri = URI.createURI((String)NewBpelFilePortTypePage.this.wsdlUrl);
                    Collection definitions = WsdlParser.loadAllWsdlDefinitions((URI)emfUri, (ResourceSet)WsdlParser.createBasicResourceSetForWsdl());
                    for (Definition def : definitions) {
                        for (Object o : def.getPortTypes().values()) {
                            portTypes.add((PortType)o);
                        }
                    }
                    monitor.worked(3);
                }
                finally {
                    monitor.done();
                }
            }
        };
        wsdlUrlText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (NewBpelFilePortTypePage.this.wsdlUrl == null) {
                    return;
                }
                try {
                    NewBpelFilePortTypePage.this.getContainer().run(true, false, wsdlParsingOperation);
                    portTypeCombo.setInput((Object)portTypes);
                    portTypeCombo.refresh();
                    if (portTypes.size() > 0) {
                        portTypeCombo.getCombo().select(0);
                    }
                    portTypeCombo.getCombo().notifyListeners(13, new Event());
                }
                catch (InvocationTargetException e1) {
                    BPELUIPlugin.log(e1);
                }
                catch (InterruptedException e1) {
                    BPELUIPlugin.log(e1);
                }
            }
        });
        wsdlUrlText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                wsdlTextDecoration.hide();
            }

            public void focusGained(FocusEvent e) {
                wsdlTextDecoration.show();
            }
        });
        browseFileSystemLink.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(NewBpelFilePortTypePage.this.getShell());
                dlg.setFilterExtensions(new String[]{"*.wsdl"});
                dlg.setFilterNames(new String[]{"WSDL (*.wsdl)"});
                dlg.setText("Select a service description (WSDL).");
                String path = dlg.open();
                if (path != null) {
                    File f = new File(path);
                    wsdlUrlText.setText(f.toURI().toString());
                    wsdlUrlText.notifyListeners(31, new Event());
                }
            }
        });
        parseWsdlLink.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                wsdlUrlText.notifyListeners(31, new Event());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                wsdlUrlText.notifyListeners(31, new Event());
            }
        });
        browseWorkspaceLink.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                IFile currentWsdl = null;
                if (NewBpelFilePortTypePage.this.wsdlUrl != null) {
                    try {
                        java.net.URI uri = UriAndUrlHelper.urlToUri((String)NewBpelFilePortTypePage.this.wsdlUrl);
                        File f = new File(uri);
                        Path path = new Path(f.getAbsolutePath());
                        currentWsdl = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
                    }
                    catch (Exception e1) {
                        BPELUIPlugin.log(e1, 2);
                    }
                }
                final List workspaceWsdlFiles = NewBpelFilePortTypePage.getFiles("wsdl", Arrays.asList(ResourcesPlugin.getWorkspace().getRoot()));
                ElementTreeSelectionDialog dlg = new ElementTreeSelectionDialog(NewBpelFilePortTypePage.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider(){

                    public Object[] getChildren(Object element) {
                        Object[] result = super.getChildren(element);
                        if (result == null) {
                            result = new Object[]{};
                        }
                        ArrayList<Object> filteredResult = new ArrayList<Object>();
                        Object[] objectArray = result;
                        int n = result.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object o = objectArray[n2];
                            if (o instanceof IFile && workspaceWsdlFiles.contains(o)) {
                                filteredResult.add(o);
                            } else if (o instanceof IContainer) {
                                IPath containerPath = ((IContainer)o).getFullPath();
                                for (IFile wsdlFile : workspaceWsdlFiles) {
                                    if (!containerPath.isPrefixOf(wsdlFile.getFullPath())) continue;
                                    filteredResult.add(o);
                                    break;
                                }
                            }
                            ++n2;
                        }
                        return filteredResult.toArray();
                    }
                });
                dlg.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dlg.setTitle("WSDL Selection");
                dlg.setMessage("Select a WSDL file located in the workspace.");
                if (currentWsdl != null) {
                    dlg.setInitialElementSelections(Arrays.asList(currentWsdl));
                }
                if (dlg.open() == 0) {
                    IFile selectedFile = (IFile)dlg.getResult()[0];
                    wsdlUrlText.setText(selectedFile.getLocation().toFile().toURI().toString());
                    wsdlUrlText.notifyListeners(31, new Event());
                }
            }
        });
        if (this.portType != null) {
            portTypeCombo.setSelection((ISelection)new StructuredSelection((Object)this.portType));
        } else if (portTypeCombo.getCombo().getItemCount() > 0) {
            portTypeCombo.getCombo().select(0);
            portTypeCombo.getCombo().notifyListeners(13, new Event());
        }
        this.updateStatus();
        if (this.getErrorMessage() != null) {
            this.setPageComplete(false);
            this.setErrorMessage(null);
        }
    }

    private void updateStatus() {
        String errorMsg = this.validatePage();
        this.setPageComplete(errorMsg == null);
        this.setErrorMessage(errorMsg);
    }

    private String validatePage() {
        String errorMsg = null;
        if (this.wsdlUrl == null || this.wsdlUrl.trim().length() == 0) {
            errorMsg = "You must specify the URL of a service description (WSDL).";
        } else if (this.portType == null) {
            errorMsg = "You must select a port type (contract) to implement in the BPEL process.";
        }
        return errorMsg;
    }

    private static List<IFile> getFiles(String extension, Collection<? extends IContainer> containers) {
        ArrayList<IFile> result = new ArrayList<IFile>();
        if (containers == null) {
            return result;
        }
        for (IContainer iContainer : containers) {
            try {
                IResource[] resources;
                IResource[] iResourceArray = resources = iContainer.members();
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    switch (resource.getType()) {
                        case 1: {
                            if (!"*".equals(extension) && !extension.equalsIgnoreCase(resource.getFileExtension())) break;
                            result.add((IFile)resource);
                            break;
                        }
                        case 2: {
                            IFolder subFolder = (IFolder)resource;
                            result.addAll(NewBpelFilePortTypePage.getFiles(extension, Arrays.asList(subFolder)));
                            break;
                        }
                        case 4: {
                            IProject project = (IProject)resource;
                            if (!project.isAccessible()) break;
                            result.addAll(NewBpelFilePortTypePage.getFiles(extension, Arrays.asList(project)));
                            break;
                        }
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                BPELUIPlugin.log(e, 4);
            }
        }
        return result;
    }
}

