/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editparts.borders;

import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.editparts.borders.CollapsableBorder;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.core.resources.IMarker;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class ScopeBorder
extends CollapsableBorder {
    static final int borderWidth = 1;
    static final int margin = 11;
    static final int hBorderInsets = 11;
    static final int vBorderInsets = 16;
    static final int extraHorizontalSpace = 50;
    private org.eclipse.draw2d.geometry.Rectangle rectExpandedTop;
    private org.eclipse.draw2d.geometry.Rectangle rectExpandedBottom;
    private org.eclipse.draw2d.geometry.Rectangle expandedBounds;
    private int faultImageWidth;
    private int faultImageHeight;
    private int compensationImageWidth;
    private int compensationImageHeight;
    private int terminationImageWidth;
    private int terminationImageHeight;
    private int eventImageWidth;
    private int eventImageHeight;
    private Image compensationImage;
    private Image terminationImage;
    private Image faultImage = BPELUIPlugin.INSTANCE.getImage("ovr16/faulthandler.gif");
    private Image eventImage;
    private boolean showFault;
    private boolean showCompensation;
    private boolean showTermination;
    private boolean showEvent;
    private org.eclipse.draw2d.geometry.Rectangle rectFault;
    private org.eclipse.draw2d.geometry.Rectangle rectCompensation;
    private org.eclipse.draw2d.geometry.Rectangle rectTermination;
    private org.eclipse.draw2d.geometry.Rectangle rectEvent;
    private IFigure faultImageFigure;
    private IFigure compensationImageFigure;
    private IFigure terminationImageFigure;
    private IFigure eventImageFigure;

    public ScopeBorder(IFigure parentFigure, String labelText, Image image) {
        super(true, 7, parentFigure, labelText, image);
        Rectangle r = this.faultImage.getBounds();
        this.faultImageWidth = r.width;
        this.faultImageHeight = r.height;
        this.compensationImage = BPELUIPlugin.INSTANCE.getImage("ovr16/compensationhandler.gif");
        r = this.compensationImage.getBounds();
        this.compensationImageWidth = r.width;
        this.compensationImageHeight = r.height;
        this.terminationImage = BPELUIPlugin.INSTANCE.getImage("ovr16/terminationhandler.gif");
        r = this.terminationImage.getBounds();
        this.terminationImageWidth = r.width;
        this.terminationImageHeight = r.height;
        this.eventImage = BPELUIPlugin.INSTANCE.getImage("ovr16/eventhandler.gif");
        r = this.eventImage.getBounds();
        this.eventImageWidth = r.width;
        this.eventImageHeight = r.height;
        this.faultImageFigure = new ImageFigure(this.faultImage);
        this.faultImageFigure.setParent(parentFigure);
        this.compensationImageFigure = new ImageFigure(this.compensationImage);
        this.compensationImageFigure.setParent(parentFigure);
        this.terminationImageFigure = new ImageFigure(this.terminationImage);
        this.terminationImageFigure.setParent(parentFigure);
        this.eventImageFigure = new ImageFigure(this.eventImage);
        this.eventImageFigure.setParent(parentFigure);
    }

    public Dimension getPreferredSize(IFigure f) {
        this.calculate(f);
        Dimension d = new Dimension(this.rectCollapsed.width, this.rectCollapsed.height + this.expandedHeight);
        d.width += 32;
        if (!this.isCollapsed()) {
            d.width += 50;
        }
        return d;
    }

    @Override
    protected void doPaint(IFigure figure, Graphics graphics, Insets insets) {
        super.doPaint(figure, graphics, insets);
        ColorRegistry registry = BPELUIPlugin.INSTANCE.getColorRegistry();
        Color old = graphics.getForegroundColor();
        graphics.setForegroundColor(registry.get("scopeActivityBorder"));
        graphics.drawRoundRectangle(this.expandedBounds, 7, 7);
        graphics.drawRectangle(this.expandedBounds.x, this.expandedBounds.y, this.expandedBounds.width, 3);
        graphics.setForegroundColor(Display.getCurrent().getSystemColor(1));
        graphics.drawRectangle(this.expandedBounds.x + 1, this.expandedBounds.y + 1, this.expandedBounds.width - 2, 1);
        graphics.setForegroundColor(old);
        if (this.isCollapsed()) {
            graphics.drawImage(this.collapsedImage, this.rectCollapsed.getLocation());
        } else {
            graphics.drawImage(this.expandedImage, this.rectExpandedTop.getLocation());
            graphics.drawImage(this.expandedImage, this.rectExpandedBottom.getLocation());
        }
        org.eclipse.draw2d.geometry.Rectangle oldClip = new org.eclipse.draw2d.geometry.Rectangle();
        oldClip = graphics.getClip(oldClip);
        if (this.showFault) {
            graphics.setClip(this.faultImageFigure.getBounds().getCopy());
            this.faultImageFigure.paint(graphics);
            graphics.setClip(oldClip);
        }
        if (this.showCompensation) {
            graphics.setClip(this.compensationImageFigure.getBounds().getCopy());
            this.compensationImageFigure.paint(graphics);
            graphics.setClip(oldClip);
        }
        if (this.showTermination) {
            graphics.setClip(this.terminationImageFigure.getBounds().getCopy());
            this.terminationImageFigure.paint(graphics);
            graphics.setClip(oldClip);
        }
        if (this.showEvent) {
            graphics.setClip(this.eventImageFigure.getBounds().getCopy());
            this.eventImageFigure.paint(graphics);
            graphics.setClip(oldClip);
        }
    }

    @Override
    protected void calculate(IFigure figure) {
        Image bottomImage;
        Image topImage;
        IMarker bottomMarker;
        super.calculate(figure);
        org.eclipse.draw2d.geometry.Rectangle figureBounds = figure.getBounds().getCopy();
        this.rectExpandedTop = new org.eclipse.draw2d.geometry.Rectangle(figureBounds.x + figureBounds.width / 2 - this.expandedWidth / 2, figureBounds.y, this.expandedWidth, this.expandedHeight);
        this.rectExpandedBottom = new org.eclipse.draw2d.geometry.Rectangle(figureBounds.x + figureBounds.width / 2 - this.expandedWidth / 2, figureBounds.y + figureBounds.height - this.expandedHeight - 1, this.expandedWidth, this.expandedHeight);
        this.expandedBounds = figureBounds.getCopy();
        this.expandedBounds.x += 16;
        this.expandedBounds.width -= 32;
        this.expandedBounds.y += this.expandedHeight / 2 - 1;
        this.expandedBounds.height -= this.expandedHeight / 2 - 1;
        this.expandedBounds.height -= this.expandedHeight / 2;
        this.computeHandlerIconPositions(ModelHelper.isHorizontalLayout(this.getEditPart().getModel()), figure);
        IMarker topMarker = this.getTopMarker();
        if (topMarker != null) {
            if (this.isCollapsed()) {
                this.topDrawerLocation.x = this.expandedBounds.x - 16 + 30;
                this.topDrawerLocation.y = this.expandedBounds.y;
            } else {
                this.topDrawerLocation.x = this.expandedBounds.x - 16;
                this.topDrawerLocation.y = this.expandedBounds.y + 7;
            }
        }
        if ((bottomMarker = this.getBottomMarker()) != null) {
            if (this.isCollapsed()) {
                this.bottomDrawerLocation.x = this.expandedBounds.x - 16 + 30;
                this.bottomDrawerLocation.y = this.expandedBounds.y + 12;
            } else {
                this.bottomDrawerLocation.x = this.expandedBounds.x - 16;
                this.bottomDrawerLocation.y = this.expandedBounds.y + 12 + 7;
            }
        }
        if ((topImage = this.getTopImage()) != null) {
            if (this.isCollapsed()) {
                this.topImageLocation.x = this.expandedBounds.x - 16 + 30 + 1;
                this.topImageLocation.y = this.expandedBounds.y + 30;
            } else {
                this.topImageLocation.x = this.expandedBounds.x - 16 + 30;
                this.topImageLocation.y = this.expandedBounds.y + 7 + 30;
            }
        }
        if ((bottomImage = this.getBottomImage()) != null) {
            if (this.isCollapsed()) {
                this.bottomImageLocation.x = this.expandedBounds.x - 16 + 30 + 1;
                this.bottomImageLocation.y = this.expandedBounds.y + 30 + 12;
            } else {
                this.bottomImageLocation.x = this.expandedBounds.x - 16 + 30;
                this.bottomImageLocation.y = this.expandedBounds.y + 7 + 12 + 30;
            }
        }
    }

    @Override
    public Insets getInsets(IFigure figure) {
        Insets result;
        this.calculate(figure);
        if (this.isCollapsed()) {
            result = new Insets(12, 28, 12, 28);
        } else {
            result = new Insets(16 + this.expandedHeight, 11, 16 + this.expandedHeight, 11);
            result.left += 16;
            result.right += 16;
        }
        return result;
    }

    @Override
    public void invalidate() {
        this.rectExpandedTop = null;
        this.rectExpandedBottom = null;
    }

    public boolean isPointInFaultImage(int x, int y) {
        if (this.showFault) {
            Point p = new Point(x, y);
            this.parentFigure.translateToRelative((Translatable)p);
            return this.rectFault.contains(p);
        }
        return false;
    }

    public boolean isPointInCompensationImage(int x, int y) {
        if (this.showCompensation) {
            Point p = new Point(x, y);
            this.parentFigure.translateToRelative((Translatable)p);
            return this.rectCompensation.contains(p);
        }
        return false;
    }

    public boolean isPointInTerminationImage(int x, int y) {
        if (this.showTermination) {
            Point p = new Point(x, y);
            this.parentFigure.translateToRelative((Translatable)p);
            return this.rectTermination.contains(p);
        }
        return false;
    }

    public boolean isPointInEventImage(int x, int y) {
        if (this.showEvent) {
            Point p = new Point(x, y);
            this.parentFigure.translateToRelative((Translatable)p);
            return this.rectEvent.contains(p);
        }
        return false;
    }

    public void setShowEvent(boolean showEvent) {
        this.showEvent = showEvent;
    }

    public void setShowCompensation(boolean showCompensation) {
        this.showCompensation = showCompensation;
    }

    public void setShowTermination(boolean showTermination) {
        this.showTermination = showTermination;
    }

    public void setShowFault(boolean showFault) {
        this.showFault = showFault;
    }

    @Override
    public boolean isPointInCollapseImage(int x, int y) {
        if (this.isCollapsed()) {
            return super.isPointInCollapseImage(x, y);
        }
        Point p = new Point(x, y);
        this.parentFigure.translateToRelative((Translatable)p);
        org.eclipse.draw2d.geometry.Rectangle rect = this.rectExpandedTop.getCopy();
        rect.expand(new Insets(1, 1, 1, 1));
        if (rect.contains(p)) {
            return true;
        }
        if (!this.isCollapsed()) {
            rect = this.rectExpandedBottom.getCopy();
            rect.expand(new Insets(1, 1, 1, 1));
            return rect.contains(p);
        }
        return false;
    }

    @Override
    protected org.eclipse.draw2d.geometry.Rectangle getGradientRect() {
        if (this.isCollapsed()) {
            return super.getGradientRect();
        }
        this.invalidate();
        this.calculate(this.parentFigure);
        return this.expandedBounds;
    }

    private void computeHandlerIconPositions(boolean horizontal, IFigure figure) {
        if (horizontal) {
            int x;
            if (this.showFault) {
                x = this.expandedBounds.x + this.expandedBounds.width - this.faultImageWidth;
                if (this.showCompensation) {
                    x -= this.compensationImageWidth;
                }
                if (this.showTermination) {
                    x -= this.terminationImageWidth;
                }
                if (this.showEvent) {
                    x -= this.eventImageWidth;
                }
                this.rectFault = new org.eclipse.draw2d.geometry.Rectangle(x, figure.getBounds().y + figure.getBounds().height - this.faultImageHeight, this.faultImageWidth, this.faultImageHeight);
            }
            if (this.showCompensation) {
                x = this.expandedBounds.x + this.expandedBounds.width - this.compensationImageWidth;
                if (this.showTermination) {
                    x -= this.terminationImageWidth;
                }
                if (this.showEvent) {
                    x -= this.eventImageWidth;
                }
                this.rectCompensation = new org.eclipse.draw2d.geometry.Rectangle(x, figure.getBounds().y + figure.getBounds().height - this.compensationImageHeight, this.compensationImageWidth, this.compensationImageHeight);
            }
            if (this.showTermination) {
                x = this.expandedBounds.x + this.expandedBounds.width - this.terminationImageWidth;
                if (this.showEvent) {
                    x -= this.eventImageWidth;
                }
                this.rectTermination = new org.eclipse.draw2d.geometry.Rectangle(x, figure.getBounds().y + figure.getBounds().height - this.terminationImageHeight, this.terminationImageWidth, this.terminationImageHeight);
            }
            if (this.showEvent) {
                x = this.expandedBounds.x + this.expandedBounds.width - this.eventImageWidth;
                this.rectEvent = new org.eclipse.draw2d.geometry.Rectangle(x, figure.getBounds().y + figure.getBounds().height - this.eventImageHeight, this.eventImageWidth, this.eventImageHeight);
            }
        } else {
            int y;
            int x;
            if (this.showFault) {
                x = this.expandedBounds.x + this.expandedBounds.width - this.faultImageWidth + 1;
                this.rectFault = new org.eclipse.draw2d.geometry.Rectangle(x, this.expandedBounds.y, this.faultImageWidth, this.faultImageHeight);
            }
            if (this.showCompensation) {
                x = this.expandedBounds.x + this.expandedBounds.width - this.compensationImageWidth + 1;
                y = this.expandedBounds.y;
                if (this.showFault) {
                    y += this.faultImageHeight;
                }
                this.rectCompensation = new org.eclipse.draw2d.geometry.Rectangle(x, y, this.compensationImageWidth, this.compensationImageHeight);
            }
            if (this.showTermination) {
                x = this.expandedBounds.x + this.expandedBounds.width - this.terminationImageWidth + 1;
                y = this.expandedBounds.y;
                if (this.showFault) {
                    y += this.faultImageWidth;
                }
                if (this.showCompensation) {
                    y += this.compensationImageWidth;
                }
                this.rectTermination = new org.eclipse.draw2d.geometry.Rectangle(x, y, this.terminationImageWidth, this.terminationImageHeight);
            }
            if (this.showEvent) {
                x = this.expandedBounds.x + this.expandedBounds.width - this.eventImageWidth + 1;
                y = this.expandedBounds.y;
                if (this.showFault) {
                    y += this.faultImageHeight;
                }
                if (this.showCompensation) {
                    y += this.compensationImageHeight;
                }
                if (this.showTermination) {
                    y += this.terminationImageWidth;
                }
                this.rectEvent = new org.eclipse.draw2d.geometry.Rectangle(x, y, this.eventImageWidth, this.eventImageHeight);
            }
        }
        if (this.showFault) {
            this.faultImageFigure.setBounds(this.rectFault);
        }
        if (this.showCompensation) {
            this.compensationImageFigure.setBounds(this.rectCompensation);
        }
        if (this.showTermination) {
            this.terminationImageFigure.setBounds(this.rectTermination);
        }
        if (this.showEvent) {
            this.eventImageFigure.setBounds(this.rectEvent);
        }
    }

    public IFigure getFaultImageFigure() {
        return this.faultImageFigure;
    }

    public IFigure getCompensationImageFigure() {
        return this.compensationImageFigure;
    }

    public IFigure getTerminationImageFigure() {
        return this.terminationImageFigure;
    }

    public IFigure getEventImageFigure() {
        return this.eventImageFigure;
    }
}

