/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.tray;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpel.common.ui.CommonUIPlugin;
import org.eclipse.bpel.common.ui.details.widgets.NoBorderButton;
import org.eclipse.bpel.common.ui.tray.SelectionBorderFigure;
import org.eclipse.bpel.common.ui.tray.TrayContainerEditPart;
import org.eclipse.bpel.common.ui.tray.TraySelectionEditPolicy;
import org.eclipse.bpel.common.ui.tray.TraySelectionHandle;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.KeyEvent;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.tools.SelectEditPartTracker;

public abstract class TrayCategoryEditPart
extends TrayContainerEditPart {
    protected SelectionBorderFigure titleFigure;

    protected Object addEntry() {
        CreateRequest request = new CreateRequest();
        request.setFactory(this.getCreationFactory());
        Command command = this.getCommand((Request)request);
        this.getCommandStack().execute(command);
        Object newObject = request.getNewObject();
        this.selectEditPart(newObject);
        return newObject;
    }

    public Object publicAddEntry() {
        return this.addEntry();
    }

    protected void removeEntry() {
        List selectedParts = this.getViewer().getSelectedEditParts();
        if (selectedParts.size() == 0) {
            return;
        }
        ArrayList<EditPart> condemned = new ArrayList<EditPart>();
        for (EditPart part : selectedParts) {
            if (part.getParent() != this) continue;
            condemned.add(part);
        }
        if (condemned.isEmpty()) {
            return;
        }
        EditPart indexPart = (EditPart)condemned.get(0);
        int index = this.getModelChildren().indexOf(indexPart.getModel());
        GroupRequest request = new GroupRequest((Object)"delete");
        CompoundCommand deletions = new CompoundCommand();
        for (EditPart part : condemned) {
            deletions.add(part.getCommand((Request)request));
        }
        this.getCommandStack().execute((Command)deletions);
        int size = this.getModelChildren().size();
        if (size == 0) {
            return;
        }
        if (size > index) {
            this.selectEditPart(this.getModelChildren().get(index));
        } else {
            this.selectEditPart(this.getModelChildren().get(size - 1));
        }
    }

    @Override
    protected TrayContainerEditPart.TrayContainerFigure createMainFigure() {
        return new TrayContainerEditPart.TrayContainerFigure(this){

            protected void paintBorder(Graphics graphics) {
                graphics.setForegroundColor(CommonUIPlugin.getDefault().getColorRegistry().get("dark_shadow"));
                Rectangle area = this.getClientArea().getCopy();
                --area.height;
                graphics.drawLine(area.getTopLeft(), area.getTopRight());
            }
        };
    }

    @Override
    protected IFigure createTitleFigure() {
        this.titleFigure = new TitleFigure();
        return this.titleFigure;
    }

    public IFigure getLabelPositionReference() {
        return ((TitleFigure)this.getTitleFigure()).getTextLabel();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new TrayCategoryEntrySelectionEditPolicy());
    }

    protected abstract CreationFactory getCreationFactory();

    @Override
    public DragTracker getDragTracker(Request request) {
        return new SelectEditPartTracker((EditPart)this);
    }

    @Override
    public Label getDirectEditLabel() {
        return null;
    }

    protected IFigure getAddToolTip() {
        return new Label("Add");
    }

    protected IFigure getRemoveToolTip() {
        return new Label("Remove");
    }

    protected class TitleFigure
    extends SelectionBorderFigure {
        protected Label textLabel;
        protected NoBorderButton addButton;
        protected NoBorderButton removeButton;

        public TitleFigure() {
            this.setLayoutManager((LayoutManager)new TitleLayout());
            this.setOpaque(true);
            this.setBackgroundColor(CommonUIPlugin.getDefault().getColorRegistry().get("light_background"));
            this.add((IFigure)new ImageFigure(TrayCategoryEditPart.this.getLabelProvider().getImage(TrayCategoryEditPart.this.getModel())));
            this.textLabel = new Label(TrayCategoryEditPart.this.getLabelProvider().getText(TrayCategoryEditPart.this.getModel()));
            this.textLabel.setLabelAlignment(1);
            this.add((IFigure)this.textLabel);
            this.removeButton = new NoBorderButton(CommonUIPlugin.getDefault().getImageRegistry().get("obj16/remove_exe.gif")){

                public void handleKeyPressed(KeyEvent event) {
                }

                public void handleKeyReleased(KeyEvent event) {
                }
            };
            this.removeButton.setOpaque(false);
            this.removeButton.setToolTip(TrayCategoryEditPart.this.getRemoveToolTip());
            this.removeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    TrayCategoryEditPart.this.removeEntry();
                }
            });
            this.addButton = new NoBorderButton(CommonUIPlugin.getDefault().getImageRegistry().get("obj16/add_exe.gif")){

                public void handleKeyPressed(KeyEvent event) {
                }

                public void handleKeyReleased(KeyEvent event) {
                }
            };
            this.addButton.setOpaque(false);
            this.addButton.setToolTip(TrayCategoryEditPart.this.getAddToolTip());
            this.addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    TrayCategoryEditPart.this.addEntry();
                }
            });
            this.add((IFigure)this.removeButton);
            this.add((IFigure)this.addButton);
        }

        public Label getTextLabel() {
            return this.textLabel;
        }
    }

    protected class TitleLayout
    extends AbstractLayout {
        private static final int SPACING = 2;

        protected TitleLayout() {
        }

        public void layout(IFigure container) {
            List elements = container.getChildren();
            ImageFigure icon = (ImageFigure)elements.get(0);
            Label text = (Label)elements.get(1);
            Figure removeButton = (Figure)elements.get(2);
            Figure addButton = (Figure)elements.get(3);
            Rectangle containerBounds = container.getBounds();
            int x = containerBounds.x + 2;
            int y = containerBounds.y;
            int height = containerBounds.height;
            Dimension size = icon.getPreferredSize();
            Rectangle bounds = new Rectangle(x, y, size.width, height);
            icon.setBounds(bounds);
            size = removeButton.getPreferredSize();
            x = containerBounds.x + containerBounds.width - size.width;
            bounds = new Rectangle(x, y, size.width, height);
            removeButton.setBounds(bounds);
            size = addButton.getPreferredSize();
            bounds = new Rectangle(x -= size.width, y, size.width, height);
            addButton.setBounds(bounds);
            x = icon.getBounds().x + icon.getBounds().width;
            int width = containerBounds.width - (icon.getBounds().width + removeButton.getBounds().width + addButton.getBounds().width);
            bounds = new Rectangle(x += 2, y, width, height);
            text.setBounds(bounds);
        }

        protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
            Dimension result = new Dimension(0, hHint);
            for (IFigure child : container.getChildren()) {
                Dimension size = child instanceof Label ? child.getMinimumSize() : child.getPreferredSize();
                result.height = Math.max(result.height, size.height);
                result.width += size.width;
            }
            result.height += 4;
            return result;
        }
    }

    protected class TrayCategoryEntrySelectionEditPolicy
    extends TraySelectionEditPolicy {
        protected TrayCategoryEntrySelectionEditPolicy() {
        }

        @Override
        protected Handle createHandle(GraphicalEditPart owner) {
            return new TraySelectionHandle(owner, TrayCategoryEditPart.this.titleFigure);
        }
    }
}

