/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.IActionEvaluator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.DialChart;
import org.eclipse.birt.chart.model.IChartObject;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartPreviewPainter;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartPreviewPainter;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataServiceProvider;
import org.eclipse.birt.chart.ui.swt.interfaces.IRegisteredSheetEntry;
import org.eclipse.birt.chart.ui.swt.interfaces.IRegisteredSubtaskEntry;
import org.eclipse.birt.chart.ui.swt.interfaces.ITaskChangeListener;
import org.eclipse.birt.chart.ui.swt.interfaces.ITaskPreviewable;
import org.eclipse.birt.chart.ui.swt.interfaces.IUIManager;
import org.eclipse.birt.chart.ui.swt.type.PieChart;
import org.eclipse.birt.chart.ui.swt.wizard.ChartUIExtensionsImpl;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.DefaultRegisteredSubtaskEntryImpl;
import org.eclipse.birt.chart.ui.swt.wizard.preview.ChartLivePreviewThread;
import org.eclipse.birt.chart.ui.swt.wizard.preview.LivePreviewTask;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.core.ui.frameworks.taskwizard.TreeCompoundTask;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.birt.core.ui.frameworks.taskwizard.composites.NavTree;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.ISubtaskSheet;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.ITask;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.IWizardContext;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;

public class TaskFormatChart
extends TreeCompoundTask
implements IUIManager,
ITaskChangeListener,
ITaskPreviewable {
    protected IChartPreviewPainter previewPainter = null;
    private Canvas previewCanvas;
    private Label lblNodeTitle;
    private Hashtable<String, String[]> htSheetCollections = null;
    protected LinkedHashMap<String, Object> htVisibleSheets = null;
    protected int iBaseSeriesCount = 0;
    protected int iOrthogonalSeriesCount = 0;
    protected int iBaseAxisCount = 0;
    protected int iOrthogonalAxisCount = 0;
    protected int iAncillaryAxisCount = 0;
    protected static final String ORTHOGONAL_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITH_AXES = "OrthogonalSeriesSheetsCWA";
    protected static final String BASE_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITHOUT_AXES = "BaseSeriesSheetsCWOA";
    protected static final String ORTHOGONAL_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITHOUT_AXES = "OrthogonalSeriesSheetsCWOA";
    protected static final String BASE_AXIS_SHEET_COLLECTION = "BaseAxisSheets";
    protected static final String ORTHOGONAL_AXIS_SHEET_COLLECTION = "OrthogonalAxisSheets";
    protected static final String ANCILLARY_AXIS_SHEET_COLLECTION = "AncillaryAxisSheets";
    protected static final String DIAL_SERIES_SHEET_COLLECTION = "NeedleSheets";
    protected Map<String, String[]> subtasksRegistry = new HashMap<String, String[]>(7);
    private IRegisteredSubtaskEntry rootSubtaskEntry = null;
    protected int subtaskHeightHint = 500;
    protected int subtaskWidthHint = -1;

    public TaskFormatChart() {
        super(Messages.getString("TaskFormatChart.TaskExp"), true);
        this.setDescription(Messages.getString("TaskFormatChart.Task.Description"));
        this.registerSubtasks();
    }

    protected void registerSubtasks() {
        this.subtasksRegistry.put(BASE_AXIS_SHEET_COLLECTION, new String[]{"Chart.Axis", "Chart.Axis.X Axis"});
        this.subtasksRegistry.put(ORTHOGONAL_AXIS_SHEET_COLLECTION, new String[]{"Chart.Axis.Y Axis"});
        this.subtasksRegistry.put(ANCILLARY_AXIS_SHEET_COLLECTION, new String[]{"Chart.Axis.Z Axis"});
        this.subtasksRegistry.put(ORTHOGONAL_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITH_AXES, new String[]{"Series.Y Series"});
        this.subtasksRegistry.put(BASE_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITHOUT_AXES, new String[]{"Series.Category Series"});
        this.subtasksRegistry.put(ORTHOGONAL_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITHOUT_AXES, new String[]{"Series.Value Series"});
        this.subtasksRegistry.put(DIAL_SERIES_SHEET_COLLECTION, new String[]{"Series.Value Series.Needle"});
    }

    private Collection<IRegisteredSubtaskEntry> getRegisteredSubtasks() {
        ArrayList<IRegisteredSubtaskEntry> cRegisteredEntries = new ArrayList<IRegisteredSubtaskEntry>();
        Class<?> clazz = ((Object)((Object)this)).getClass();
        if (this.rootSubtaskEntry != null) {
            cRegisteredEntries.add(this.rootSubtaskEntry);
        }
        while (clazz != TreeCompoundTask.class) {
            Collection cSheets = ChartUIExtensionsImpl.instance().getUISheetExtensions(clazz.getSimpleName());
            if (cSheets != null && cSheets.size() > 0) {
                for (IRegisteredSubtaskEntry subtaskEntry : cSheets) {
                    if (this.rootSubtaskEntry != null && clazz.getSimpleName().equals(TaskFormatChart.class.getSimpleName())) {
                        cRegisteredEntries.add((IRegisteredSubtaskEntry)new DefaultRegisteredSubtaskEntryImpl(String.valueOf(subtaskEntry.getNodeIndex()), this.getNodePathWithRoot(subtaskEntry.getNodePath()), subtaskEntry.getDisplayName(), subtaskEntry.getSheet()));
                        continue;
                    }
                    cRegisteredEntries.add(subtaskEntry);
                }
                return cRegisteredEntries;
            }
            clazz = clazz.getSuperclass();
        }
        return cRegisteredEntries;
    }

    private String getNodePathWithRoot(String nodePath) {
        String prefix;
        if (this.rootSubtaskEntry != null && !nodePath.startsWith(prefix = String.valueOf(this.rootSubtaskEntry.getNodePath()) + ".")) {
            return String.valueOf(prefix) + nodePath;
        }
        return nodePath;
    }

    protected void setRootNode(IRegisteredSubtaskEntry rootSubtaskEntry) {
        this.rootSubtaskEntry = rootSubtaskEntry;
    }

    protected void populateSubtasks() {
        super.populateSubtasks();
        this.htVisibleSheets = new LinkedHashMap(12);
        this.htSheetCollections = new Hashtable();
        Iterator<IRegisteredSubtaskEntry> iterEntries = this.getRegisteredSubtasks().iterator();
        Vector<IRegisteredSubtaskEntry> vSortedEntries = new Vector<IRegisteredSubtaskEntry>();
        while (iterEntries.hasNext()) {
            IRegisteredSubtaskEntry entry = iterEntries.next();
            if (vSortedEntries.isEmpty()) {
                vSortedEntries.add(entry);
                continue;
            }
            int iNewIndex = entry.getNodeIndex();
            if (((IRegisteredSubtaskEntry)vSortedEntries.get(vSortedEntries.size() - 1)).getNodeIndex() <= iNewIndex) {
                vSortedEntries.add(entry);
                continue;
            }
            if (((IRegisteredSubtaskEntry)vSortedEntries.get(0)).getNodeIndex() > iNewIndex) {
                vSortedEntries.add(0, entry);
                continue;
            }
            vSortedEntries = this.addEntrySorted(vSortedEntries, entry, 0, vSortedEntries.size() - 1);
        }
        int i = 0;
        while (i < vSortedEntries.size()) {
            IRegisteredSubtaskEntry entry = (IRegisteredSubtaskEntry)vSortedEntries.get(i);
            ISubtaskSheet sheet = entry.getSheet();
            String sNodePath = entry.getNodePath();
            sheet.setParentTask((ITask)this);
            sheet.setNodePath(sNodePath);
            if (this.checkSubtaskVisibility(sheet)) {
                this.htVisibleSheets.put(sNodePath, sheet);
                sheet.setTitle(entry.getDisplayName());
                this.addSubtask(sNodePath, sheet);
            }
            ++i;
        }
        if (this.getCurrentModelState() != null) {
            this.initialize(this.getCurrentModelState());
        }
    }

    protected boolean checkSubtaskVisibility(ISubtaskSheet subtask) {
        return true;
    }

    protected boolean isMultipleValueSeriesAllowed() {
        return true;
    }

    public void updateTreeItem() {
        super.updateTreeItem();
        this.getNavigatorTree().removeAll();
        for (String sKey : this.htVisibleSheets.keySet()) {
            Object oVal = this.htVisibleSheets.get(sKey);
            if (oVal instanceof Vector) {
                Vector vector = (Vector)oVal;
                int i = 0;
                while (i < vector.size()) {
                    String displayName;
                    String sSuffix = "";
                    if (vector.size() > 1) {
                        sSuffix = " - " + String.valueOf(i + 1);
                    }
                    if ((displayName = ((ISubtaskSheet)vector.get(i)).getTitle()) != null && displayName.trim().length() > 0) {
                        this.getNavigatorTree().addNode(String.valueOf(sKey) + sSuffix, String.valueOf(displayName) + sSuffix);
                    } else {
                        this.getNavigatorTree().addNode(String.valueOf(sKey) + sSuffix);
                    }
                    ++i;
                }
                continue;
            }
            this.getNavigatorTree().addNode(sKey, ((ISubtaskSheet)oVal).getTitle());
        }
    }

    private Vector<IRegisteredSubtaskEntry> addEntrySorted(Vector<IRegisteredSubtaskEntry> vSortedEntries, IRegisteredSubtaskEntry entry, int iStart, int iEnd) {
        int iNewIndex = entry.getNodeIndex();
        if (iStart == iEnd) {
            if (((IRegisteredSheetEntry)vSortedEntries.get(iStart)).getNodeIndex() > iNewIndex) {
                vSortedEntries.add(iStart, entry);
            } else {
                vSortedEntries.add(iEnd + 1, entry);
            }
        } else if (iEnd - iStart == 1) {
            vSortedEntries.add(iEnd, entry);
        } else if (vSortedEntries.get(iStart).getNodeIndex() == iNewIndex) {
            vSortedEntries.add(iStart + 1, entry);
        } else {
            int iHalfwayPoint = (iEnd - iStart) / 2;
            if (vSortedEntries.get(iStart + iHalfwayPoint).getNodeIndex() > iNewIndex) {
                this.addEntrySorted(vSortedEntries, entry, iStart, iStart + iHalfwayPoint);
            } else {
                this.addEntrySorted(vSortedEntries, entry, iStart + iHalfwayPoint, iEnd);
            }
        }
        return vSortedEntries;
    }

    public boolean registerSheetCollection(String sCollection, String[] saNodePaths) {
        if (saNodePaths == null) {
            return false;
        }
        try {
            if (this.rootSubtaskEntry != null) {
                String[] newNodePaths = new String[saNodePaths.length];
                int i = 0;
                while (i < saNodePaths.length) {
                    newNodePaths[i] = this.getNodePathWithRoot(saNodePaths[i]);
                    ++i;
                }
                this.htSheetCollections.put(sCollection, newNodePaths);
            } else {
                this.htSheetCollections.put(sCollection, saNodePaths);
            }
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    protected boolean registerSheetCollection(String sCollection) {
        return this.registerSheetCollection(sCollection, this.subtasksRegistry.get(sCollection));
    }

    public String[] getRegisteredCollectionValue(String sCollection) {
        return this.htSheetCollections.get(sCollection);
    }

    public boolean addCollectionInstance(String sCollection) {
        if (!this.htSheetCollections.containsKey(sCollection)) {
            return false;
        }
        String[] saNodes = this.htSheetCollections.get(sCollection);
        int iN = 0;
        while (iN < saNodes.length) {
            this.addVisibleSubtask(saNodes[iN]);
            ++iN;
        }
        return true;
    }

    private void addVisibleSubtask(String sNodeName) {
        Vector vSheets = new Vector();
        if (this.htVisibleSheets.containsKey(sNodeName)) {
            Object oSheets = this.htVisibleSheets.get(sNodeName);
            if (oSheets instanceof Vector) {
                vSheets = (Vector)oSheets;
            } else if (oSheets instanceof ISubtaskSheet) {
                vSheets.add((ISubtaskSheet)oSheets);
            } else {
                return;
            }
            vSheets.add(this.getSubtask(sNodeName));
            this.htVisibleSheets.put(sNodeName, vSheets);
        } else if (this.containSubtask(sNodeName)) {
            vSheets.add(this.getSubtask(sNodeName));
            this.htVisibleSheets.put(sNodeName, vSheets);
        }
    }

    private void removeVisibleTask(String sNodeName) {
        Vector vSheets = new Vector();
        if (this.htVisibleSheets.containsKey(sNodeName)) {
            Object oSheets = this.htVisibleSheets.get(sNodeName);
            if (oSheets instanceof Vector) {
                vSheets = (Vector)oSheets;
            } else if (oSheets instanceof ISubtaskSheet) {
                vSheets.add((ISubtaskSheet)oSheets);
            } else {
                return;
            }
            int iLast = vSheets.lastIndexOf(this.getSubtask(sNodeName));
            vSheets.remove(iLast);
            this.htVisibleSheets.put(sNodeName, vSheets);
        } else if (this.containSubtask(sNodeName)) {
            int iLast = vSheets.lastIndexOf(this.getSubtask(sNodeName));
            vSheets.remove(iLast);
            this.htVisibleSheets.put(sNodeName, vSheets);
        }
    }

    public boolean removeCollectionInstance(String sCollection) {
        if (!this.htSheetCollections.containsKey(sCollection)) {
            return false;
        }
        String[] saNodes = this.htSheetCollections.get(sCollection);
        int iN = 0;
        while (iN < saNodes.length) {
            this.removeVisibleTask(saNodes[iN]);
            ++iN;
        }
        return true;
    }

    public Chart getCurrentModelState() {
        if (this.getContext() == null) {
            return null;
        }
        return ((ChartWizardContext)this.getContext()).getModel();
    }

    public void createControl(Composite parent) {
        this.initControl(parent);
        if (this.previewPainter == null) {
            this.previewPainter = this.createPreviewPainter();
        }
        if (!this.isSutaskPreviewable(this.getCurrentSubtask())) {
            this.doPreview();
        }
    }

    private void initDetailHeader(Composite parent) {
        this.lblNodeTitle = new Label(parent, 0);
        GridData gd = new GridData(768);
        this.lblNodeTitle.setLayoutData((Object)gd);
        this.lblNodeTitle.setFont(JFaceResources.getBannerFont());
        Label separator = new Label(parent, 258);
        GridData gd2 = new GridData(768);
        separator.setLayoutData((Object)gd2);
    }

    private void initControl(Composite parent) {
        ChartUIUtil.populateTypeTable((IWizardContext)this.getContext());
        if (this.topControl == null || this.topControl.isDisposed()) {
            this.topControl = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.horizontalSpacing = 0;
            this.topControl.setLayout((Layout)layout);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 4;
            this.topControl.setLayoutData((Object)gridData);
            this.navTree = new NavTree(this.topControl, 2048);
            GridData gridData2 = new GridData(1296);
            gridData2.widthHint = 127;
            this.navTree.setLayoutData((Object)gridData2);
            this.navTree.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    TaskFormatChart.this.switchToTreeItem((TreeItem)event.item);
                }
            });
            SashForm foRightSashForm = new SashForm(this.topControl, 512){

                public Control[] getChildren() {
                    Control[] children = super.getChildren();
                    ArrayList<Control> visibleChildren = new ArrayList<Control>();
                    Control[] controlArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control child = controlArray[n2];
                        if (child.isVisible()) {
                            visibleChildren.add(child);
                        }
                        ++n2;
                    }
                    if (visibleChildren.size() == 0 || visibleChildren.size() == children.length) {
                        return children;
                    }
                    return visibleChildren.toArray(new Control[visibleChildren.size()]);
                }
            };
            foRightSashForm.SASH_WIDTH = 1;
            foRightSashForm.setBackground(parent.getDisplay().getSystemColor(16));
            GridLayout layout2 = new GridLayout();
            foRightSashForm.setLayout((Layout)layout2);
            GridData gridData3 = new GridData(1808);
            gridData3.heightHint = this.subtaskHeightHint;
            gridData3.widthHint = this.subtaskWidthHint;
            foRightSashForm.setLayoutData((Object)gridData3);
            this.createContainer((Composite)foRightSashForm);
            this.createDetailComposite((Composite)foRightSashForm);
        }
        this.updateTree();
        this.switchToDefaultItem();
    }

    private void createDetailComposite(Composite parent) {
        Composite detailComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        detailComposite.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        detailComposite.setLayoutData((Object)gridData);
        this.initDetailHeader(detailComposite);
        this.createSubDetailComposite(detailComposite, !this.isSutaskPreviewable(this.getCurrentSubtask()));
    }

    private void createSubDetailComposite(Composite detailComposite, boolean bScrolled) {
        if (!bScrolled) {
            this.cmpSubtaskContainer = new Composite(detailComposite, 0);
            GridLayout layout = new GridLayout();
            this.cmpSubtaskContainer.setLayout((Layout)layout);
            GridData gridData = new GridData(1808);
            this.cmpSubtaskContainer.setLayoutData((Object)gridData);
        } else {
            ScrolledComposite foScrolledDetailComposite = new ScrolledComposite(detailComposite, 768);
            GridLayout layout = new GridLayout();
            foScrolledDetailComposite.setLayout((Layout)layout);
            GridData gridData = new GridData(1808);
            foScrolledDetailComposite.setLayoutData((Object)gridData);
            foScrolledDetailComposite.setExpandHorizontal(true);
            foScrolledDetailComposite.setExpandVertical(true);
            this.cmpSubtaskContainer = new Composite((Composite)foScrolledDetailComposite, 0);
            layout = new GridLayout();
            this.cmpSubtaskContainer.setLayout((Layout)layout);
            gridData = new GridData(1808);
            this.cmpSubtaskContainer.setLayoutData((Object)gridData);
            foScrolledDetailComposite.setContent((Control)this.cmpSubtaskContainer);
        }
    }

    protected void switchTo(String sSubtaskPath, boolean needSelection) {
        boolean bPreviewableNew;
        boolean bPreviewableOld = this.isSutaskPreviewable(this.getCurrentSubtask());
        if (bPreviewableOld != (bPreviewableNew = this.isSutaskPreviewable(this.getSubtask(sSubtaskPath)))) {
            Composite cmpParent = this.cmpSubtaskContainer.getParent();
            this.previewCanvas.getParent().getParent().setVisible(!bPreviewableNew);
            this.previewCanvas.getParent().getParent().getParent().layout();
            if (!bPreviewableNew) {
                this.doPreview();
                this.cmpSubtaskContainer.dispose();
            } else {
                cmpParent = cmpParent.getParent();
                this.cmpSubtaskContainer.getParent().dispose();
            }
            this.createSubDetailComposite(cmpParent, !bPreviewableNew);
        }
        super.switchTo(sSubtaskPath, needSelection);
        if (!bPreviewableNew) {
            Point childSize = this.cmpSubtaskContainer.computeSize(-1, -1);
            ((ScrolledComposite)this.cmpSubtaskContainer.getParent()).setMinSize(childSize);
        }
        this.cmpSubtaskContainer.getParent().getParent().layout();
        this.cmpSubtaskContainer.getParent().layout();
    }

    protected Composite createTitleArea(Composite parent) {
        Composite cmpTitle = super.createTitleArea(parent);
        this.previewCanvas = new Canvas(cmpTitle, 2048);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.previewCanvas.setLayoutData((Object)gd);
        this.previewCanvas.setBackground(Display.getDefault().getSystemColor(22));
        return cmpTitle;
    }

    protected String getTitleAreaString() {
        return Messages.getString("TaskFormatChart.Label.Preview");
    }

    protected void createSubtaskArea(Composite parent, ISubtaskSheet subtask) {
        if (this.getNavigatorTree().getSelection().length > 0) {
            this.lblNodeTitle.setText(this.getNavigatorTree().getSelection()[0].getText());
        }
        super.createSubtaskArea(parent, subtask);
        boolean bEnabled = ((ChartWizardContext)this.getContext()).isEnabled(subtask.getNodePath());
        if (!bEnabled) {
            this.disableControl((Control)parent);
        }
        parent.setEnabled(bEnabled);
        this.lblNodeTitle.setEnabled(bEnabled);
    }

    private void disableControl(Control control) {
        if (control instanceof Composite) {
            Control[] children = ((Composite)control).getChildren();
            int i = 0;
            while (i < children.length) {
                this.disableControl(children[i]);
                ++i;
            }
        }
        control.setEnabled(false);
    }

    public IChartPreviewPainter createPreviewPainter() {
        ChartPreviewPainter painter = new ChartPreviewPainter((ChartWizardContext)this.getContext());
        this.getPreviewCanvas().addPaintListener((PaintListener)painter);
        this.getPreviewCanvas().addControlListener((ControlListener)painter);
        painter.setPreview(this.getPreviewCanvas());
        return painter;
    }

    public void changeTask(Notification notification) {
        if (this.isSutaskPreviewable(this.getCurrentSubtask())) {
            if (this.getCurrentSubtask() instanceof ITaskChangeListener) {
                ((ITaskChangeListener)this.getCurrentSubtask()).changeTask(notification);
            }
        } else if (this.previewPainter != null) {
            this.doPreview();
        }
    }

    protected IDataServiceProvider getDataServiceProvider() {
        return ((ChartWizardContext)this.getContext()).getDataServiceProvider();
    }

    protected void initialize(Chart chartModel) {
        this.registerSheetCollection(ORTHOGONAL_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITH_AXES);
        this.registerSheetCollection(BASE_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITHOUT_AXES);
        this.registerSheetCollection(ORTHOGONAL_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITHOUT_AXES);
        this.registerSheetCollection(BASE_AXIS_SHEET_COLLECTION);
        this.registerSheetCollection(ORTHOGONAL_AXIS_SHEET_COLLECTION);
        this.registerSheetCollection(ANCILLARY_AXIS_SHEET_COLLECTION);
        this.registerSheetCollection(DIAL_SERIES_SHEET_COLLECTION);
        if (chartModel instanceof ChartWithAxes) {
            this.iBaseAxisCount = ((ChartWithAxes)chartModel).getAxes().size();
            this.iOrthogonalAxisCount = 0;
            this.iAncillaryAxisCount = 0;
            this.iOrthogonalSeriesCount = 0;
            int i = 0;
            while (i < this.iBaseAxisCount) {
                this.iOrthogonalAxisCount += ((Axis)((ChartWithAxes)chartModel).getAxes().get(i)).getAssociatedAxes().size();
                if (chartModel.getDimension().getValue() == 2) {
                    this.iAncillaryAxisCount += ((Axis)((ChartWithAxes)chartModel).getAxes().get(i)).getAncillaryAxes().size();
                }
                if (this.isMultipleValueSeriesAllowed()) {
                    int iS = 0;
                    while (iS < this.iOrthogonalAxisCount) {
                        this.iOrthogonalSeriesCount += ((Axis)((Axis)((ChartWithAxes)chartModel).getAxes().get(i)).getAssociatedAxes().get(iS)).getSeriesDefinitions().size();
                        ++iS;
                    }
                } else {
                    this.iOrthogonalSeriesCount = 1;
                }
                ++i;
            }
            int iBA = 1;
            while (iBA < this.iBaseAxisCount) {
                this.addCollectionInstance(BASE_AXIS_SHEET_COLLECTION);
                ++iBA;
            }
            int iOA = 1;
            while (iOA < this.iOrthogonalAxisCount) {
                this.addCollectionInstance(ORTHOGONAL_AXIS_SHEET_COLLECTION);
                ++iOA;
            }
            this.removeCollectionInstance(ANCILLARY_AXIS_SHEET_COLLECTION);
            iOA = 0;
            while (iOA < this.iAncillaryAxisCount) {
                this.addCollectionInstance(ANCILLARY_AXIS_SHEET_COLLECTION);
                ++iOA;
            }
            this.removeCollectionInstance(BASE_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITHOUT_AXES);
            this.removeCollectionInstance(ORTHOGONAL_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITHOUT_AXES);
            this.removeCollectionInstance(DIAL_SERIES_SHEET_COLLECTION);
            int iOS = 1;
            while (iOS < this.iOrthogonalSeriesCount) {
                this.addCollectionInstance(ORTHOGONAL_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITH_AXES);
                ++iOS;
            }
        } else {
            int iOS;
            this.iBaseAxisCount = 0;
            this.iOrthogonalAxisCount = 0;
            this.iBaseSeriesCount = ((ChartWithoutAxes)chartModel).getSeriesDefinitions().size();
            if (this.isMultipleValueSeriesAllowed()) {
                this.iOrthogonalSeriesCount = 0;
                int iS = 0;
                while (iS < this.iBaseSeriesCount) {
                    this.iOrthogonalSeriesCount += ((SeriesDefinition)((ChartWithoutAxes)chartModel).getSeriesDefinitions().get(iS)).getSeriesDefinitions().size();
                    ++iS;
                }
            } else {
                this.iOrthogonalSeriesCount = 1;
            }
            this.removeCollectionInstance(ANCILLARY_AXIS_SHEET_COLLECTION);
            this.removeCollectionInstance(ORTHOGONAL_AXIS_SHEET_COLLECTION);
            this.removeCollectionInstance(BASE_AXIS_SHEET_COLLECTION);
            this.removeCollectionInstance(ORTHOGONAL_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITH_AXES);
            this.removeCollectionInstance(BASE_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITHOUT_AXES);
            this.removeCollectionInstance(DIAL_SERIES_SHEET_COLLECTION);
            if (chartModel instanceof DialChart) {
                if (!((DialChart)chartModel).isDialSuperimposition()) {
                    iOS = 1;
                    while (iOS < this.iOrthogonalSeriesCount) {
                        this.addCollectionInstance(ORTHOGONAL_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITHOUT_AXES);
                        ++iOS;
                    }
                } else {
                    iOS = 0;
                    while (iOS < this.iOrthogonalSeriesCount) {
                        this.addCollectionInstance(DIAL_SERIES_SHEET_COLLECTION);
                        ++iOS;
                    }
                }
            } else {
                if (((ChartWizardContext)this.getContext()).getChartType() instanceof PieChart) {
                    int iBS = 0;
                    while (iBS < this.iBaseSeriesCount) {
                        this.addCollectionInstance(BASE_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITHOUT_AXES);
                        ++iBS;
                    }
                }
                iOS = 1;
                while (iOS < this.iOrthogonalSeriesCount) {
                    this.addCollectionInstance(ORTHOGONAL_SERIES_SHEET_COLLECTION_FOR_CHARTS_WITHOUT_AXES);
                    ++iOS;
                }
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.htVisibleSheets != null) {
            this.htVisibleSheets.clear();
        }
        if (this.htSheetCollections != null) {
            this.htSheetCollections.clear();
        }
        this.previewCanvas = null;
        if (this.previewPainter != null) {
            this.previewPainter.dispose();
        }
        this.previewPainter = null;
    }

    public Image getImage() {
        return UIHelper.getImage((String)"icons/obj16/selectformat.gif");
    }

    protected boolean isSutaskPreviewable(ISubtaskSheet subtask) {
        return subtask instanceof ITaskPreviewable && ((ITaskPreviewable)subtask).isPreviewable();
    }

    protected Chart getPreviewChartModel() throws ChartException {
        return this.getCurrentModelState();
    }

    public void doPreview() {
        try {
            final Chart chart = this.getPreviewChartModel();
            LivePreviewTask lpt = new LivePreviewTask(Messages.getString("TaskFormatChart.LivePreviewTask.BindData"), null);
            lpt.addTask(new LivePreviewTask(){

                @Override
                public void run() {
                    if (TaskFormatChart.this.previewPainter != null) {
                        this.setParameter("Chart Model", ChartUIUtil.prepareLivePreview((Chart)chart, (IDataServiceProvider)TaskFormatChart.this.getDataServiceProvider(), (IActionEvaluator)((ChartWizardContext)TaskFormatChart.this.context).getActionEvaluator()));
                    }
                }
            });
            lpt.addTask(new LivePreviewTask(){

                @Override
                public void run() {
                    if (TaskFormatChart.this.previewCanvas != null && TaskFormatChart.this.previewCanvas.getDisplay() != null && !TaskFormatChart.this.previewCanvas.getDisplay().isDisposed()) {
                        TaskFormatChart.this.previewCanvas.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if ((this).TaskFormatChart.this.previewPainter != null) {
                                    (this).TaskFormatChart.this.previewPainter.renderModel((IChartObject)this.getParameter("Chart Model"));
                                }
                            }
                        });
                    }
                }
            });
            ((ChartLivePreviewThread)((ChartWizardContext)this.context).getLivePreviewThread()).setParentShell(this.getPreviewCanvas().getShell());
            ((ChartLivePreviewThread)((ChartWizardContext)this.context).getLivePreviewThread()).add(lpt);
        }
        catch (ChartException e) {
            WizardBase.showException((String)e.getMessage());
        }
    }

    public Canvas getPreviewCanvas() {
        return this.previewCanvas;
    }

    public boolean isPreviewable() {
        return true;
    }
}

