/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.schema.sql;

import com.google.gwtorm.client.OrmDuplicateKeyException;
import com.google.gwtorm.client.OrmException;
import com.google.gwtorm.client.StatementExecutor;
import com.google.gwtorm.schema.ColumnModel;
import com.google.gwtorm.schema.RelationModel;
import com.google.gwtorm.schema.sql.SqlDialect;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;

public class DialectPostgreSQL
extends SqlDialect {
    public DialectPostgreSQL() {
        this.typeNames.put(-3, "BYTEA");
        this.typeNames.put(93, "TIMESTAMP WITH TIME ZONE");
    }

    @Override
    public SqlDialect refine(Connection c) throws SQLException {
        int major = c.getMetaData().getDatabaseMajorVersion();
        int minor = c.getMetaData().getDatabaseMinorVersion();
        if (major < 8 || major == 8 && minor < 2) {
            return new Pre82();
        }
        return this;
    }

    @Override
    public OrmException convertError(String op, String entity, SQLException err) {
        switch (DialectPostgreSQL.getSQLStateInt(err)) {
            case 23505: {
                return new OrmDuplicateKeyException(entity, err);
            }
        }
        return super.convertError(op, entity, err);
    }

    @Override
    public String getNextSequenceValueSql(String seqname) {
        return "SELECT nextval('" + seqname + "')";
    }

    @Override
    public void appendCreateTableStorage(StringBuilder sqlBuffer, RelationModel relationModel) {
        sqlBuffer.append("WITH (OIDS = FALSE)");
    }

    @Override
    public void renameColumn(StatementExecutor stmt, String tableName, String fromColumn, ColumnModel col) throws OrmException {
        StringBuilder r = new StringBuilder();
        r.append("ALTER TABLE ");
        r.append(tableName);
        r.append(" RENAME COLUMN ");
        r.append(fromColumn);
        r.append(" TO ");
        r.append(col.getColumnName());
        stmt.execute(r.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> listSequences(Connection db) throws SQLException {
        Statement s = db.createStatement();
        try {
            HashSet<String> hashSet;
            ResultSet rs = s.executeQuery("SELECT relname FROM pg_class WHERE relkind = 'S'");
            try {
                HashSet<String> sequences = new HashSet<String>();
                while (rs.next()) {
                    sequences.add(rs.getString(1).toLowerCase());
                }
                hashSet = sequences;
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return hashSet;
        }
        finally {
            s.close();
        }
    }

    private static class Pre82
    extends DialectPostgreSQL {
        private Pre82() {
        }

        @Override
        public void appendCreateTableStorage(StringBuilder sqlBuffer, RelationModel relationModel) {
            sqlBuffer.append("WITHOUT OIDS");
        }
    }
}

