/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb;

import com.google.gerrit.reviewdb.Account;
import com.google.gerrit.reviewdb.Branch;
import com.google.gerrit.reviewdb.PatchSet;
import com.google.gerrit.reviewdb.PatchSetInfo;
import com.google.gerrit.reviewdb.Project;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.IntKey;
import com.google.gwtorm.client.RowVersion;
import com.google.gwtorm.client.StringKey;
import java.sql.Timestamp;

public final class Change {
    private static final char MIN_OPEN = 'a';
    protected static final char STATUS_NEW = 'n';
    protected static final char STATUS_SUBMITTED = 's';
    private static final char MAX_OPEN = 'z';
    protected static final char STATUS_MERGED = 'M';
    @Column(id=1)
    protected Id changeId;
    @Column(id=2)
    protected Key changeKey;
    @Column(id=3)
    @RowVersion
    protected int rowVersion;
    @Column(id=4)
    protected Timestamp createdOn;
    @Column(id=5)
    protected Timestamp lastUpdatedOn;
    @Column(id=6, length=16)
    protected String sortKey;
    @Column(id=7, name="owner_account_id")
    protected Account.Id owner;
    @Column(id=8)
    protected Branch.NameKey dest;
    @Column(id=9)
    protected boolean open;
    @Column(id=10)
    protected char status;
    @Column(id=11)
    protected int nbrPatchSets;
    @Column(id=12)
    protected int currentPatchSetId;
    @Column(id=13)
    protected String subject;
    @Column(id=14, notNull=false)
    protected String topic;

    protected Change() {
    }

    public Change(Key newKey, Id newId, Account.Id ownedBy, Branch.NameKey forBranch) {
        this.changeKey = newKey;
        this.changeId = newId;
        this.lastUpdatedOn = this.createdOn = new Timestamp(System.currentTimeMillis());
        this.owner = ownedBy;
        this.dest = forBranch;
        this.setStatus(Status.NEW);
    }

    @Deprecated
    public Id getId() {
        return this.changeId;
    }

    @Deprecated
    public int getChangeId() {
        return this.changeId.get();
    }

    public Key getKey() {
        return this.changeKey;
    }

    public void setKey(Key k) {
        this.changeKey = k;
    }

    public Timestamp getCreatedOn() {
        return this.createdOn;
    }

    public Timestamp getLastUpdatedOn() {
        return this.lastUpdatedOn;
    }

    public void resetLastUpdatedOn() {
        this.lastUpdatedOn = new Timestamp(System.currentTimeMillis());
    }

    public String getSortKey() {
        return this.sortKey;
    }

    public void setSortKey(String newSortKey) {
        this.sortKey = newSortKey;
    }

    public Account.Id getOwner() {
        return this.owner;
    }

    public Branch.NameKey getDest() {
        return this.dest;
    }

    public Project.NameKey getProject() {
        return this.dest.getParentKey();
    }

    public String getSubject() {
        return this.subject;
    }

    public PatchSet.Id currentPatchSetId() {
        if (this.currentPatchSetId > 0) {
            return new PatchSet.Id(this.changeId, this.currentPatchSetId);
        }
        return null;
    }

    public void setCurrentPatchSet(PatchSetInfo ps) {
        this.currentPatchSetId = ps.getKey().get();
        this.subject = ps.getSubject();
    }

    public void nextPatchSetId() {
        ++this.nbrPatchSets;
    }

    public PatchSet.Id currPatchSetId() {
        return new PatchSet.Id(this.changeId, this.nbrPatchSets);
    }

    public Status getStatus() {
        return Status.forCode(this.status);
    }

    public void setStatus(Status newStatus) {
        this.open = newStatus.isOpen();
        this.status = newStatus.getCode();
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public static class Id
    extends IntKey<com.google.gwtorm.client.Key<?>> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected int id;

        protected Id() {
        }

        public Id(int id) {
            this.id = id;
        }

        public int get() {
            return this.id;
        }

        protected void set(int newValue) {
            this.id = newValue;
        }

        public static Id parse(String str) {
            Id r = new Id();
            r.fromString(str);
            return r;
        }

        public static Id fromRef(String ref) {
            return PatchSet.Id.fromRef(ref).getParentKey();
        }
    }

    public static class Key
    extends StringKey<com.google.gwtorm.client.Key<?>> {
        private static final long serialVersionUID = 1L;
        @Column(id=1, length=60)
        protected String id;

        protected Key() {
        }

        public Key(String id) {
            this.id = id;
        }

        public String get() {
            return this.id;
        }

        protected void set(String newValue) {
            this.id = newValue;
        }

        public Key max() {
            StringBuilder revEnd = new StringBuilder(this.get().length() + 1);
            revEnd.append(this.get());
            revEnd.append('\u9fa5');
            return new Key(revEnd.toString());
        }

        public String abbreviate() {
            String s = this.get();
            return s.substring(0, Math.min(s.length(), 9));
        }

        public static Key parse(String str) {
            Key r = new Key();
            r.fromString(str);
            return r;
        }
    }

    public static enum Status {
        NEW('n'),
        SUBMITTED('s'),
        MERGED('M'),
        ABANDONED('A');

        private final char code;
        private final boolean closed;

        private Status(char c) {
            this.code = c;
            this.closed = 'a' > c || c > 'z';
        }

        public char getCode() {
            return this.code;
        }

        public boolean isOpen() {
            return !this.closed;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public static Status forCode(char c) {
            for (Status s : Status.values()) {
                if (s.code != c) continue;
                return s;
            }
            return null;
        }
    }
}

