/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.property.editor.image.plugin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.model.IHasChildren;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.model.IImageElement;
import org.eclipse.wb.internal.swt.model.property.editor.image.plugin.BundleImageResource;
import org.eclipse.wb.internal.swt.model.property.editor.image.plugin.ImageContainer;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleImageContainer
extends ImageContainer
implements IHasChildren {
    private static final String[] PATTERNS = new String[]{".gif", ".png", ".jpg", ".jpeg", ".bmp", ".ico"};
    private final String m_name;
    private final Bundle m_bundle;
    private final String m_symbolicName;
    private final String m_path;
    private IImageElement[] m_resources;
    private boolean m_calculateHasChildren = true;
    private boolean m_hasChildren;

    public BundleImageContainer(String name, Bundle bundle, String symbolicName, String path) {
        this.m_name = name;
        this.m_bundle = bundle;
        this.m_symbolicName = symbolicName;
        this.m_path = path;
    }

    private void ensureResources() {
        if (this.m_resources == null) {
            Enumeration entryPaths = this.m_bundle.getEntryPaths(this.m_path);
            ArrayList resources = Lists.newArrayList();
            block0: while (entryPaths.hasMoreElements()) {
                String entry = (String)entryPaths.nextElement();
                if (entry.endsWith("/")) {
                    if (!BundleImageContainer.isContainsResources(this.m_bundle, entry)) continue;
                    String entryName = entry.substring(0, entry.length() - 1);
                    int lastSlashIndex = entryName.lastIndexOf(47);
                    if (lastSlashIndex != -1) {
                        entryName = entryName.substring(lastSlashIndex + 1);
                    }
                    resources.add(new BundleImageContainer(entryName, this.m_bundle, this.m_symbolicName, entry));
                    continue;
                }
                int i = 0;
                while (i < PATTERNS.length) {
                    if (entry.endsWith(PATTERNS[i])) {
                        resources.add(new BundleImageResource(this.m_bundle.getEntry(entry), this.m_symbolicName));
                        continue block0;
                    }
                    ++i;
                }
            }
            this.m_resources = resources.toArray(new IImageElement[resources.size()]);
        }
    }

    private static boolean isContainsResources(Bundle bundle, String path) {
        Enumeration entryPaths = bundle.getEntryPaths(path);
        ArrayList<String> folders = new ArrayList<String>();
        while (entryPaths.hasMoreElements()) {
            String entry = (String)entryPaths.nextElement();
            if (entry.endsWith("/")) {
                folders.add(entry);
                continue;
            }
            int i = 0;
            while (i < PATTERNS.length) {
                if (entry.endsWith(PATTERNS[i])) {
                    return true;
                }
                ++i;
            }
        }
        for (String entry : folders) {
            if (!BundleImageContainer.isContainsResources(bundle, entry)) continue;
            return true;
        }
        return false;
    }

    public boolean hasChildren() {
        try {
            if (this.m_calculateHasChildren) {
                this.m_calculateHasChildren = false;
                this.m_hasChildren = BundleImageContainer.isContainsResources(this.m_bundle, this.m_path);
            }
            return this.m_hasChildren;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public IImageElement[] elements() {
        this.ensureResources();
        return this.m_resources;
    }

    @Override
    protected IImageElement[] directElements() {
        return this.m_resources;
    }

    public Image getImage() {
        return DesignerPlugin.getImage((String)"folder_open.gif");
    }

    public String getName() {
        return this.m_name;
    }

    protected final boolean findResource(List<Object> paths, String imagePath) {
        paths.add(this);
        IImageElement[] iImageElementArray = this.elements();
        int n = iImageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            BundleImageResource resource;
            IImageElement element = iImageElementArray[n2];
            if (element instanceof BundleImageContainer) {
                BundleImageContainer container = (BundleImageContainer)element;
                if (container.findResource(paths, imagePath)) {
                    return true;
                }
            } else if (element instanceof BundleImageResource && (resource = (BundleImageResource)element).getPath().equals(imagePath)) {
                paths.add(resource);
                return true;
            }
            ++n2;
        }
        paths.remove(this);
        return false;
    }

    @Override
    public Object[] findResource(String symbolicName, String imagePath) {
        return null;
    }
}

