/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.resource;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.sdk.s2e.nls.resource.ITranslationResource;

public class TranslationResourceEvent {
    public static final int TYPE_ENTRY_ADD = 1;
    public static final int TYPE_ENTRY_REMOVE = 2;
    public static final int TYPE_ENTRY_MODIFY = 4;
    public static final int TYPE_ENTRY_REMOVED = 1024;
    private List<TranslationResourceEvent> m_subEvents;
    private int m_type;
    private String m_translation;
    private String m_key;
    private final ITranslationResource m_source;

    public TranslationResourceEvent(ITranslationResource source) {
        this.m_source = source;
        this.m_subEvents = new ArrayList<TranslationResourceEvent>();
    }

    public TranslationResourceEvent(ITranslationResource source, int type) {
        this.m_source = source;
        this.m_type = type;
    }

    public TranslationResourceEvent(ITranslationResource source, String key, String translation, int type) {
        this.m_source = source;
        this.m_key = key;
        this.m_translation = translation;
        this.m_type = type;
    }

    public ITranslationResource getSource() {
        return this.m_source;
    }

    public boolean isMulti() {
        return this.m_subEvents != null;
    }

    public void addEvent(TranslationResourceEvent event) {
        this.m_subEvents.add(event);
    }

    public boolean removeEvent(TranslationResourceEvent event) {
        return this.m_subEvents.remove(event);
    }

    public TranslationResourceEvent[] getSubEvents() {
        if (this.m_subEvents == null) {
            return new TranslationResourceEvent[0];
        }
        return this.m_subEvents.toArray(new TranslationResourceEvent[this.m_subEvents.size()]);
    }

    public int getType() {
        return this.m_type;
    }

    public String getTranslation() {
        return this.m_translation;
    }

    public String getKey() {
        return this.m_key;
    }
}

