/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.ui.views.contentoutline;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.matcher.RegexMatcher;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.matcher.WithTooltipTextMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.swt.api.Tree;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.condition.TreeHasChildren;
import org.eclipse.reddeer.swt.impl.toolbar.DefaultToolItem;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;
import org.eclipse.reddeer.workbench.impl.view.WorkbenchView;
import org.hamcrest.Matcher;

public class ContentOutline
extends WorkbenchView {
    public ContentOutline() {
        super("Outline");
    }

    public Collection<TreeItem> outlineElements() {
        this.activate();
        return this.getTreeForView();
    }

    public void collapseAll() {
        this.activate();
        this.clickOnToolTip("Collapse All.*");
    }

    public void sort() {
        this.activate();
        this.clickOnToolTip("Sort.*");
    }

    public void hideFields() {
        this.activate();
        this.clickOnToolTip("Hide Fields.*");
    }

    public void hideStaticFieldsAndMethods() {
        this.activate();
        this.clickOnToolTip("Hide Static Fields and Methods.*");
    }

    public void hideNonPublicMembers() {
        this.activate();
        this.clickOnToolTip("Hide Non-Public Members.*");
    }

    public void hideLocalTypes() {
        this.activate();
        this.clickOnToolTip("Hide Local Types.*");
    }

    public void linkWithEditor() {
        this.activate();
        this.clickOnToolTip("Link with Editor.*");
    }

    private Collection<TreeItem> getTreeForView() {
        try {
            DefaultTree tree = new DefaultTree((ReferencedComposite)this.cTabItem);
            new WaitUntil((WaitCondition)new TreeHasChildren((Tree)tree), TimePeriod.DEFAULT, false);
            return tree.getItems();
        }
        catch (CoreLayerException coreLayerException) {
            return new ArrayList<TreeItem>();
        }
    }

    private void clickOnToolTip(String regex) {
        WithTooltipTextMatcher rm = new WithTooltipTextMatcher((Matcher)new RegexMatcher(regex));
        new DefaultToolItem((ReferencedComposite)this.cTabItem.getFolder(), (Matcher)rm).click();
    }
}

