/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.pdi.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ptp.debug.core.pdi.IPDILocator;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIRegisterManager;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIVariableManager;
import org.eclipse.ptp.debug.core.pdi.model.IPDIStackFrame;
import org.eclipse.ptp.debug.core.pdi.model.IPDIStackFrameDescriptor;
import org.eclipse.ptp.debug.core.pdi.model.IPDITarget;
import org.eclipse.ptp.debug.core.pdi.model.IPDIThread;
import org.eclipse.ptp.debug.core.pdi.model.IPDIThreadStorage;
import org.eclipse.ptp.debug.core.pdi.model.IPDIThreadStorageDescriptor;
import org.eclipse.ptp.debug.core.pdi.request.IPDIGetStackInfoDepthRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIListStackFramesRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDISetCurrentStackFrameRequest;
import org.eclipse.ptp.internal.debug.core.pdi.SessionObject;
import org.eclipse.ptp.internal.debug.core.pdi.model.StackFrame;
import org.eclipse.ptp.internal.debug.core.pdi.model.Target;
import org.eclipse.ptp.internal.debug.core.pdi.model.ThreadStorageDescriptor;

public class Thread
extends SessionObject
implements IPDIThread {
    private static IPDIStackFrame[] noStack = new IPDIStackFrame[0];
    private int id;
    private String name;
    private IPDIStackFrame currentFrame = null;
    private List<IPDIStackFrame> currentFrames = null;
    private int stackdepth = 0;
    private IPDITarget target = null;

    public Thread(IPDISession session, IPDITarget target, int threadId) {
        this(session, target, threadId, null);
    }

    public Thread(IPDISession session, IPDITarget target, int threadId, String threadName) {
        super(session, target.getTasks());
        this.id = threadId;
        this.name = threadName;
        this.target = target;
    }

    public void clearState() {
        this.stackdepth = 0;
        this.currentFrame = null;
        this.currentFrames = null;
    }

    @Override
    public IPDIThreadStorage createThreadStorage(IPDIThreadStorageDescriptor varDesc) throws PDIException {
        if (varDesc instanceof ThreadStorageDescriptor) {
            IPDIVariableManager varMgr = this.session.getVariableManager();
            return varMgr.createThreadStorage((ThreadStorageDescriptor)varDesc);
        }
        return null;
    }

    @Override
    public boolean equals(IPDIThread thread) {
        if (thread instanceof Thread) {
            Thread pthread = (Thread)thread;
            return this.id == pthread.getId();
        }
        return super.equals(thread);
    }

    @Override
    public IPDIStackFrame getCurrentStackFrame() throws PDIException {
        IPDIStackFrame[] frames;
        if (this.currentFrame == null && (frames = this.getStackFrames(0, 0)).length > 0) {
            this.currentFrame = (StackFrame)frames[0];
        }
        return this.currentFrame;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getStackFrameCount() throws PDIException {
        if (this.stackdepth == 0) {
            Target target = (Target)this.getTarget();
            Thread currentThread = target.getCurrentThread();
            target.lockTarget();
            try {
                target.setCurrentThread(this, false);
                IPDIGetStackInfoDepthRequest request = this.session.getRequestFactory().getGetStackInfoDepthRequest(this.getTasks());
                this.session.getEventRequestManager().addEventRequest(request);
                this.stackdepth = request.getDepth(this.getTasks());
            }
            finally {
                target.setCurrentThread(currentThread, false);
                target.releaseTarget();
            }
        }
        return this.stackdepth;
    }

    @Override
    public IPDIStackFrame[] getStackFrames() throws PDIException {
        int depth = this.getStackFrameCount();
        if (this.currentFrames == null || this.currentFrames.size() < depth) {
            this.currentFrames = new ArrayList<IPDIStackFrame>();
            Target target = (Target)this.getTarget();
            Thread currentThread = target.getCurrentThread();
            target.lockTarget();
            try {
                IPDIStackFrameDescriptor[] frames;
                target.setCurrentThread(this, false);
                IPDIListStackFramesRequest request = this.session.getRequestFactory().getListStackFramesRequest(this.session, this.getTasks());
                this.session.getEventRequestManager().addEventRequest(request);
                IPDIStackFrameDescriptor[] iPDIStackFrameDescriptorArray = frames = request.getStackFrames(this.getTasks());
                int n = frames.length;
                int n2 = 0;
                while (n2 < n) {
                    IPDIStackFrameDescriptor frame = iPDIStackFrameDescriptorArray[n2];
                    IPDILocator locator = frame.getLocator();
                    this.currentFrames.add(this.session.getModelFactory().newStackFrame(this.session, this, depth - frame.getLevel(), locator.getFile(), locator.getFunction(), locator.getLineNumber(), locator.getAddress()));
                    ++n2;
                }
            }
            finally {
                target.setCurrentThread(currentThread, false);
                target.releaseTarget();
            }
            if (this.currentFrame == null) {
                int i = 0;
                while (i < this.currentFrames.size()) {
                    IPDIStackFrame stack = this.currentFrames.get(i);
                    if (stack.getLevel() == depth) {
                        this.currentFrame = (StackFrame)stack;
                    }
                    ++i;
                }
            }
        }
        return this.currentFrames.toArray(noStack);
    }

    @Override
    public IPDIStackFrame[] getStackFrames(int low, int high) throws PDIException {
        if (this.currentFrames == null || this.currentFrames.size() < high) {
            this.currentFrames = new ArrayList<IPDIStackFrame>();
            Target target = (Target)this.getTarget();
            Thread currentThread = target.getCurrentThread();
            target.lockTarget();
            try {
                IPDIStackFrameDescriptor[] frames;
                target.setCurrentThread(this, false);
                int depth = this.getStackFrameCount();
                int upperBound = high < depth ? Math.min(depth, 200) : depth;
                IPDIListStackFramesRequest request = this.session.getRequestFactory().getListStackFramesRequest(this.session, this.getTasks(), 0, upperBound);
                this.session.getEventRequestManager().addEventRequest(request);
                IPDIStackFrameDescriptor[] iPDIStackFrameDescriptorArray = frames = request.getStackFrames(this.getTasks());
                int n = frames.length;
                int n2 = 0;
                while (n2 < n) {
                    IPDIStackFrameDescriptor frame = iPDIStackFrameDescriptorArray[n2];
                    IPDILocator locator = frame.getLocator();
                    this.currentFrames.add(this.session.getModelFactory().newStackFrame(this.session, this, depth - frame.getLevel(), locator.getFile(), locator.getFunction(), locator.getLineNumber(), locator.getAddress()));
                    ++n2;
                }
            }
            finally {
                target.setCurrentThread(currentThread, false);
                target.releaseTarget();
            }
            if (this.currentFrame == null) {
                int i = 0;
                while (i < this.currentFrames.size()) {
                    StackFrame f = (StackFrame)this.currentFrames.get(i);
                    if (f.getLevel() == 0) {
                        this.currentFrame = f;
                    }
                    ++i;
                }
            }
        }
        List<IPDIStackFrame> list = high - low + 1 <= this.currentFrames.size() ? this.currentFrames.subList(low, high + 1) : this.currentFrames;
        return list.toArray(noStack);
    }

    @Override
    public IPDITarget getTarget() {
        return this.target;
    }

    @Override
    public IPDIThreadStorageDescriptor[] getThreadStorageDescriptors() throws PDIException {
        IPDIVariableManager varMgr = this.session.getVariableManager();
        return varMgr.getThreadStorageDescriptors(this);
    }

    @Override
    public void setCurrentStackFrame(IPDIStackFrame stackframe) throws PDIException {
        this.currentFrame = stackframe;
    }

    @Override
    public void setCurrentStackFrame(IPDIStackFrame stackframe, boolean doUpdate) throws PDIException {
        Thread aThread;
        int frameLevel = 0;
        if (stackframe != null) {
            frameLevel = stackframe.getLevel();
        }
        if (this.currentFrame != null && this.currentFrame.getLevel() == frameLevel && stackframe != null && (aThread = (Thread)stackframe.getThread()) != null && aThread.getId() == this.getId()) {
            return;
        }
        Target target = (Target)this.getTarget();
        int level = this.getStackFrameCount() - frameLevel;
        target.lockTarget();
        try {
            target.setCurrentThread(this, doUpdate);
            IPDISetCurrentStackFrameRequest request = this.session.getRequestFactory().getSetCurrentStackFrameRequest(this.getTasks(), level);
            this.session.getEventRequestManager().addEventRequest(request);
            request.waitUntilCompleted(this.getTasks());
            this.currentFrame = stackframe;
            if (doUpdate) {
                IPDIVariableManager varMgr;
                IPDIRegisterManager regMgr = this.session.getRegisterManager();
                if (regMgr.isAutoUpdate()) {
                    regMgr.update(target.getTasks());
                }
                if ((varMgr = this.session.getVariableManager()).isAutoUpdate()) {
                    varMgr.update(target.getTasks());
                }
            }
        }
        finally {
            target.releaseTarget();
        }
    }

    public String toString() {
        String str = Integer.toString(this.id);
        if (this.name != null) {
            str = String.valueOf(str) + " " + this.name;
        }
        return str;
    }

    public void updateState() {
        try {
            this.getCurrentStackFrame();
        }
        catch (PDIException pDIException) {
            // empty catch block
        }
    }
}

