/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.textedit.transition.xtext.umlTransition;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BehaviorKind implements Enumerator
{
    ACTIVITY(0, "ACTIVITY", "Activity"),
    STATE_MACHINE(1, "STATE_MACHINE", "StateMachine"),
    OPAQUE_BEHAVIOR(2, "OPAQUE_BEHAVIOR", "OpaqueBehavior");

    public static final int ACTIVITY_VALUE = 0;
    public static final int STATE_MACHINE_VALUE = 1;
    public static final int OPAQUE_BEHAVIOR_VALUE = 2;
    private static final BehaviorKind[] VALUES_ARRAY;
    public static final List<BehaviorKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BehaviorKind[]{ACTIVITY, STATE_MACHINE, OPAQUE_BEHAVIOR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BehaviorKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BehaviorKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BehaviorKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BehaviorKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BehaviorKind get(int value) {
        switch (value) {
            case 0: {
                return ACTIVITY;
            }
            case 1: {
                return STATE_MACHINE;
            }
            case 2: {
                return OPAQUE_BEHAVIOR;
            }
        }
        return null;
    }

    private BehaviorKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

