/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.providers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.MDTUtil;
import org.eclipse.papyrus.uml.diagram.common.providers.IMOSKittEditorFactory;
import org.eclipse.papyrus.uml.diagram.common.providers.MOSKittEditorFactory;
import org.eclipse.papyrus.uml.diagram.common.util.ExtensionPointParser;
import org.eclipse.ui.IEditorPart;

public class MOSKittEditorFactoryRegistry {
    private static final MOSKittEditorFactoryRegistry INSTANCE = new MOSKittEditorFactoryRegistry();
    private static Map<String, IMOSKittEditorFactory> mapEditorID2Factory = null;
    private static Map<String, IMOSKittEditorFactory> mapEClass2Factory = null;
    private static Map<String, IMOSKittEditorFactory> mapModel2Factory = null;
    private static final String ExtensionPointID = "org.eclipse.papyrus.uml.diagram.common.moskittEditorFactory";

    private MOSKittEditorFactoryRegistry() {
    }

    public static final MOSKittEditorFactoryRegistry getInstance() {
        return INSTANCE;
    }

    protected static Map<String, IMOSKittEditorFactory> getMapEditorID2Factory() {
        if (mapEditorID2Factory == null) {
            mapEditorID2Factory = new HashMap<String, IMOSKittEditorFactory>();
        }
        return mapEditorID2Factory;
    }

    protected static Map<String, IMOSKittEditorFactory> getMapEClass2Factory() {
        if (mapEClass2Factory == null) {
            mapEClass2Factory = new HashMap<String, IMOSKittEditorFactory>();
        }
        return mapEClass2Factory;
    }

    protected static Map<String, IMOSKittEditorFactory> getMapModel2Factory() {
        if (mapModel2Factory == null) {
            mapModel2Factory = new HashMap<String, IMOSKittEditorFactory>();
        }
        return mapModel2Factory;
    }

    public IEditorPart getEditorFor(Object object) {
        if (object == null) {
            return null;
        }
        Diagram diagram = (Diagram)Platform.getAdapterManager().getAdapter(object, Diagram.class);
        if (diagram != null) {
            return this.getEditorForDiagram(diagram);
        }
        EObject eObject = (EObject)Platform.getAdapterManager().getAdapter(object, EObject.class);
        if (eObject != null) {
            return this.getEditorForEObject(eObject);
        }
        String editorID = (String)Platform.getAdapterManager().getAdapter(object, String.class);
        if (editorID != null) {
            return this.getEditorForEditorID(editorID);
        }
        return null;
    }

    public IEditorPart getEditorForEditorID(String editorID) {
        IMOSKittEditorFactory factory;
        if (editorID == null) {
            return null;
        }
        this.readExtensionPoint();
        if (MOSKittEditorFactoryRegistry.getMapEditorID2Factory().containsKey(editorID) && (factory = MOSKittEditorFactoryRegistry.getMapEditorID2Factory().get(editorID)) != null) {
            return factory.createEditorFor(editorID);
        }
        return null;
    }

    public IEditorPart getEditorForEObject(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        this.readExtensionPoint();
        Class<?> eObjectClass = eObject.getClass();
        for (String eClass : MOSKittEditorFactoryRegistry.getMapEClass2Factory().keySet()) {
            IMOSKittEditorFactory factory;
            if (!MDTUtil.isOfType(eObjectClass, (String)eClass) || (factory = MOSKittEditorFactoryRegistry.getMapEClass2Factory().get(eClass)) == null) continue;
            return factory.createEditorFor(eObject);
        }
        return null;
    }

    public IEditorPart getEditorForDiagram(Diagram diagram) {
        IMOSKittEditorFactory factory;
        if (diagram == null || diagram.getType() == null) {
            return null;
        }
        this.readExtensionPoint();
        if (MOSKittEditorFactoryRegistry.getMapModel2Factory().containsKey(diagram.getType()) && (factory = MOSKittEditorFactoryRegistry.getMapModel2Factory().get(diagram.getType())) != null) {
            return factory.createEditorFor(diagram);
        }
        return null;
    }

    protected void readExtensionPoint() {
        ExtensionPointParser parser = new ExtensionPointParser(ExtensionPointID, new Class[]{MOSKittEditorFactory.class});
        MOSKittEditorFactory factory = null;
        ArrayList<MOSKittEditorFactory> factories = new ArrayList<MOSKittEditorFactory>();
        for (Object object : parser.parseExtensionPoint()) {
            factory = (MOSKittEditorFactory)Platform.getAdapterManager().getAdapter(object, MOSKittEditorFactory.class);
            if (factory == null) continue;
            factories.add(factory);
        }
        for (MOSKittEditorFactory editorFactoryElement : factories) {
            IMOSKittEditorFactory editorFactory = null;
            if (editorFactoryElement.factory == null || (editorFactory = (IMOSKittEditorFactory)Platform.getAdapterManager().getAdapter(editorFactoryElement.factory, IMOSKittEditorFactory.class)) == null) continue;
            if (editorFactoryElement.diagramType != null) {
                MOSKittEditorFactoryRegistry.getMapModel2Factory().put(editorFactoryElement.diagramType, editorFactory);
            }
            if (editorFactoryElement.eClass != null) {
                MOSKittEditorFactoryRegistry.getMapEClass2Factory().put(editorFactoryElement.eClass, editorFactory);
            }
            if (editorFactoryElement.editorID == null) continue;
            MOSKittEditorFactoryRegistry.getMapEditorID2Factory().put(editorFactoryElement.editorID, editorFactory);
        }
    }
}

