/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.custom.policies;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.swt.graphics.Color;

public class ContainerHighlightEditPolicy
extends GraphicalEditPolicy {
    private Color revertColor;

    public void eraseTargetFeedback(Request request) {
        if (this.revertColor != null) {
            this.setContainerBackground(this.revertColor);
            this.revertColor = null;
        }
    }

    private Color getContainerBackground() {
        return this.getContainerFigure().getBackgroundColor();
    }

    private IFigure getContainerFigure() {
        return ((GraphicalEditPart)this.getHost()).getFigure();
    }

    public EditPart getTargetEditPart(Request request) {
        return request.getType().equals("selection hover") ? this.getHost() : null;
    }

    private void setContainerBackground(Color c) {
        this.getContainerFigure().setBackgroundColor(c);
    }

    protected void showHighlight() {
        if (this.revertColor == null) {
            this.revertColor = this.getContainerBackground();
            this.setContainerBackground(ColorConstants.lightBlue);
        }
    }

    public void showTargetFeedback(Request request) {
        if (request.getType().equals("move") || request.getType().equals("add children") || request.getType().equals("clone") || request.getType().equals("connection start") || request.getType().equals("connection end") || request.getType().equals("create child")) {
            this.showHighlight();
        }
    }
}

