/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.architecture.widgets;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.core.architecture.ADElement;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedADElement;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureDomain;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureViewpoint;
import org.eclipse.papyrus.infra.ui.architecture.ArchitectureUIPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class ArchitectureContextComposite
extends Composite {
    private boolean allowSeveralContexts;
    private Set<String> selectedContexts;
    private Set<String> selectedViewpoints;
    private CheckboxTreeViewer contextsViewer;
    private CheckboxTableViewer viewpointViewer;
    private ComposedAdapterFactory composedAdapterFactory;
    private Updater updater;

    public ArchitectureContextComposite(Composite parent, int columns, int hspan, int fill, int marginwidth, int marginheight) {
        super(parent, 0);
        ArchitectureContextComposite.layoutComposite(this, parent, columns, hspan, fill, marginwidth, marginheight);
        this.composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        Composite tableComposite = ArchitectureContextComposite.createComposite(this, 1, 1, 1808, 0, 0);
        ArchitectureContextComposite.createLabel(tableComposite, "Architecture Contexts:", 2);
        this.contextsViewer = new ContainerCheckedTreeViewer(tableComposite, 2050);
        GridData gd = new GridData(1808);
        gd.heightHint = 250;
        this.contextsViewer.getControl().setLayoutData((Object)gd);
        this.contextsViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){
            private Collection<MergedArchitectureContext> allContexts;

            public boolean hasChildren(Object element) {
                return element instanceof MergedArchitectureDomain;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                LinkedHashSet<MergedArchitectureDomain> allDomains = new LinkedHashSet<MergedArchitectureDomain>();
                this.allContexts = new LinkedHashSet<MergedArchitectureContext>();
                Object[] objectArray = (Object[])inputElement;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    MergedArchitectureContext context = (MergedArchitectureContext)obj;
                    this.allContexts.add(context);
                    allDomains.add(context.getDomain());
                    ++n2;
                }
                return allDomains.toArray();
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof MergedArchitectureDomain) {
                    MergedArchitectureDomain domain = (MergedArchitectureDomain)parentElement;
                    ArrayList possibleContexts = new ArrayList(domain.getContexts());
                    possibleContexts.retainAll(this.allContexts);
                    return possibleContexts.toArray();
                }
                return null;
            }
        });
        this.contextsViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.composedAdapterFactory){

            public Image getImage(Object object) {
                MergedADElement element = (MergedADElement)object;
                ADElement imageObject = element.getImageObject();
                if (imageObject != null && imageObject.getIcon() != null) {
                    try {
                        URL image = new URL(imageObject.getIcon().toString());
                        return this.getImageFromObject(image);
                    }
                    catch (MalformedURLException e) {
                        ArchitectureUIPlugin.log.error((Throwable)e);
                        return null;
                    }
                }
                return super.getImage((Object)imageObject);
            }

            public String getText(Object object) {
                return ((MergedADElement)object).getName();
            }
        });
        this.contextsViewer.setComparator(new ViewerComparator());
        this.contextsViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                if (element instanceof MergedArchitectureContext) {
                    return ArchitectureContextComposite.this.selectedContexts.contains(((MergedArchitectureContext)element).getId());
                }
                return ArchitectureContextComposite.this.contextsViewer.getChecked(element);
            }
        });
        this.contextsViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                int n;
                int n2;
                Object[] objectArray;
                ArchitectureDomainManager manager = ArchitectureDomainManager.getInstance();
                if (!ArchitectureContextComposite.this.allowSeveralContexts && (event.getChecked() || ArchitectureContextComposite.this.contextsViewer.getCheckedElements().length == 0)) {
                    if (event.getElement() instanceof MergedArchitectureContext) {
                        ArchitectureContextComposite.this.contextsViewer.setCheckedElements(new Object[]{event.getElement()});
                    } else {
                        objectArray = ArchitectureContextComposite.this.contextsViewer.getTree().getItems();
                        n2 = objectArray.length;
                        n = 0;
                        while (n < n2) {
                            Object item = objectArray[n];
                            if (item.getData() == event.getElement()) {
                                ArchitectureContextComposite.this.contextsViewer.setCheckedElements(new Object[]{item.getItem(0).getData()});
                                break;
                            }
                            ++n;
                        }
                    }
                }
                ArchitectureContextComposite.this.selectedContexts.clear();
                objectArray = ArchitectureContextComposite.this.contextsViewer.getCheckedElements();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    Object element = objectArray[n];
                    if (element instanceof MergedArchitectureContext) {
                        ArchitectureContextComposite.this.selectedContexts.add(((MergedArchitectureContext)element).getId());
                    }
                    ++n;
                }
                ArchitectureContextComposite.this.selectedViewpoints.clear();
                for (String contextId : ArchitectureContextComposite.this.selectedContexts) {
                    MergedArchitectureContext context = manager.getArchitectureContextById(contextId);
                    Collection viewpoints = context.getDefaultViewpoints();
                    if (viewpoints.isEmpty()) {
                        viewpoints = context.getViewpoints();
                    }
                    for (MergedArchitectureViewpoint viewpoint : viewpoints) {
                        ArchitectureContextComposite.this.selectedViewpoints.add(viewpoint.getId());
                    }
                }
                ArchitectureContextComposite.this.updateViewpoints();
                if (ArchitectureContextComposite.this.updater != null) {
                    ArchitectureContextComposite.this.updater.update();
                }
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.contextsViewer, (int)2);
        Composite viewpointComposite = ArchitectureContextComposite.createComposite(this, 1, 1, 768, 0, 0);
        ArchitectureContextComposite.createLabel(viewpointComposite, "Architecture Viewpoints:", 1);
        this.viewpointViewer = CheckboxTableViewer.newCheckList((Composite)viewpointComposite, (int)67586);
        gd = new GridData(768);
        gd.heightHint = 100;
        this.viewpointViewer.getControl().setLayoutData((Object)gd);
        this.viewpointViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                TreeSet<MergedADElement> viewpoints = new TreeSet<MergedADElement>(new Comparator<MergedADElement>(){

                    @Override
                    public int compare(MergedADElement o1, MergedADElement o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                Object[] objectArray = (Object[])inputElement;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof MergedArchitectureContext) {
                        viewpoints.addAll(((MergedArchitectureContext)obj).getViewpoints());
                    }
                    ++n2;
                }
                return viewpoints.toArray();
            }
        });
        this.viewpointViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){
            private ILabelProvider provider;
            {
                this.provider = new AdapterFactoryLabelProvider((AdapterFactory)ArchitectureContextComposite.this.composedAdapterFactory);
            }

            public Image getImage(Object object) {
                MergedADElement element = (MergedADElement)object;
                return this.provider.getImage((Object)element.getImageObject());
            }

            public String getText(Object object) {
                return ((MergedADElement)object).getName();
            }
        });
        this.viewpointViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                return ArchitectureContextComposite.this.selectedViewpoints.contains(((MergedArchitectureViewpoint)element).getId());
            }
        });
        this.viewpointViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                MergedArchitectureViewpoint viewpoint = (MergedArchitectureViewpoint)event.getElement();
                if (event.getChecked()) {
                    ArchitectureContextComposite.this.selectedViewpoints.add(viewpoint.getId());
                } else {
                    ArchitectureContextComposite.this.selectedViewpoints.remove(viewpoint.getId());
                }
                ArchitectureContextComposite.this.updateViewpoints();
                if (ArchitectureContextComposite.this.updater != null) {
                    ArchitectureContextComposite.this.updater.update();
                }
            }
        });
        this.updateViewpoints();
    }

    public void setInput(Object input) {
        this.contextsViewer.setInput(input);
        this.contextsViewer.expandAll();
        this.updateViewpoints();
    }

    public void setAllowSeveralContexts(boolean allowSeveralContexts) {
        this.allowSeveralContexts = allowSeveralContexts;
    }

    public String[] getSelectedContexts() {
        return this.selectedContexts.toArray(new String[0]);
    }

    public void setSelectedContexts(String[] selectedContexts) {
        this.selectedContexts = new HashSet<String>(Arrays.asList(selectedContexts));
    }

    public String[] getSelectedViewpoints() {
        return this.selectedViewpoints.toArray(new String[0]);
    }

    public void setSelectedViewpoints(String[] selectedViewpoints) {
        this.selectedViewpoints = new HashSet<String>(Arrays.asList(selectedViewpoints));
    }

    public void setUpdater(Updater updater) {
        this.updater = updater;
    }

    private void updateViewpoints() {
        this.viewpointViewer.setInput((Object)this.contextsViewer.getCheckedElements());
    }

    private static Composite createComposite(Composite parent, int columns, int hspan, int fill, int marginwidth, int marginheight) {
        Composite g = new Composite(parent, 0);
        ArchitectureContextComposite.layoutComposite(g, parent, columns, hspan, fill, marginwidth, marginheight);
        return g;
    }

    private static Composite layoutComposite(Composite g, Composite parent, int columns, int hspan, int fill, int marginwidth, int marginheight) {
        GridLayout layout = new GridLayout(columns, false);
        layout.marginWidth = marginwidth;
        layout.marginHeight = marginheight;
        g.setLayout((Layout)layout);
        g.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    private static Label createLabel(Composite parent, String text, int hspan) {
        Label l = new Label(parent, 0);
        l.setFont(parent.getFont());
        l.setText(text);
        GridData gd = new GridData(768);
        gd.horizontalSpan = hspan;
        gd.grabExcessHorizontalSpace = false;
        l.setLayoutData((Object)gd);
        return l;
    }

    public static interface Updater {
        public void update();
    }
}

