/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.navigation.ui;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.navigation.Activator;
import org.eclipse.papyrus.infra.gmfdiag.navigation.ui.DynamicNavigate;
import org.eclipse.papyrus.infra.gmfdiag.navigation.ui.DynamicNavigateLabelProvider;
import org.eclipse.papyrus.infra.services.navigation.service.NavigableElement;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationService;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;

public class ModelExplorerDynamicNavigate
extends DynamicNavigate {
    public void fill(Menu menu, int index) {
        List navigableElements;
        EObject selectedObject = this.getSelection();
        if (this.navigationService != null && (navigableElements = this.navigationService.getNavigableElements((Object)selectedObject)) != null) {
            for (final NavigableElement navigableElement : navigableElements) {
                List<Object> viewsToSelect = this.getViewsToSelect(navigableElement, false);
                if ((viewsToSelect == null || viewsToSelect.isEmpty()) && navigableElement.getLabel().startsWith("Go to element (")) continue;
                MenuItem menuItem = new MenuItem(menu, 64);
                menuItem.setText(navigableElement.getLabel());
                menuItem.setImage(navigableElement.getImage());
                menuItem.setToolTipText(navigableElement.getDescription());
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ModelExplorerDynamicNavigate.this.showInModelExplorer(navigableElement);
                    }
                });
                menuItem.setMenu(new Menu(menuItem));
                Menu subMenu = menuItem.getMenu();
                if (!navigableElement.getLabel().startsWith("Go to element (")) {
                    MenuItem subMenuItem = new MenuItem(subMenu, 32);
                    subMenuItem.setText("Model Explorer");
                    subMenuItem.setImage(Activator.getDefault().getIcon("modelexplorer"));
                    subMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ModelExplorerDynamicNavigate.this.showInModelExplorer(navigableElement);
                        }
                    });
                }
                for (final Object view : viewsToSelect) {
                    if (!(view instanceof EObject)) continue;
                    MenuItem subMenuViewItem = new MenuItem(subMenu, 32);
                    subMenuViewItem.setText(DynamicNavigateLabelProvider.getText(view));
                    subMenuViewItem.setToolTipText(DynamicNavigateLabelProvider.getToolTipText(view));
                    subMenuViewItem.setImage(DynamicNavigateLabelProvider.getImage(view));
                    subMenuViewItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ModelExplorerDynamicNavigate.this.revealObject(view);
                        }
                    });
                }
            }
        }
    }

    protected EObject getSelection() {
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        if (selectionService == null) {
            return null;
        }
        ISelection selection = selectionService.getSelection();
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        if (selection instanceof IStructuredSelection) {
            Object selectedobject = ((IStructuredSelection)selection).getFirstElement();
            EObject selectedEObject = EMFHelper.getEObject((Object)selectedobject);
            try {
                ServicesRegistry registry = ServiceUtilsForEObject.getInstance().getServiceRegistry(selectedEObject);
                if (registry != null) {
                    this.navigationService = (NavigationService)registry.getService(NavigationService.class);
                }
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
            }
            return selectedEObject;
        }
        return null;
    }
}

