/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import org.eclipse.mat.query.Bytes;
import org.eclipse.mat.query.BytesDisplay;
import org.eclipse.mat.report.internal.Messages;

public class BytesFormat
extends Format {
    private static final long serialVersionUID = 9162983935673281910L;
    private static final double KB = 1024.0;
    private static final double NEGKB = -1024.0;
    private static final double MB = 1048576.0;
    private static final double NEGMB = -1048576.0;
    private static final double GB = 1.073741824E9;
    private static final double NEGGB = -1.073741824E9;
    private static final ThreadLocal<Format> defaultFormat;
    private static final ThreadLocal<Format> detailedFormat;
    public static final String DETAILED_DECIMAL_FORMAT = "#,##0.00";
    static final String DETAILED_DECIMAL_FORMAT2;
    private final Format encapsulatedNumberFormat;
    private final Format encapsulatedDecimalFormat;

    static {
        String ret;
        defaultFormat = new ThreadLocal<Format>(){

            @Override
            protected Format initialValue() {
                return DecimalFormat.getInstance();
            }
        };
        detailedFormat = new ThreadLocal<Format>(){

            @Override
            protected Format initialValue() {
                return new DecimalFormat(DETAILED_DECIMAL_FORMAT2);
            }
        };
        NumberFormat nf = NumberFormat.getNumberInstance();
        if (nf instanceof DecimalFormat) {
            DecimalFormat df = (DecimalFormat)nf;
            df.setMinimumFractionDigits(2);
            df.setMaximumFractionDigits(2);
            ret = df.toPattern();
            int i = ret.indexOf(59);
            if (i >= 0) {
                ret = ret.substring(0, i);
            }
        } else {
            ret = DETAILED_DECIMAL_FORMAT;
        }
        DETAILED_DECIMAL_FORMAT2 = ret;
    }

    public BytesFormat() {
        this(null, null);
    }

    public BytesFormat(Format encapsulatedNumberFormat, Format encapsulatedDecimalFormat) {
        this.encapsulatedNumberFormat = encapsulatedNumberFormat;
        this.encapsulatedDecimalFormat = encapsulatedDecimalFormat;
    }

    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        Long target = null;
        if (obj instanceof Bytes) {
            target = ((Bytes)obj).getValue();
        } else if (obj instanceof Long) {
            target = (Long)obj;
        } else if (obj instanceof Integer) {
            target = ((Integer)obj).longValue();
        } else if (obj instanceof Short) {
            target = ((Short)obj).longValue();
        }
        if (target != null) {
            obj = target;
            BytesDisplay currentDisplay = BytesDisplay.getCurrentValue();
            switch (currentDisplay) {
                case Kilobytes: {
                    pos.setBeginIndex(toAppendTo.length());
                    StringBuffer ret = this.formatKb(toAppendTo, target.longValue());
                    pos.setEndIndex(toAppendTo.length());
                    return ret;
                }
                case Megabytes: {
                    pos.setBeginIndex(toAppendTo.length());
                    StringBuffer ret = this.formatMb(toAppendTo, target.longValue());
                    pos.setEndIndex(toAppendTo.length());
                    return ret;
                }
                case Gigabytes: {
                    pos.setBeginIndex(toAppendTo.length());
                    StringBuffer ret = this.formatGb(toAppendTo, target.longValue());
                    pos.setEndIndex(toAppendTo.length());
                    return ret;
                }
                case Smart: {
                    if ((double)target.longValue() >= 1.073741824E9 || (double)target.longValue() <= -1.073741824E9) {
                        pos.setBeginIndex(toAppendTo.length());
                        StringBuffer ret = this.formatGb(toAppendTo, target.longValue());
                        pos.setEndIndex(toAppendTo.length());
                        return ret;
                    }
                    if ((double)target.longValue() >= 1048576.0 || (double)target.longValue() <= -1048576.0) {
                        pos.setBeginIndex(toAppendTo.length());
                        StringBuffer ret = this.formatMb(toAppendTo, target.longValue());
                        pos.setEndIndex(toAppendTo.length());
                        return ret;
                    }
                    if ((double)target.longValue() >= 1024.0 || (double)target.longValue() <= -1024.0) {
                        pos.setBeginIndex(toAppendTo.length());
                        StringBuffer ret = this.formatKb(toAppendTo, target.longValue());
                        pos.setEndIndex(toAppendTo.length());
                        return ret;
                    }
                    pos.setBeginIndex(toAppendTo.length());
                    StringBuffer ret = this.formatB(toAppendTo, target.longValue());
                    pos.setEndIndex(toAppendTo.length());
                    return ret;
                }
            }
        }
        return this.getDefaultFormat().format(obj, toAppendTo, pos);
    }

    private Format getDefaultFormat() {
        return this.encapsulatedNumberFormat != null ? this.encapsulatedNumberFormat : defaultFormat.get();
    }

    private Format getDetailedFormat() {
        return this.encapsulatedDecimalFormat != null ? this.encapsulatedDecimalFormat : detailedFormat.get();
    }

    private StringBuffer formatGb(StringBuffer toAppendTo, double val) {
        double gb = val / 1.073741824E9;
        toAppendTo.append(this.getDetailedFormat().format(gb)).append(Messages.BytesFormat_GB);
        return toAppendTo;
    }

    private StringBuffer formatMb(StringBuffer toAppendTo, double val) {
        double mb = val / 1048576.0;
        toAppendTo.append(this.getDetailedFormat().format(mb)).append(Messages.BytesFormat_MB);
        return toAppendTo;
    }

    private StringBuffer formatKb(StringBuffer toAppendTo, double val) {
        double kb = val / 1024.0;
        toAppendTo.append(this.getDetailedFormat().format(kb)).append(Messages.BytesFormat_KB);
        return toAppendTo;
    }

    private StringBuffer formatB(StringBuffer toAppendTo, double val) {
        toAppendTo.append(this.getDefaultFormat().format(val)).append(Messages.BytesFormat_B);
        return toAppendTo;
    }

    public Object parseObject(String source, ParsePosition pos) {
        BytesDisplay currentDisplay = BytesDisplay.getCurrentValue();
        if (currentDisplay != BytesDisplay.Bytes) {
            int pi = pos.getIndex();
            Object o1 = this.getDetailedFormat().parseObject(source, pos);
            if (o1 instanceof Number) {
                Number n1 = (Number)o1;
                if (currentDisplay == BytesDisplay.Smart && source.regionMatches(pos.getIndex(), Messages.BytesFormat_B, 0, 2)) {
                    pos.setIndex(pos.getIndex() + 2);
                    return new Bytes(n1.longValue());
                }
                if ((currentDisplay == BytesDisplay.Kilobytes || currentDisplay == BytesDisplay.Smart) && source.regionMatches(pos.getIndex(), Messages.BytesFormat_KB, 0, 3)) {
                    pos.setIndex(pos.getIndex() + 3);
                    return new Bytes((long)((double)n1.longValue() * 1024.0));
                }
                if ((currentDisplay == BytesDisplay.Megabytes || currentDisplay == BytesDisplay.Smart) && source.regionMatches(pos.getIndex(), Messages.BytesFormat_MB, 0, 3)) {
                    pos.setIndex(pos.getIndex() + 3);
                    return new Bytes((long)((double)n1.longValue() * 1048576.0));
                }
                if ((currentDisplay == BytesDisplay.Gigabytes || currentDisplay == BytesDisplay.Smart) && source.regionMatches(pos.getIndex(), Messages.BytesFormat_GB, 0, 3)) {
                    pos.setIndex(pos.getIndex() + 3);
                    return new Bytes((long)((double)n1.longValue() * 1.073741824E9));
                }
                pos.setErrorIndex(pos.getIndex());
                pos.setIndex(pi);
                return null;
            }
            pos.setErrorIndex(pi);
            pos.setIndex(pi);
            return null;
        }
        Object ret = this.getDefaultFormat().parseObject(source, pos);
        if (ret instanceof Number) {
            return new Bytes(((Number)ret).longValue());
        }
        return ret;
    }

    public static BytesFormat getInstance() {
        return new BytesFormat();
    }
}

