/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.jruby.resolver;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.jruby.resolver.Messages;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.results.CompositeResult;
import org.eclipse.mat.query.results.TextResult;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.extension.IRequestDetailsResolver;
import org.eclipse.mat.snapshot.extension.IThreadInfo;
import org.eclipse.mat.snapshot.extension.Subject;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.osgi.util.NLS;

@Subject(value="org.jruby.runtime.ThreadContext")
public class JRubyScriptResolver
implements IRequestDetailsResolver {
    public void complement(ISnapshot snapshot, IThreadInfo thread, int[] localVars, int currentVarId, IProgressListener listener) throws SnapshotException {
        String removedMethodName;
        Collection classesByName;
        boolean isOsgiBased = false;
        String shortJavaName = null;
        int i = 0;
        while (i < localVars.length) {
            IObject object = snapshot.getObject(localVars[i]);
            if (snapshot.getObject(localVars[i]).getTechnicalName().startsWith("org.eclipse.core.runtime")) {
                isOsgiBased = true;
            } else if (snapshot.getObject(localVars[i]).getTechnicalName().startsWith("sun.reflect.NativeMethodAccessorImpl")) {
                IObject object2 = (IObject)snapshot.getObject(localVars[i]).resolveValue("method");
                if (object2 != null) {
                    shortJavaName = object2.getClassSpecificName();
                }
            } else if (object.getTechnicalName().startsWith("org.jruby") || object.getTechnicalName().startsWith("java") || object.getTechnicalName().startsWith("ruby")) {
                // empty if block
            }
            ++i;
        }
        ArrayList<String> possibleBundleSuspects = new ArrayList<String>();
        String realClassName = null;
        if (shortJavaName != null && (classesByName = snapshot.getClassesByName(removedMethodName = (realClassName = shortJavaName.substring(shortJavaName.indexOf(32)).trim()).substring(0, realClassName.lastIndexOf(46)), true)) != null) {
            for (IClass iClass : classesByName) {
                possibleBundleSuspects.add(snapshot.getObject(iClass.getClassLoaderId()).getClassSpecificName());
            }
        }
        CompositeResult result = new CompositeResult(new IResult[0]);
        String classSpecificName = "";
        List outboundReferences = snapshot.getObject(currentVarId).getOutboundReferences();
        for (NamedReference namedReference : outboundReferences) {
            if (!"file".equals(namedReference.getName())) continue;
            classSpecificName = namedReference.getObject().getClassSpecificName();
            break;
        }
        if (classSpecificName.length() > 0) {
            String fileName = new File(classSpecificName).getName();
            String summary = NLS.bind((String)Messages.JRubyScriptResolver_Summary, (Object)fileName);
            String rubyCallMessage = shortJavaName == null ? NLS.bind((String)Messages.JRubyScriptResolver_ResultBody_RubyCall_Class, (Object)fileName) : NLS.bind((String)Messages.JRubyScriptResolver_ResultBody_RubyCall_Method, (Object)fileName, (Object)realClassName);
            String possibleBundleSuspectsMessage = "";
            if (isOsgiBased && possibleBundleSuspects.size() > 0) {
                thread.addKeyword("osgi");
                StringBuilder suspects = new StringBuilder();
                for (String possibleBundleSuspect : possibleBundleSuspects) {
                    suspects.append(possibleBundleSuspect).append(' ');
                }
                possibleBundleSuspectsMessage = NLS.bind((String)Messages.JRubyScriptResolver_ResultBody_PossibleSuspects, (Object)suspects);
            }
            String rubyScriptPathMessage = NLS.bind((String)Messages.JRubyScriptResolver_ResultBody_RubyScriptPath, (Object)classSpecificName);
            String resultBody = NLS.bind((String)Messages.JRubyScriptResolver_ResultBody, (Object[])new Object[]{rubyCallMessage, possibleBundleSuspectsMessage, rubyScriptPathMessage});
            result.addResult(Messages.JRubyScriptResolver_ResultHeader, (IResult)new TextResult(resultBody, true));
            thread.addRequest(summary, (IResult)result);
            thread.addKeyword("Ruby");
            thread.addKeyword("script");
        }
    }
}

