/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ibmvm.acquire;

import java.io.File;
import java.util.Collection;
import org.eclipse.mat.ibmvm.acquire.IBMDumpProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HprofDumpProvider
extends IBMDumpProvider {
    HprofDumpProvider() {
    }

    @Override
    String dumpName() {
        return "java_pid%pid%.seq.hprof";
    }

    @Override
    int files() {
        return 1;
    }

    @Override
    long averageFileSize(Collection<File> files) {
        long l = 0L;
        int i = 0;
        for (File f : files) {
            if (!f.isFile() || !f.getName().endsWith(".hprof")) continue;
            l += f.length();
            ++i;
        }
        if (i > 0) {
            return l / (long)i;
        }
        return 100000000L;
    }
}

