/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

public class EnableConnectionCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof CommonNavigator) {
            final CommonViewer viewer = ((CommonNavigator)activePart).getCommonViewer();
            ITreeSelection selection = viewer.getStructuredSelection();
            TreePath[] treePathArray = selection.getPaths();
            int n = treePathArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath treePath = treePathArray[n2];
                final IDockerConnection conn = (IDockerConnection)treePath.getLastSegment();
                if (!conn.isOpen()) {
                    Job openConnectionJob = new Job(CommandMessages.getFormattedString("command.enableconnection", conn.getUri())){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                conn.open(true);
                                Display.getDefault().asyncExec(() -> viewer.refresh((Object)conn));
                            }
                            catch (DockerException e) {
                                Activator.logErrorMessage(CommandMessages.getFormattedString("command.enableconnection.failure", conn.getUri()), e);
                                return Status.CANCEL_STATUS;
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    openConnectionJob.schedule();
                }
                ++n2;
            }
        }
        return null;
    }
}

