/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.parts.view;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.jwt.we.model.view.EdgeDirection;
import org.eclipse.jwt.we.model.view.ReferenceEdge;
import org.eclipse.jwt.we.parts.core.EdgeModelElementEditPart;

public class ReferenceEdgeEditPart
extends EdgeModelElementEditPart {
    public Class getModelClass() {
        return ReferenceEdge.class;
    }

    public ReferenceEdge getReferenceEdge() {
        return (ReferenceEdge)this.getModel();
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
    }

    protected IFigure createFigure() {
        PolylineConnection connection = (PolylineConnection)super.createFigure();
        this.setDecorations(connection);
        return connection;
    }

    protected void setDecorations(PolylineConnection connection) {
        EdgeDirection direction = ((ReferenceEdge)this.getModel()).getDirection();
        if (direction == EdgeDirection.IN || direction == EdgeDirection.INOUT) {
            connection.setSourceDecoration((RotatableDecoration)new PolygonDecoration());
        } else {
            connection.setSourceDecoration(null);
        }
        if (direction == EdgeDirection.OUT || direction == EdgeDirection.INOUT) {
            connection.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
        } else {
            connection.setTargetDecoration(null);
        }
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        int featureId = notification.getFeatureID(ReferenceEdge.class);
        switch (notification.getEventType()) {
            case 1: 
            case 2: {
                switch (featureId) {
                    case 4: {
                        this.setDecorations((PolylineConnection)this.getFigure());
                    }
                }
            }
        }
    }
}

