/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.logging.internal;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jwt.we.misc.logging.internal.EclipseLogFormatter;

public class EclipseLogHandler
extends Handler {
    private ILog eclipseLogger;
    private Plugin plugin;

    public EclipseLogHandler(Plugin plugin) {
        this.plugin = plugin;
        this.eclipseLogger = plugin.getLog();
        this.setFormatter(new EclipseLogFormatter());
    }

    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        int level = record.getLevel().intValue();
        int severity = 0;
        if (level >= Level.SEVERE.intValue()) {
            severity = 4;
        } else if (level >= Level.WARNING.intValue()) {
            severity = 2;
        } else if (level >= Level.INFO.intValue()) {
            severity = 1;
        }
        String message = null;
        try {
            message = this.getFormatter().format(record);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 5);
        }
        if (message == null || message.length() == 0 && record.getThrown() != null) {
            message = record.getThrown().toString();
        }
        if (message == null) {
            message = "";
        }
        Status status = new Status(severity, this.plugin.getBundle().getSymbolicName(), this.plugin.getBundle().getState(), message, record.getThrown());
        this.eclipseLogger.log((IStatus)status);
    }

    public void flush() {
    }

    public void close() throws SecurityException {
    }
}

