/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.internal;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.jwt.meta.PluginProperties;
import org.eclipse.jwt.meta.model.core.Package;
import org.eclipse.jwt.meta.model.processes.Activity;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.editors.pages.activityEditor.internal.IActivityEditor;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.ui.IPropertyListener;

public class EditorPropertyUpdater
extends AdapterImpl
implements IPropertyListener,
IDisposable {
    private WEEditor editor;

    public EditorPropertyUpdater(WEEditor editor) {
        assert (editor != null);
        this.editor = editor;
        editor.addPropertyListener(this);
    }

    public void notifyChanged(Notification notification) {
        if (notification.getNotifier() instanceof Activity) {
            int featureId = notification.getFeatureID(Activity.class);
            switch (notification.getEventType()) {
                case 1: 
                case 2: {
                    switch (featureId) {
                        case 1: 
                        case 2: {
                            this.editor.updateTitleName();
                            this.editor.updateTitleImage();
                            CTabItem[] cTabItemArray = this.editor.getTabFolder().getItems();
                            int n = cTabItemArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                CTabItem item = cTabItemArray[n2];
                                if (item.getData() instanceof IActivityEditor && ((IActivityEditor)item.getData()).getActivityModel() == notification.getNotifier()) {
                                    String newTitle = ((Activity)notification.getNotifier()).getName();
                                    if (newTitle == null || newTitle.length() == 0) {
                                        newTitle = PluginProperties.model_Unnamed_name;
                                    }
                                    item.setText(newTitle);
                                }
                                ++n2;
                            }
                            break block0;
                        }
                    }
                }
            }
        } else if (notification.getNotifier() instanceof Package) {
            switch (notification.getEventType()) {
                case 4: {
                    if (notification.getOldValue() instanceof Activity) {
                        this.editor.removeActivityFromPage((Activity)notification.getOldValue());
                        break;
                    }
                    if (!(notification.getOldValue() instanceof Package)) break;
                    Package pack = (Package)notification.getOldValue();
                    TreeIterator iterator2 = pack.eAllContents();
                    while (iterator2.hasNext()) {
                        EObject content = (EObject)iterator2.next();
                        if (!(content instanceof Activity)) continue;
                        this.editor.removeActivityFromPage((Activity)content);
                    }
                    break;
                }
                case 6: {
                    for (Object obj : (Iterable)notification.getOldValue()) {
                        if (obj instanceof Activity) {
                            this.editor.removeActivityFromPage((Activity)notification.getOldValue());
                            continue;
                        }
                        if (!(obj instanceof Package)) continue;
                        TreeIterator iterator2 = ((Package)obj).eAllContents();
                        while (iterator2.hasNext()) {
                            EObject content = (EObject)iterator2.next();
                            if (!(content instanceof Activity)) continue;
                            this.editor.removeActivityFromPage((Activity)content);
                        }
                    }
                    break;
                }
            }
        }
    }

    public void propertyChanged(Object source, int propId) {
        switch (propId) {
            case 258: {
                this.editor.updateTitleName();
                this.editor.updateTitleImage();
            }
        }
    }

    public void addUpdateListener(Activity activity) {
        if (activity != null) {
            activity.eAdapters().add((Object)this);
            EObject container = activity.eContainer();
            while (container != null) {
                container.eAdapters().add((Object)this);
                container = container.eContainer();
            }
        }
    }

    public void removeUpdateListener(Activity activity) {
        if (activity != null) {
            activity.eAdapters().remove((Object)this);
            EObject container = activity.eContainer();
            while (container != null) {
                container.eAdapters().remove((Object)this);
                container = container.eContainer();
            }
        }
    }

    public void dispose() {
        this.editor.removePropertyListener(this);
    }
}

