/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.transformations.api.io;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jwt.transformations.api.io.IODefinition;
import org.eclipse.jwt.transformations.internal.init.Activator;

public abstract class AbstractIODefinition
implements IODefinition,
IExecutableExtension {
    private static final String IODEFINITION_EXTENSION_POINT = "org.eclipse.jwt.transformations.iodefinitions";
    public static final String REFERENCE_CONFIGURATION_ELEMENT = "ioreference";
    public static final String DEFINITION_CONFIGURATION_ELEMENT = "iodefinition";
    public static final String PARAMETER_CONFIGURATION_ELEMENT = "parameter";
    private static final String REFERENCE_ID_CONFIGURATION_ATTRIBUTE = "id";
    public static final String DEFINITION_CLASS_CONFIGURATION_ATTRIBUTE = "class";
    private static final String DEFINITION_LABEL_CONFIGURATION_ATTRIBUTE = "label";
    private static final String PARAMETER_NAME_CONFIGURATION_ATTRIBUTE = "name";
    private static final String PARAMETER_VALUE_CONFIGURATION_ATTRIBUTE = "value";
    private String label;
    private Map<String, String> parameters;

    private static IExtensionPoint getExtensionPoint() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        return registry.getExtensionPoint(IODEFINITION_EXTENSION_POINT);
    }

    public static IODefinition createIODefinition(String extensionID) throws CoreException, IOException {
        IExtensionPoint extensionPoint = AbstractIODefinition.getExtensionPoint();
        IExtension extension = extensionPoint.getExtension(extensionID);
        if (extension == null) {
            throw new IOException("An IODefinition could not be created");
        }
        return AbstractIODefinition.createIODefinition(extension.getConfigurationElements()[0]);
    }

    public static IODefinition createIODefinition(IConfigurationElement config) throws CoreException, IOException {
        if (REFERENCE_CONFIGURATION_ELEMENT.equals(config.getName())) {
            return AbstractIODefinition.createIODefinition(config.getAttribute(REFERENCE_ID_CONFIGURATION_ATTRIBUTE));
        }
        Object created = config.createExecutableExtension(DEFINITION_CLASS_CONFIGURATION_ATTRIBUTE);
        if (created == null) {
            throw new IOException("An IODefinition could not be created");
        }
        if (!(created instanceof IODefinition)) {
            throw new IOException("An IODefinition was found to have incorrect type");
        }
        return (IODefinition)created;
    }

    public final void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.label = config.getAttribute(DEFINITION_LABEL_CONFIGURATION_ATTRIBUTE);
        if (this.label == null) {
            throw new InvalidIODefinitionException(this);
        }
        this.parameters = new HashMap<String, String>();
        IConfigurationElement[] iConfigurationElementArray = config.getChildren(PARAMETER_CONFIGURATION_ELEMENT);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement parameter = iConfigurationElementArray[n2];
            String key = parameter.getAttribute(PARAMETER_NAME_CONFIGURATION_ATTRIBUTE);
            String value = parameter.getAttribute(PARAMETER_VALUE_CONFIGURATION_ATTRIBUTE);
            this.parameters.put(key, value);
            ++n2;
        }
    }

    public final String getLabel() {
        return this.label;
    }

    protected final String getParameter(String name) {
        return this.parameters.get(name);
    }

    public final void setParameter(String name, String value) {
        if (value == null) {
            this.parameters.remove(name);
        } else {
            this.parameters.put(name, value);
        }
    }

    private static class InvalidIODefinitionException
    extends CoreException {
        private static final long serialVersionUID = -8978517553154150730L;
        private static String ERROR_FORMAT = "A registered IODefinition has invalid label [label:%s]";

        public InvalidIODefinitionException(AbstractIODefinition ioDefinition) {
            super((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), String.format(ERROR_FORMAT, ioDefinition.label)));
        }
    }
}

