/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.preferences;

import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class BrowserPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int NUM_COLUMNS = 1;
    private static final int HORIZONTAL_SPACING_10 = 10;
    private static final int VERTICAL_SPACING_10 = 10;
    private static final int MARGIN_HEIGHT_10 = 10;
    private static final int MARGIN_WIDTH_10 = 10;
    private IPreferenceStore m_store = Plugin.getDefault().getPreferenceStore();
    private Button m_filterColoringEnableButton;
    private ColorFieldEditor m_colorFieldEditor;
    private Composite m_colorComp;

    public BrowserPreferencePage() {
        this.setPreferenceStore(Plugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
        this.setDescription(Messages.BrowserPreferencePageDescription);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.compositeGridData(composite);
        this.createFilterBackgroundColoringSettings(composite);
        return composite;
    }

    private void compositeGridData(Composite composite) {
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 1;
        compositeLayout.horizontalSpacing = 10;
        compositeLayout.verticalSpacing = 10;
        compositeLayout.marginHeight = 10;
        compositeLayout.marginWidth = 10;
        composite.setLayout((Layout)compositeLayout);
        GridData compositeData = new GridData(1808);
        compositeData.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)compositeData);
    }

    private void createFilterBackgroundColoringSettings(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(Messages.BrowserPreferencePageFilterColoringGroup);
        RowLayout layout = new RowLayout();
        layout.type = 512;
        group.setLayout((Layout)layout);
        GridData layoutData = new GridData(768);
        layoutData.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)layoutData);
        Label label = new Label((Composite)group, 0);
        label.setText(Messages.BrowserPreferencePageFilterColoringDescription);
        new Label((Composite)group, 0);
        this.m_filterColoringEnableButton = new Button((Composite)group, 32);
        this.m_filterColoringEnableButton.setText(Messages.BrowserPreferencePageFilterColoringButton);
        this.m_filterColoringEnableButton.setSelection(this.m_store.getBoolean("BACKGROUND_COLORING_KEY"));
        this.m_colorComp = new Composite((Composite)group, 0);
        this.m_filterColoringEnableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BrowserPreferencePage.this.updateWidgets();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_colorComp.setLayout((Layout)new RowLayout());
        this.m_colorFieldEditor = new ColorFieldEditor("BACKGROUND_COLOR_KEY", Messages.BrowserPreferencePageFilterColoringColorFieldLabel, this.m_colorComp);
        this.m_colorFieldEditor.getColorSelector().setColorValue(Utils.intToRgb(this.m_store.getInt("BACKGROUND_COLOR_KEY")));
        this.updateWidgets();
    }

    private void updateWidgets() {
        this.m_colorFieldEditor.setEnabled(this.m_filterColoringEnableButton.getSelection(), this.m_colorComp);
    }

    protected void performDefaults() {
        this.m_filterColoringEnableButton.setSelection(this.m_store.getDefaultBoolean("BACKGROUND_COLORING_KEY"));
        this.m_colorFieldEditor.getColorSelector().setColorValue(Utils.intToRgb(this.m_store.getDefaultInt("BACKGROUND_COLOR_KEY")));
        this.updateWidgets();
    }

    public boolean performOk() {
        this.m_store.setValue("BACKGROUND_COLORING_KEY", this.m_filterColoringEnableButton.getSelection());
        this.m_store.setValue("BACKGROUND_COLOR_KEY", Utils.rgbToInt(this.m_colorFieldEditor.getColorSelector().getColorValue()));
        return super.performOk();
    }

    protected void performApply() {
        super.performApply();
    }
}

