/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.layout.table;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.layout.CSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.ICSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.table.TableCellInfo;
import org.eclipse.jst.pagedesigner.css2.layout.table.TableInfo;
import org.eclipse.jst.pagedesigner.css2.layout.table.TableInfoContext;
import org.eclipse.jst.pagedesigner.css2.layout.table.TableItemInfo;
import org.eclipse.jst.pagedesigner.css2.value.Length;

class TableRowInfo
extends TableItemInfo {
    List _cells = new ArrayList();
    int _rowIndex;
    private int _rowHeight;

    public TableRowInfo(ICSSFigure figure) {
        super(figure);
    }

    List getCells() {
        return this._cells;
    }

    int getRowIndex() {
        return this._rowIndex;
    }

    int getSpecifiedRowHeight() {
        return this._rowHeight;
    }

    public void calculateRow(TableInfoContext context) {
        this._rowIndex = context.getCurrentRow();
        List children = this.getFigure().getChildren();
        int i = 0;
        int size = children.size();
        while (i < size) {
            String display;
            ICSSStyle childstyle;
            IFigure childfigure = (IFigure)children.get(i);
            if (childfigure instanceof ICSSFigure && (childstyle = ((ICSSFigure)childfigure).getCSSStyle()) != null && "table-cell".equalsIgnoreCase(display = childstyle.getDisplay())) {
                TableCellInfo cellInfo = new TableCellInfo((ICSSFigure)childfigure);
                cellInfo.calculateCellInfo(context);
                this._cells.add(cellInfo);
            }
            ++i;
        }
        context.finishRow();
    }

    public void getCells(List cells) {
        cells.addAll(this._cells);
    }

    public TableCellInfo getCellInfo(CSSFigure figure) {
        int i = 0;
        int size = this._cells.size();
        while (i < size) {
            TableCellInfo cellinfo = (TableCellInfo)this._cells.get(i);
            if (cellinfo.getFigure() == figure) {
                return cellinfo;
            }
            ++i;
        }
        return null;
    }

    public void calculateHeight(TableInfo info, int tableHeight) {
        ICSSStyle style = this.getFigure().getCSSStyle();
        if (style == null) {
            this._rowHeight = -1;
        } else {
            Object height = style.getStyleProperty("height");
            Length recommendedHeight = height instanceof Length ? (Length)height : null;
            int rh = 0;
            if (recommendedHeight == null || recommendedHeight.getValue() <= 0) {
                rh = 0;
            } else {
                if (!recommendedHeight.isPercentage()) {
                    rh = recommendedHeight.getValue();
                }
                if (rh > 0 && !style.isSizeIncludeBorderPadding()) {
                    rh += style.getBorderInsets().getHeight() + style.getPaddingInsets().getHeight();
                }
            }
            this._rowHeight = rh;
        }
    }
}

