/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jst.jsf.facesconfig.ui.EditorMessages;
import org.eclipse.jst.jsf.facesconfig.ui.util.WebrootUtil;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.ui.PlatformUI;

class ModelLoader {
    private FacesConfigArtifactEdit _edit;
    private Job _loadModelJob;
    private CountDownLatch _modelLoaded = new CountDownLatch(1);

    ModelLoader() {
    }

    public synchronized FacesConfigArtifactEdit getEdit() {
        return this._edit;
    }

    private synchronized void setEdit(FacesConfigArtifactEdit edit) {
        this._edit = edit;
    }

    void waitForLoad(long timeoutMs) throws InterruptedException {
        this._modelLoaded.await(timeoutMs, TimeUnit.MILLISECONDS);
    }

    public synchronized void dispose() {
        ModelLoader.assertOnDisplayThread();
        if (this._loadModelJob != null && this._loadModelJob.getResult() == null) {
            this._loadModelJob.cancel();
        }
        if (this._edit != null) {
            this._edit.dispose();
        }
    }

    public void load(IProject project, IPath path, boolean isWebProject, ModelLoaderComplete signalComplete) {
        ModelLoader.assertOnDisplayThread();
        this._loadModelJob = new ModelLoaderJob(project, path, isWebProject, signalComplete);
        this._loadModelJob.schedule();
    }

    private static void assertOnDisplayThread() {
        if (Thread.currentThread() != PlatformUI.getWorkbench().getDisplay().getThread()) {
            throw new IllegalStateException("ModelLoaderComplete must be called on the UI thread");
        }
    }

    static abstract class ModelLoaderComplete
    implements Runnable {
        private FacesConfigArtifactEdit _edit;

        ModelLoaderComplete() {
        }

        private void setFacesConfigArtifactEdit(FacesConfigArtifactEdit edit) {
            this._edit = edit;
        }

        public final void run() {
            ModelLoader.assertOnDisplayThread();
            this.doRun(this._edit);
        }

        protected abstract void doRun(FacesConfigArtifactEdit var1);
    }

    private class ModelLoaderJob
    extends Job {
        private final IProject _project;
        private final IPath _path;
        private final ModelLoaderComplete _runnable;
        private final boolean _isWebProject;

        ModelLoaderJob(IProject project, IPath path, boolean isWebProject, ModelLoaderComplete signalComplete) {
            super(EditorMessages.ModelLoader_LoadingModelJobName);
            this._project = project;
            this._path = path;
            this._runnable = signalComplete;
            this._isWebProject = isWebProject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            FacesConfigArtifactEdit artifactEdit = this.loadModel(this._project, this._path);
            ModelLoader modelLoader = ModelLoader.this;
            synchronized (modelLoader) {
                if (!monitor.isCanceled()) {
                    ModelLoader.this.setEdit(artifactEdit);
                    this._runnable.setFacesConfigArtifactEdit(artifactEdit);
                    PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)this._runnable);
                } else if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
            }
            ModelLoader.this._modelLoaded.countDown();
            return Status.OK_STATUS;
        }

        private FacesConfigArtifactEdit loadModel(IProject project, IPath modelPath) {
            IContainer[] webContentContainers;
            FacesConfigArtifactEdit edit = null;
            if (this._isWebProject && (webContentContainers = WebrootUtil.getWebContentContainers((IProject)project)) != null) {
                IContainer[] iContainerArray = webContentContainers;
                int n = webContentContainers.length;
                int n2 = 0;
                while (n2 < n) {
                    IContainer webContentContainer = iContainerArray[n2];
                    Assert.isTrue((webContentContainer != null && webContentContainer.exists() ? 1 : 0) != 0);
                    if (webContentContainer.getFullPath().isPrefixOf(modelPath)) {
                        IPath relativePath = modelPath;
                        relativePath = modelPath.removeFirstSegments(webContentContainer.getFullPath().segmentCount());
                        edit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)project, (String)relativePath.toString());
                        break;
                    }
                    ++n2;
                }
            }
            return edit;
        }
    }
}

