/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.jdt.internal.javalite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jst.common.frameworks.CommonFrameworksPlugin;
import org.eclipse.jst.common.jdt.internal.javalite.IJavaProjectLite;
import org.eclipse.jst.common.jdt.internal.javalite.JavaCoreLite;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaLiteUtilities {
    public static final List<IContainer> getJavaSourceContainers(IJavaProjectLite javaProjectLite) {
        IClasspathEntry[] entries = javaProjectLite.readRawClasspath();
        ArrayList<IContainer> containers = new ArrayList<IContainer>();
        IClasspathEntry[] iClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && entry.getPath().segmentCount() > 0) {
                Object container = null;
                container = entry.getPath().segmentCount() == 1 ? ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().segment(0)) : ResourcesPlugin.getWorkspace().getRoot().getFolder(entry.getPath());
                if (!containers.contains(container)) {
                    containers.add((IContainer)container);
                }
            }
            ++n2;
        }
        return containers;
    }

    public static final List<IContainer> getJavaOutputContainers(IJavaProjectLite javaProjectLite) {
        IClasspathEntry[] entries;
        ArrayList<IContainer> containers = new ArrayList<IContainer>();
        IContainer defaultOutputContainer = JavaLiteUtilities.getDefaultJavaOutputContainer(javaProjectLite);
        containers.add(defaultOutputContainer);
        IClasspathEntry[] iClasspathEntryArray = entries = javaProjectLite.readRawClasspath();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer outputContainer;
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && !containers.contains(outputContainer = JavaLiteUtilities.getJavaOutputContainer(javaProjectLite, entry))) {
                containers.add(outputContainer);
            }
            ++n2;
        }
        return containers;
    }

    public static List<IContainer> getJavaOutputContainers(IVirtualComponent virtualComponent) {
        return JavaLiteUtilities.getJavaContainers(virtualComponent, JavaContainerType.OUTPUT);
    }

    public static List<IContainer> getJavaSourceContainers(IVirtualComponent virtualComponent) {
        return JavaLiteUtilities.getJavaContainers(virtualComponent, JavaContainerType.SOURCE);
    }

    private static List<IContainer> getJavaContainers(IVirtualComponent virtualComponent, JavaContainerType javaContainerType) {
        IClasspathEntry[] entries;
        int n;
        if (virtualComponent.isBinary()) {
            return Collections.emptyList();
        }
        IProject project = virtualComponent.getProject();
        try {
            if (!project.hasNature(JavaCoreLite.NATURE_ID)) {
                return Collections.emptyList();
            }
        }
        catch (CoreException e) {
            CommonFrameworksPlugin.logError(e);
            return Collections.emptyList();
        }
        IJavaProjectLite javaProjectLite = JavaCoreLite.create(project);
        ArrayList<IContainer> containers = new ArrayList<IContainer>();
        if (javaContainerType == JavaContainerType.OUTPUT) {
            IVirtualResource[] virtualResources;
            IContainer defaultOutputContainer = JavaLiteUtilities.getDefaultJavaOutputContainer(javaProjectLite);
            IVirtualResource[] iVirtualResourceArray = virtualResources = ComponentCore.createResources((IResource)defaultOutputContainer);
            int n2 = virtualResources.length;
            n = 0;
            while (n < n2) {
                IVirtualResource virtualResource = iVirtualResourceArray[n];
                if (virtualResource.getComponent().equals(virtualComponent)) {
                    containers.add(defaultOutputContainer);
                    break;
                }
                ++n;
            }
        }
        IClasspathEntry[] iClasspathEntryArray = entries = javaProjectLite.readRawClasspath();
        n = entries.length;
        int n3 = 0;
        while (n3 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n3];
            if (entry.getEntryKind() == 3) {
                IProject sourceContainer;
                IPath sourcePath = entry.getPath().removeFirstSegments(1);
                Object object = sourceContainer = sourcePath.segmentCount() == 0 ? project : project.getFolder(sourcePath);
                if (sourceContainer != null) {
                    IVirtualResource[] virtualResources;
                    IVirtualResource[] iVirtualResourceArray = virtualResources = ComponentCore.createResources((IResource)sourceContainer);
                    int n4 = virtualResources.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        IVirtualResource virtualResource = iVirtualResourceArray[n5];
                        if (virtualResource.getComponent().equals(virtualComponent)) {
                            switch (javaContainerType) {
                                case SOURCE: {
                                    if (containers.contains(sourceContainer)) break;
                                    containers.add((IContainer)sourceContainer);
                                    break;
                                }
                                case OUTPUT: {
                                    IContainer outputContainer = JavaLiteUtilities.getJavaOutputContainer(javaProjectLite, entry);
                                    if (containers.contains(outputContainer)) break;
                                    containers.add(outputContainer);
                                }
                            }
                        }
                        ++n5;
                    }
                }
            }
            ++n3;
        }
        return containers;
    }

    public static IContainer getDefaultJavaOutputContainer(IJavaProjectLite javaProjectLite) {
        IProject project = javaProjectLite.getProject();
        IPath defaultOutputPath = javaProjectLite.readOutputLocation();
        if (defaultOutputPath.segmentCount() == 1) {
            return project;
        }
        return project.getFolder(defaultOutputPath.removeFirstSegments(1));
    }

    public static IContainer getJavaOutputContainer(IJavaProjectLite javaProjectLite, IClasspathEntry entry) {
        IProject project = javaProjectLite.getProject();
        IPath outputPath = entry.getOutputLocation();
        if (outputPath != null) {
            return project.getFolder(outputPath.removeFirstSegments(1));
        }
        return JavaLiteUtilities.getDefaultJavaOutputContainer(javaProjectLite);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum JavaContainerType {
        SOURCE,
        OUTPUT;

    }
}

